#version 330 core

// fragment shader

smooth in vec2 UV;
smooth in vec4 vEyeSpacePos;
smooth in vec4 aPos;

smooth in vec3 vNormal;
smooth in vec3 vWorldPos;


out vec4 color;





uniform sampler2D myTextureSampler;

uniform float hrad;
uniform vec3  hole;

uniform int level=0;// 0=none, 1=>normal, 2=>heavy, 3=>extreme FOG
uniform int colr=0; // 0=true, 1=>grayish, 2=>brownish, 3=>purpleish FOG
uniform int darkness=0; // 0...4=darkest (bkgd)

const vec4 night = vec4(0.0,0.0,0.0,1.0);

const float fStart=0.0;
const float fEnd=8.0; // normal fog
const float sEnd=4.0; // heavy fog
const float xEnd=2.0; // extreme fog

const vec4 vFogColor=vec4(0.7,0.7,0.7,1.0); //normal white/gray
const vec4 vSootColor=vec4(50.0/255,30.0/255,10.0/255,1.0); // brownish soot
const vec4 vMystColor=vec4(0.7,0.5,0.7,1.0); // purplish fog

float getFogFactor(float fFogCoord)
{
	float fResult = 0.0;

	if(level==3) // extreme fog
		fResult = (xEnd-fFogCoord)/(xEnd-fStart);

	else if(level==2) // heavy fog
		fResult = (sEnd-fFogCoord)/(sEnd-fStart);

	else if(level==1) // normal fog
		fResult = (fEnd-fFogCoord)/(fEnd-fStart);
	else
		fResult=1.0;
	
	fResult = 1.0-clamp(fResult, 0.0, 1.0);
	
	return fResult;
}




bool insideSphere( vec3 cc, vec3 pt )
{
	float dist2 = 
		(cc.x-pt.x)*(cc.x-pt.x) +
		(cc.y-pt.y)*(cc.y-pt.y) +
		(cc.z-pt.z)*(cc.z-pt.z);
	if( dist2<hrad*hrad ) return true;
	else return false;
}









////// begin lighting uniforms ///////////

uniform int lightFlag=0; // 0=>no, 1=>yes  #2

/////// begin point-light ///////
uniform vec3 vPtColor; // 254:203:33   #3
uniform vec3 vPos1;          // #4
uniform vec3 vPos2;          // #5
uniform vec3 vPos3;          // #6
//uniform float fPtAmbient;
//uniform float fPtConstantAtt;
//uniform float fPtLinearAtt;
//uniform float fPtQuadAtt;
const float fPtAmbient = 16.0;
const float fPtConstantAtt = 0.0;
const float fPtLinearAtt = 2.0;
const float fPtQuadAtt = 0.0;
////// end point-light //////////////////


////// begin directional-light //////
//uniform vec3 vDirColor;
//uniform vec3 vDirection;
//uniform float fDirAmbient;
//uniform float fDirStrength; // to ignore, set this to zero

const vec3 vDirColor = vec3(1.0,1.0,1.0);
const vec3 vDirection = vec3(0.0,-1.0,0.0);
const float fDirAmbient = 1.0;
const float fDirStrength = 0.0;
//////// end directional-light ////////////


////// end lighting uniforms ///////////




//////// begin lighting ftns /////////////////////////


vec4 getPointLightColor()
{
	vec3 vPosToLight1 = vWorldPos-vPos1;
	float fDist1 = length(vPosToLight1);
	vPosToLight1 = normalize(vPosToLight1);

	vec3 vPosToLight2 = vWorldPos-vPos2;
	float fDist2 = length(vPosToLight2);
	vPosToLight2 = normalize(vPosToLight2);

	vec3 vPosToLight3 = vWorldPos-vPos3;
	float fDist3 = length(vPosToLight3);
	vPosToLight3 = normalize(vPosToLight3);

	float fDist = (fDist1+fDist2+fDist3)/3.0;

	float fDiffuse1 = max(0.0, dot(vNormal, -vPosToLight1));
	float fDiffuse2 = max(0.0, dot(vNormal, -vPosToLight2));
	float fDiffuse3 = max(0.0, dot(vNormal, -vPosToLight3));

	float fAttTotal = 
		fPtConstantAtt 
		+ fPtLinearAtt*fDist 
		+ fPtQuadAtt*fDist*fDist;

	return 
		vec4(vPtColor, 1.0)
		* (fPtAmbient+fDiffuse1+fDiffuse2+fDiffuse3)/fAttTotal;
}


vec4 getDirectionalLightColor()
{
	float fDiffuse = max(0.0, dot(vNormal, -vDirection));
	return vec4(
		vDirColor
		* (fDirAmbient+fDiffuse)
		* fDirStrength, 
		1.0);
}


//////// end lighting ftns /////////////////////////













void main(){
	color = texture( myTextureSampler, UV).rgba;
	if(color.a < 0.1) discard;

	if( hrad>0.1 ){
		if( insideSphere(hole,aPos.xyz) ) color.a=0.0;
	}



	float dist = length( vEyeSpacePos.xz );
	float distr = sqrt(dist);
	float fFogCoord = sqrt((3.0-aPos.y)/6.0) * distr/vEyeSpacePos.w;

	if( colr==3 )
		color = mix(color, vMystColor, getFogFactor(fFogCoord));
	else if( colr==2 )
		color = mix(color, vSootColor, getFogFactor(fFogCoord));
	else if( colr==1 )
		color = mix(color, vFogColor, getFogFactor(fFogCoord));


	float df=0;
	if( darkness < 1 ) df=0.0;
	else if( darkness==1 ) df=0.3;
	else if( darkness==2 ) df=0.6;
	else if( darkness==3 ) df=0.8;
	else if( darkness>3 ) df=0.9;
	float asave=color.a;
	color = mix(color, night, df);
	color.a = asave;


	// lighting addendum:
	if( lightFlag > 0 ) { // use light effects

		vec4 vTexColor = color;
		vec4 vLightColor = 
			getDirectionalLightColor() +
			getPointLightColor();
			
		color = vTexColor*vLightColor;

	}



}



//--
//-- Copyright (C) 2017  <fastrgv@gmail.com>
//--
//-- This program is free software: you can redistribute it and/or modify
//-- it under the terms of the GNU General Public License as published by
//-- the Free Software Foundation, either version 3 of the License, or
//-- (at your option) any later version.
//--
//-- This program is distributed in the hope that it will be useful,
//-- but WITHOUT ANY WARRANTY; without even the implied warranty of
//-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//-- GNU General Public License for more details.
//--
//-- You may read the full text of the GNU General Public License
//-- at <http://www.gnu.org/licenses/>.
//--

