
--
-- Copyright (C) 2017  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--



separate (avent)

procedure draw_exterior(chapter: integer) is
	dt, yy: float;

	yb1,yb2, yb3, yb4,yb5,yb6,

	xt1c,yt1c,zt1c, 
	xt2c,yt2c,zt2c, 
	xt3c,yt3c,zt3c,

	xt4c,yt4c,zt4c, 
	xt5c,yt5c,zt5c, 
	xt6c,yt6c,zt6c,

	xt1r,yt1r,zt1r, 
	xt2r,yt2r,zt2r, 
	xt3r,yt3r,zt3r,

	xt4r,yt4r,zt4r, 
	xt5r,yt5r,zt5r, 
	xt6r,yt6r,zt6r 

		: glfloat;
begin

		-- begin draw common textured objects---------------------------


	if chapter=1 then
		darkness:=2; --dark, cloudy
		if schalice=1 or schalice=2 or (scene=1 and chaliceheld) then
			darkness:=1; --sunny (flag for near-success)
		end if;
	elsif chapter=2 then
		darkness:=1; -- bright, cloudy
		if schalice=1 or schalice=2 or (scene=1 and chaliceheld) then
			darkness:=2; --nighttime (flag for near-success)
		end if;
	end if;


	-- draw terrain:
		glUseProgram(pidterra);
		glUniformMatrix4fv(mMatrixID, 1, GL_FALSE, imvp(1,1)'address);
		glUniform1i(muniftex, 0);
		glUniform1i(munifdark, darkness);

	-- now choose a texture...
	-- grass_texid:  nice but too manicured looking
	-- sand1_texid:  awesome but garden setting is desired
	-- sand2_texid:  good but too dry also
	if chapter=1 then
		if darkness<2 then --near success
			glBindTexture(GL_TEXTURE_2D, grass_texid); -- lush, greener
		else
			glBindTexture(GL_TEXTURE_2D, grass1_texid); -- more undeveloped
		end if;
	elsif chapter=2 then
		if darkness>1 then --near success
			glBindTexture(GL_TEXTURE_2D, grass_texid); -- lush, greener
		else
			glBindTexture(GL_TEXTURE_2D, grass1_texid); -- more undeveloped
		end if;
	end if;
		terrain.Draw(grounds,vertbuff,uvbuff,elembuff);





		--castle walls
		glbindtexture(gl_texture_2d, stone_texid);
		for i in 4..19 loop
			rectobj.draw(wallblok(i), vertbuff,uvbuff,elembuff);
		end loop;

		-- maze walls
		glbindtexture(gl_texture_2d, mazeouter_texid);
		rectobj.draw(wallxp, vertbuff,uvbuff,elembuff);
		rectobj.draw(wallzp, vertbuff,uvbuff,elembuff);

		-- maze door
		glbindtexture(gl_texture_2d, doortw_texid);
		pictobj.draw(omazedoor, vertbuff,uvbuff,elembuff);



		-- castle entry gates

		if zmup then -- ZM gate rising

			elapsed := currenttime-lifttime;
			tt := elapsed/liftduration;
			if tt>1.0 then gatewait:=false; zmup:=false; tt:=1.0; end if;
			yg := 1.1*tt + 0.4*(1.0-tt);
			pictobj.setrect( 
				gatezm, 
				xgzm, yg, zgzm, --xc,yc,zc
				0.4, 0.4, 0.0, --xr,yr,zr
				koxlo(gzmk),koxhi(gzmk),koylo(gzmk),
				koyhi(gzmk),kozlo(gzmk),kozhi(gzmk) );

		end if;



		if mazegoingup then -- Z- gate rising

			elapsed := currenttime-mazetime;
			tt := elapsed/liftduration;
			yy := ymaze+tt*0.6;
			if tt>1.0 then 
				mazewait:=false;
				mazeopen:=true;
				mazegoingup:=false; 
				tt:=1.0; 
			end if;

			pictobj.setrect( 
				gatem1, 
				xmaze, yy, zmaze-0.3, --xc,yc,zc
				0.3, 0.3, 0.01, --xr,yr,zr
				koxlo(gk1),koxhi(gk1),koylo(gk1),
				koyhi(gk1),kozlo(gk1),kozhi(gk1) );

			--pictobj.setrect( 
			--	gatem2, 
			--	xmaz2, yy, zmaz2, --xc,yc,zc
			--	0.01, 0.3, 0.3, --xr,yr,zr
			--	koxlo(gk2),koxhi(gk2),koylo(gk2),
			--	koyhi(gk2),kozlo(gk2),kozhi(gk2) );


		end if;






		glbindtexture(gl_texture_2d, gate_texid);

			--castle gate:
			pictobj.draw(gatezm, vertbuff,uvbuff,elembuff);

			--maze gates:
			pictobj.draw(gatem1, vertbuff,uvbuff,elembuff);
			pictobj.draw(gatem2, vertbuff,uvbuff,elembuff);









		if not gkeyheld and sgkey=1  then
			glbindtexture(gl_texture_2d, gkey_texid);
			pictobj.draw(key3, vertbuff,uvbuff,elembuff);
		end if;


		if not bkeyheld and sbkey=1 and not bathasbkey then
			glbindtexture(gl_texture_2d, bkey_texid);
			pictobj.draw(key2, vertbuff,uvbuff,elembuff);
		end if;

		if not wkeyheld and swkey=1 and not bathaswkey then
			glbindtexture(gl_texture_2d, key_texid);
			pictobj.draw(key1, vertbuff,uvbuff,elembuff);
		end if;

		if not swordheld and ssword=1 then
			glbindtexture(gl_texture_2d, sword_texid);
			pictobj.draw(sword, vertbuff,uvbuff,elembuff);
		end if;



		-- draw other normal rectobj or pictobj here








--////////////// draw cube-mapped skybox //////////////////////////////////

		glUseProgram(pidSkyB);
		glUniform1i(sbmapUID, 0);
		glUniformMatrix4fv(sbmvpUID, 1, GL_FALSE, mmvp(1,1)'address);
		glEnable(GL_TEXTURE_CUBE_MAP);

		if chapter=1 then
			if darkness<2 then -- near success
				glBindTexture(GL_TEXTURE_CUBE_MAP, sunnycubemap_texid);
			else
				glBindTexture(GL_TEXTURE_CUBE_MAP, darkcubemap_texid);
			end if;
		elsif chapter=2 then
			if darkness>1 then -- near success
				glBindTexture(GL_TEXTURE_CUBE_MAP, mooncubemap_texid);
			else
				glBindTexture(GL_TEXTURE_CUBE_MAP, cloudycubemap_texid);
			end if;
		end if;

		cubemapobj.Draw(skybox, vertbuff,elembuff);




		if drawchalice and schalice=1 and not chaliceheld then
		-- use uniforms to set position
			glUseProgram(cupTexShadID);

			gluniform1i(cupFlag, 0 ); --no light effects


			glUniform1f(cupunifang, 0.0);

			glUniformMatrix4fv(cupMatrixID, 1, GL_FALSE, imvp(1,1)'address);
			glUniform1i(cupuniftex, 0);
			glUniform1i(cupunifdark, darkness);
			glUniform3f(cupcenid, xchalice,ychalice,zchalice );
			glUniform3f(cupradid, wcup, hcup, wcup );


		gluniform1i(cupuniflev, interfaces.c.int(0) ); 
		-- 0=>none, 1=>normal, 2=>dense, 3=>extreme fog

		gluniform1i(cupunifclr, interfaces.c.int(0) ); 
		-- 0=>true color, 1=>grayish, 2=>brownish, 3=>purple fog

		glUniformMatrix4fv(cupmvid, 1, GL_FALSE, imv(1,1)'address);



			glbindtexture(gl_texture_2d, chalice_texid);
			xtreeobj.draw(chalice, vertbuff,uvbuff,elembuff);
		end if;


	if scene=1 then

			showingGlyph:=false;

		-- glyphs drawn @ screen center
		if gkeyheld then --draw key
			utex.print2d("^",0.5,0.5,50); -- "^" => green key
			showingGlyph:=true;

		elsif bkeyheld then --draw key
			utex.print2d("|",0.5,0.5,50); -- "|" => black key
			showingGlyph:=true;

		elsif wkeyheld then --draw key
			utex.print2d("~",0.5,0.5,50); -- "~" => white key
			showingGlyph:=true;

		elsif swordheld then --draw sword
			utex.print2d("=",0.5,0.5,120); -- "=" => sword
			showingGlyph:=true;

		elsif chaliceheld then --draw chalice
			utex.print2d(";",0.5,0.5,80); -- ";" => chalice
			showingGlyph:=true;
		end if;

		if 
			(gkeynear or bkeynear or wkeynear or swordnear or chalicenear)
			and not gatewait and not lionwait and not mazewait
		then
			utex.print2d("`",0.5,0.4,50); -- "`" = hand
			showingHand:=true;
		else
			showingHand:=false;
		end if;

	end if;

-- 6 tree locations:
xt1c:=13.0;
zt1c:=3.0;

xt2c:=10.0;
zt2c:=3.0;

xt3c:=4.0; --7.0;
zt3c:=4.0; --3.0;


xt4c:=3.0;
zt4c:=13.0;

xt5c:=3.0;
zt5c:=10.0;

xt6c:=3.0; 
zt6c:=7.0;



-- 6 tree sizes, vertical positions
xt1r:=1.3;
zt1r:=1.3;
yt1r:=2.0;
yt1c:=yt1r+glfloat(land_alt(float(xt1c),float(zt1c)));
yb1:=yt1c-yt1r;

xt2r:=1.4;
zt2r:=1.4;
yt2r:=1.0;
yt2c:=yt2r+glfloat(land_alt(float(xt2c),float(zt2c)));
yb2:=yt2c-yt2r;

xt3r:=1.4;
zt3r:=1.4;
yt3r:=1.0;
yt3c:=yt3r+glfloat(land_alt(float(xt3c),float(zt3c)));
yb3:=yt3c-yt3r;



xt4r:=1.3;
zt4r:=1.3;
yt4r:=2.0;
yt4c:=yt4r+glfloat(land_alt(float(xt4c),float(zt4c)));
yb4:=yt4c-yt4r;

xt5r:=1.4;
zt5r:=1.4;
yt5r:=1.0;
yt5c:=yt5r+glfloat(land_alt(float(xt5c),float(zt5c)));
yb5:=yt5c-yt5r;

xt6r:=1.4;
zt6r:=1.4;
yt6r:=1.0;
yt6c:=yt6r+glfloat(land_alt(float(xt6c),float(zt6c)));
yb6:=yt6c-yt6r;










--draw trees
for k in 1..2 loop
	if k=1 then
		gldepthmask(gl_false);
	end if;

		glUseProgram(treeTexShadID);
		glUniformMatrix4fv(treeMatrixID, 1, GL_FALSE, imvp(1,1)'address);
		glUniform1i(treeuniftex, 0);
		glUniform1i(treeunifdark, darkness);
		glUniform1f(treeuniftime, glfloat(currentTime) ); 
		--shader makes them sway

		glEnable(GL_BLEND);
		glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);

			----------------------------------------------------
			glUniform3f(treecenid, xt1c,yt1c,zt1c );
			glUniform3f(treeradid, xt1r,yt1r,zt1r );
			glUniform1f( treebaseunifid, yb1 );

			glUniform1i(treeunifid, glint(1) );
			--glBindTexture(GL_TEXTURE_2D, tpalm_texid);
			glBindTexture(GL_TEXTURE_2D, tree1_texid);
			xtreeobj.Draw( tree, vertbuff,uvbuff,elembuff);

			----------------------------------------------------
			glUniform3f(treecenid, xt2c,yt2c,zt2c );
			glUniform3f(treeradid, xt2r,yt2r,zt2r );
			glUniform1f( treebaseunifid, yb2 );

			glUniform1i(treeunifid, glint(2) );
			--glBindTexture(GL_TEXTURE_2D, spalm_texid);
			glBindTexture(GL_TEXTURE_2D, tree2_texid);
			xtreeobj.Draw( tree, vertbuff,uvbuff,elembuff);

			----------------------------------------------------
			glUniform3f(treecenid, xt3c,yt3c,zt3c );
			glUniform3f(treeradid, xt3r,yt3r,zt3r );
			glUniform1f( treebaseunifid, yb3 );

			glUniform1i(treeunifid, glint(3) );
			glBindTexture(GL_TEXTURE_2D, tree3_texid);
			xtreeobj.Draw( tree, vertbuff,uvbuff,elembuff);

			----------------------------------------------------


			glUniform3f(treecenid, xt4c,yt4c,zt4c );
			glUniform3f(treeradid, xt4r,yt4r,zt4r );
			glUniform1f( treebaseunifid, yb4 );

			glUniform1i(treeunifid, glint(4) );
			glBindTexture(GL_TEXTURE_2D, tree4_texid);
			xtreeobj.Draw( tree, vertbuff,uvbuff,elembuff);

			----------------------------------------------------
			glUniform3f(treecenid, xt5c,yt5c,zt5c );
			glUniform3f(treeradid, xt5r,yt5r,zt5r );
			glUniform1f( treebaseunifid, yb5 );

			glUniform1i(treeunifid, glint(5) );
			glBindTexture(GL_TEXTURE_2D, tree5_texid);
			xtreeobj.Draw( tree, vertbuff,uvbuff,elembuff);

			----------------------------------------------------
			glUniform3f(treecenid, xt6c,yt6c,zt6c );
			glUniform3f(treeradid, xt6r,yt6r,zt6r );
			glUniform1f( treebaseunifid, yb6 );

			glUniform1i(treeunifid, glint(6) );
			glBindTexture(GL_TEXTURE_2D, spalm_texid);
			xtreeobj.Draw( tree, vertbuff,uvbuff,elembuff);

			----------------------------------------------------












	if k=1 then
		gldepthmask(gl_true);
	end if;
end loop; --trees





---------------- begin bat insert ------------------

		if batfly and scene=1 then --draw flying bat as per gun-beam
			dt:=-0.5+1.5*(currenttime-batstart)/batduration; -- -0.5..+1.0

			if dt>0.0 and not batested1 then
				batested1:=true;

				if not bathaswkey and not wkeyheld then 
					bathaswkey:=true;
					-- this flag being false indicates the bat
					-- succeeded in grabbing key from the ground!
				end if;

			end if;

			if dt>=1.0 then
				batfly:=false;
				if not wkeyheld and bathaswkey then
					--bat drops key onto ground
					xwkey:=xbat;
					zwkey:=zbat;
					ywkey:=htobj+land_alt(xwkey,zwkey);

					pictobj.setrect( 
						key1, 
						xwkey,ywkey,zwkey, --xc,yc,zc
						0.1, 0.0, 0.1, --xr,yr,zr
						j1,j2,j3,j4,j5,j6);
				end if;
				bathaswkey:=false;
			else --draw bat
				drawbat(dt);
			end if;
		end if; --batfly



---------- end draw common textured objects----------------------------



end draw_exterior;


