#!/usr/bin/env python3
# encoding: utf-8
# === This file is part of Calamares - <http://github.com/calamares> ===
#
#   Copyright 2014 - 2015, Philip Müller <philm@manjaro.org>
#
#   Calamares is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
#
#   Calamares is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with Calamares. If not, see <http://www.gnu.org/licenses/>.

import os
import subprocess

import libcalamares

import shutil

def run():
    """ Misc postinstall configurations """

    install_path = libcalamares.globalstorage.value( "rootMountPoint" )

    gma500_mod_loaded=True
    try:
        subprocess.check_call(["/usr/bin/test-modloaded", "gma500_gfx"])
    except subprocess.CalledProcessError as e:
        gma500_mod_loaded=False
        
    if gma500_mod_loaded:
        os.system("cp /etc/X11/xorg.conf.d/20-gpudriver.conf {!s}/etc/X11/xorg.conf.d/20-gpudriver.conf".format(install_path))
    elif os.path.exists("{!s}/etc/X11/xorg.conf.d/20-gpudriver.conf".format(install_path)):
        os.system("rm {!s}/etc/X11/xorg.conf.d/20-gpudriver.conf".format(install_path))

    if not gma500_mod_loaded:
        os.system("rm {!s}/etc/modprobe.d/uvesafb.conf".format(install_path))

    vboxguest_mod_loaded=True
    try:
        subprocess.check_call(["/usr/bin/test-modloaded", "vboxguest"])
    except subprocess.CalledProcessError as e:
        vboxguest_mod_loaded=False
        
    if not vboxguest_mod_loaded:
        libcalamares.utils.check_target_env_call(["pacman", "-Rs", "--noconfirm", "virtualbox-guest-modules-arch", "virtualbox-guest-utils"])

    libcalamares.utils.target_env_call(["rm", "-rf", "/etc/initcpio"])
    libcalamares.utils.target_env_call(["rm", "/etc/udev/rules.d/61-rfkill.rules"])

    # Dock

    username = libcalamares.globalstorage.value( "username" )
    #instdock = libcalamares.globalstorage.value( "dockpref" )
    instdock = "org.kde.latte-dock.desktop"

    #os.system("sed -i 's/bslx/{!s}/g' {!s}/home/{!s}/.config/plasma-org.kde.plasma.desktop-appletsrc".format(username, install_path, username))

    usercfg = "/home/" + username + "/.config/"
    rootcfg = "/root/.config/"
    skelcfg = "/etc/skel/.config/"

    autostartdesktop = "/usr/share/applications/" + instdock

    #
    # /home/userid/.config/autostart
    #

    userautostartdir = usercfg + "autostart"

    os.system("rm {!s}/{!s}/*.desktop".format(install_path, userautostartdir))
    #libcalamares.utils.target_env_call(["cp", autostartdesktop, userautostartdir])

    userautostartlink = userautostartdir + "/" + instdock
    libcalamares.utils.target_env_call(["ln", "-sf", autostartdesktop, userautostartlink])

    chown = username + ":" + username

    libcalamares.utils.target_env_call(["chown", "-h", chown, userautostartlink])

    #
    # /root/.config/autostart
    #

    rootautostartdir = rootcfg + "autostart"

    os.system("rm {!s}/{!s}/*.desktop".format(install_path, rootautostartdir))
    #libcalamares.utils.target_env_call(["cp", autostartdesktop, rootautostartdir])

    rootautostartlink = rootautostartdir + "/" + instdock
    libcalamares.utils.target_env_call(["ln", "-sf", autostartdesktop, rootautostartlink])

    #
    # /etc/skel/.config/autostart
    #

    skelautostartdir = skelcfg + "autostart"

    os.system("rm {!s}/{!s}/*.desktop".format(install_path, skelautostartdir))
    #libcalamares.utils.target_env_call(["cp", autostartdesktop, skelautostartdir])

    skelautostartlink = skelautostartdir + "/" + instdock
    libcalamares.utils.target_env_call(["ln", "-sf", autostartdesktop, skelautostartlink])

    #
    # lattedock default layout
    #

    version = libcalamares.globalstorage.value("bslxInstallation")
    if version != "basic":
        latterc = "/etc/install.d/lattedock-appletsrc." + version

        #userlrc = usercfg + "latte/'My Layout.layout.latte'"
        #rootlrc = rootcfg + "latte/'My Layout.layout.latte'"
        #skellrc = rootcfg + "latte/'My Layout.layout.latte'"

        userlrc = usercfg + "latte/Bluestar.layout.latte"
        rootlrc = rootcfg + "latte/Bluestar.layout.latte"
        skellrc = rootcfg + "latte/Bluestar.layout.latte"

        libcalamares.utils.target_env_call(["cp", latterc, userlrc])

        chown_path = "/home/" + username + "/.config/latte/Bluestar.layout.latte"
        libcalamares.utils.target_env_call(["chown", chown, chown_path])

        libcalamares.utils.target_env_call(["cp", latterc, skellrc])
        libcalamares.utils.target_env_call(["cp", latterc, rootlrc])

        libcalamares.utils.target_env_call(["rm", "-rf", "/etc/install.d"])

    return None

def cmdline(command):
    process = subprocess.Popen(
        args=command,
        stdout=subprocess.PIPE,
        shell=True,
        universal_newlines=True
    )
    return process.communicate()[0]

