/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.collection;

import org.jacorb.collection.IteratorFactory;
import org.jacorb.collection.KeyComparator;
import org.jacorb.collection.KeyNode;
import org.jacorb.collection.OrderedCollectionImpl;
import org.jacorb.collection.PositionalIteratorImpl;
import org.jacorb.collection.util.ObjectInvalid;
import org.jacorb.collection.util.SortedVector;
import org.omg.CORBA.Any;
import org.omg.CORBA.AnyHolder;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.TypeCode;
import org.omg.CosCollection.AnySequenceHolder;
import org.omg.CosCollection.ElementInvalid;
import org.omg.CosCollection.ElementInvalidReason;
import org.omg.CosCollection.EmptyCollection;
import org.omg.CosCollection.Iterator;
import org.omg.CosCollection.IteratorInBetween;
import org.omg.CosCollection.IteratorInvalid;
import org.omg.CosCollection.KeyCollection;
import org.omg.CosCollection.KeyInvalid;
import org.omg.CosCollection.KeySortedCollectionOperations;
import org.omg.CosCollection.OperationsOperations;
import org.omg.CosCollection.PositionInvalid;
import org.omg.PortableServer.POA;

class KeySortedCollectionImpl
extends OrderedCollectionImpl
implements KeySortedCollectionOperations {
    protected SortedVector keys;
    protected KeyNode test_key = new KeyNode();

    KeySortedCollectionImpl(OperationsOperations ops, POA poa, IteratorFactory iterator_factory) {
        super(ops, poa, iterator_factory);
        this.keys = new SortedVector(new KeyComparator(ops));
    }

    @Override
    public TypeCode key_type() {
        return this.ops.key_type();
    }

    @Override
    public synchronized boolean contains_element_with_key(Any key) throws KeyInvalid {
        this.check_key(key);
        this.test_key.key = key;
        try {
            return this.keys.indexOf(this.test_key) >= 0;
        }
        catch (ObjectInvalid e) {
            throw new KeyInvalid();
        }
    }

    @Override
    public synchronized boolean contains_all_keys_from(KeyCollection collector) throws KeyInvalid {
        throw new NO_IMPLEMENT();
    }

    @Override
    public synchronized boolean locate_or_add_element_with_key(Any element) throws ElementInvalid {
        this.check_element(element);
        this.test_key.key = this.ops.key(element);
        try {
            if (this.keys.indexOf(this.test_key) < 0) {
                return this.add_element(element);
            }
            return false;
        }
        catch (ObjectInvalid e) {
            throw new ElementInvalid(ElementInvalidReason.element_type_invalid);
        }
    }

    @Override
    public synchronized boolean locate_or_add_element_with_key_set_iterator(Any element, Iterator where) throws ElementInvalid, IteratorInvalid {
        this.check_element(element);
        this.test_key.key = this.ops.key(element);
        try {
            if (this.keys.indexOf(this.test_key) < 0) {
                return this.add_element_set_iterator(element, where);
            }
            return false;
        }
        catch (ObjectInvalid e) {
            throw new ElementInvalid(ElementInvalidReason.element_type_invalid);
        }
    }

    @Override
    public synchronized boolean add_or_replace_element_with_key(Any element) throws ElementInvalid {
        this.check_element(element);
        this.test_key.key = this.ops.key(element);
        try {
            int pos = this.keys.indexOf(this.test_key);
            pos = ((KeyNode)this.keys.elementAt((int)pos)).start_position;
            if (pos < 0) {
                return this.add_element(element);
            }
            this.element_replace(pos, element);
            return false;
        }
        catch (ObjectInvalid e) {
            throw new ElementInvalid(ElementInvalidReason.element_type_invalid);
        }
        catch (PositionInvalid e) {
            throw new ElementInvalid(ElementInvalidReason.positioning_property_invalid);
        }
    }

    @Override
    public synchronized boolean add_or_replace_element_with_key_set_iterator(Any element, Iterator where) throws ElementInvalid, IteratorInvalid {
        this.check_element(element);
        this.test_key.key = this.ops.key(element);
        try {
            int pos = this.keys.indexOf(this.test_key);
            pos = ((KeyNode)this.keys.elementAt((int)pos)).start_position;
            if (pos < 0) {
                return this.add_element_set_iterator(element, where);
            }
            PositionalIteratorImpl i = this.check_iterator(where);
            this.element_replace(pos, element);
            i.set_pos(pos);
            i.set_in_between(false);
            return false;
        }
        catch (ObjectInvalid e) {
            throw new ElementInvalid(ElementInvalidReason.element_type_invalid);
        }
        catch (PositionInvalid e) {
            throw new ElementInvalid(ElementInvalidReason.positioning_property_invalid);
        }
    }

    @Override
    public synchronized boolean remove_element_with_key(Any key) throws KeyInvalid {
        this.check_key(key);
        this.test_key.key = key;
        try {
            int pos = this.keys.indexOf(this.test_key);
            if (pos < 0) {
                return false;
            }
            pos = ((KeyNode)this.keys.elementAt((int)pos)).start_position;
            this.element_remove(pos);
            return true;
        }
        catch (ObjectInvalid e) {
            throw new KeyInvalid();
        }
        catch (EmptyCollection e) {
            throw new KeyInvalid();
        }
        catch (PositionInvalid e) {
            throw new KeyInvalid();
        }
    }

    @Override
    public synchronized int remove_all_elements_with_key(Any key) throws KeyInvalid {
        this.check_key(key);
        this.test_key.key = key;
        try {
            int pos = this.keys.indexOf(this.test_key);
            if (pos < 0) {
                return 0;
            }
            KeyNode node = (KeyNode)this.keys.elementAt(pos);
            pos = node.start_position;
            for (int i = node.count; i > 0; --i) {
                this.element_remove(pos + i - 1);
            }
            return node.count;
        }
        catch (ObjectInvalid e) {
            throw new KeyInvalid();
        }
        catch (EmptyCollection e) {
            throw new KeyInvalid();
        }
        catch (PositionInvalid e) {
            throw new KeyInvalid();
        }
    }

    @Override
    public synchronized boolean replace_element_with_key(Any element) throws ElementInvalid {
        this.check_element(element);
        this.test_key.key = this.ops.key(element);
        try {
            int pos = this.keys.indexOf(this.test_key);
            if (pos < 0) {
                return false;
            }
            KeyNode node = (KeyNode)this.keys.elementAt(pos);
            pos = node.start_position;
            this.element_replace(pos, element);
            return true;
        }
        catch (ObjectInvalid e) {
            throw new ElementInvalid(ElementInvalidReason.element_type_invalid);
        }
        catch (PositionInvalid e) {
            throw new ElementInvalid(ElementInvalidReason.positioning_property_invalid);
        }
    }

    @Override
    public synchronized boolean replace_element_with_key_set_iterator(Any element, Iterator where) throws ElementInvalid, IteratorInvalid {
        this.check_element(element);
        PositionalIteratorImpl i = this.check_iterator(where);
        this.test_key.key = this.ops.key(element);
        try {
            int pos = this.keys.indexOf(this.test_key);
            if (pos < 0) {
                return false;
            }
            KeyNode node = (KeyNode)this.keys.elementAt(pos);
            pos = node.start_position;
            this.element_replace(pos, element);
            i.set_pos(pos);
            i.set_in_between(false);
            return true;
        }
        catch (ObjectInvalid e) {
            throw new ElementInvalid(ElementInvalidReason.element_type_invalid);
        }
        catch (PositionInvalid e) {
            throw new ElementInvalid(ElementInvalidReason.positioning_property_invalid);
        }
    }

    @Override
    public synchronized boolean retrieve_element_with_key(Any key, AnyHolder element) throws KeyInvalid {
        this.check_key(key);
        this.test_key.key = key;
        try {
            int pos = this.keys.indexOf(this.test_key);
            if (pos < 0) {
                return false;
            }
            KeyNode node = (KeyNode)this.keys.elementAt(pos);
            pos = node.start_position;
            element.value = this.element_retrieve(pos);
            return true;
        }
        catch (ObjectInvalid e) {
            throw new KeyInvalid();
        }
        catch (PositionInvalid e) {
            throw new KeyInvalid();
        }
    }

    @Override
    public synchronized void key(Any element, AnyHolder a_key) throws ElementInvalid {
        this.check_element(element);
        a_key.value = this.ops.key(element);
    }

    @Override
    public synchronized void keys(Any[] elements, AnySequenceHolder a_keys) throws ElementInvalid {
        int i;
        for (i = 0; i < elements.length; ++i) {
            this.check_element(elements[i]);
        }
        a_keys.value = new Any[elements.length];
        for (i = 0; i < elements.length; ++i) {
            a_keys.value[i] = this.ops.key(elements[i]);
        }
    }

    @Override
    public synchronized boolean locate_element_with_key(Any key, Iterator where) throws KeyInvalid, IteratorInvalid {
        this.check_key(key);
        PositionalIteratorImpl i = this.check_iterator(where);
        this.test_key.key = key;
        try {
            int pos = this.keys.indexOf(this.test_key);
            if (pos < 0) {
                i.invalidate();
                return false;
            }
            KeyNode node = (KeyNode)this.keys.elementAt(pos);
            i.set_pos(node.start_position);
            i.set_in_between(false);
            return true;
        }
        catch (ObjectInvalid e) {
            throw new KeyInvalid();
        }
    }

    @Override
    public synchronized boolean locate_next_element_with_key(Any key, Iterator where) throws KeyInvalid, IteratorInvalid {
        int new_pos;
        this.check_key(key);
        PositionalIteratorImpl i = this.check_iterator(where);
        i.check_invalid();
        int pos = i.get_pos();
        int n = new_pos = i.is_in_between() ? pos : pos + 1;
        if (this.data.size() <= new_pos) {
            i.invalidate();
        }
        this.test_key.key = key;
        Any this_key = this.ops.key((Any)this.data.elementAt(new_pos));
        if (this.ops.key_equal(key, this_key)) {
            i.set_pos(new_pos);
            i.set_in_between(false);
            return true;
        }
        i.invalidate();
        return false;
    }

    @Override
    public synchronized boolean locate_next_element_with_different_key(Iterator where) throws IteratorInBetween, IteratorInvalid {
        Any key;
        PositionalIteratorImpl i = this.check_iterator(where);
        i.check_iterator();
        int pos = i.get_pos();
        this.test_key.key = key = this.ops.key((Any)this.data.elementAt(pos));
        try {
            int key_pos = this.keys.indexOf(this.test_key);
            if (key_pos == this.keys.size() - 1) {
                i.invalidate();
                return false;
            }
            KeyNode node = (KeyNode)this.keys.elementAt(key_pos + 1);
            i.set_pos(node.start_position);
            return true;
        }
        catch (ObjectInvalid e) {
            e.printStackTrace(System.out);
            throw new INTERNAL();
        }
    }

    @Override
    public synchronized int number_of_different_keys() {
        return this.keys.size();
    }

    @Override
    public synchronized int number_of_elements_with_key(Any key) throws KeyInvalid {
        this.check_key(key);
        this.test_key.key = key;
        try {
            int pos = this.keys.indexOf(this.test_key);
            if (pos < 0) {
                return 0;
            }
            KeyNode node = (KeyNode)this.keys.elementAt(pos);
            return node.count;
        }
        catch (ObjectInvalid e) {
            throw new KeyInvalid();
        }
    }

    @Override
    public synchronized boolean locate_first_element_with_key(Any key, Iterator where) throws KeyInvalid, IteratorInvalid {
        this.check_key(key);
        PositionalIteratorImpl i = this.check_iterator(where);
        try {
            this.test_key.key = key;
            int pos = this.keys.indexOf(this.test_key);
            if (pos >= 0) {
                KeyNode node = (KeyNode)this.keys.elementAt(pos);
                i.set_pos(node.start_position);
                i.set_in_between(false);
                return true;
            }
            i.invalidate();
            return false;
        }
        catch (ObjectInvalid e) {
            throw new KeyInvalid();
        }
    }

    @Override
    public synchronized boolean locate_last_element_with_key(Any key, Iterator where) throws KeyInvalid, IteratorInvalid {
        this.check_key(key);
        PositionalIteratorImpl i = this.check_iterator(where);
        try {
            this.test_key.key = key;
            int pos = this.keys.indexOf(this.test_key);
            if (pos >= 0) {
                KeyNode node = (KeyNode)this.keys.elementAt(pos);
                i.set_pos(node.start_position + node.count - 1);
                i.set_in_between(false);
                return true;
            }
            i.invalidate();
            return false;
        }
        catch (ObjectInvalid e) {
            throw new KeyInvalid();
        }
    }

    @Override
    public synchronized boolean locate_previous_element_with_key(Any key, Iterator where) throws KeyInvalid, IteratorInvalid {
        this.check_key(key);
        PositionalIteratorImpl i = this.check_iterator(where);
        i.check_invalid();
        int pos = i.get_pos();
        if (pos == 0) {
            i.invalidate();
            return false;
        }
        Any element = (Any)this.data.elementAt(pos - 1);
        if (this.ops.key_equal(key, this.ops.key(element))) {
            i.set_pos(pos - 1);
            i.set_in_between(false);
            return true;
        }
        i.invalidate();
        return false;
    }

    @Override
    public synchronized boolean locate_previous_element_with_different_key(Iterator where) throws IteratorInBetween, IteratorInvalid {
        PositionalIteratorImpl i = this.check_iterator(where);
        i.check_iterator();
        int pos = i.get_pos();
        Any key = this.ops.key((Any)this.data.elementAt(pos));
        if (pos-- == 0) {
            i.invalidate();
            return false;
        }
        while (pos >= 0) {
            Any element = (Any)this.data.elementAt(pos);
            if (!this.ops.key_equal(key, this.ops.key(element))) {
                i.set_pos(pos);
                i.set_in_between(false);
                return true;
            }
            --pos;
        }
        i.invalidate();
        return false;
    }

    @Override
    protected void element_inserted(int pos) {
        super.element_inserted(pos);
        Any key = this.ops.key((Any)this.data.elementAt(pos));
        this.key_inserted(key, pos);
    }

    @Override
    protected void element_removed(int pos, Any old) {
        super.element_removed(pos, old);
        Any key = this.ops.key(old);
        this.key_removed(key);
    }

    @Override
    protected void element_replaced(int pos, Any old) {
        super.element_replaced(pos, old);
        Any old_key = this.ops.key(old);
        Any new_key = this.ops.key((Any)this.data.elementAt(pos));
        if (!this.ops.equal(old_key, new_key)) {
            this.key_removed(old_key);
            this.key_inserted(new_key, pos);
        }
    }

    protected void check_key(Any key) throws KeyInvalid {
        if (!this.ops.check_key_type(key)) {
            throw new KeyInvalid();
        }
    }

    protected void key_inserted(Any key, int pos) {
        try {
            KeyNode node;
            this.test_key.key = key;
            int key_pos = this.keys.indexOf(this.test_key);
            if (key_pos == -1) {
                node = new KeyNode();
                node.key = key;
                node.count = 0;
                key_pos = this.keys.addElement(node);
                node.start_position = pos;
            } else {
                node = (KeyNode)this.keys.elementAt(key_pos);
            }
            ++node.count;
            for (int i = key_pos + 1; i < this.keys.size(); ++i) {
                node = (KeyNode)this.keys.elementAt(i);
                ++node.start_position;
            }
        }
        catch (ObjectInvalid e) {
            e.printStackTrace(System.out);
            throw new INTERNAL();
        }
    }

    protected void key_removed(Any key) {
        try {
            this.test_key.key = key;
            int key_pos = this.keys.indexOf(this.test_key);
            KeyNode node = (KeyNode)this.keys.elementAt(key_pos);
            --node.count;
            for (int i = key_pos + 1; i < this.keys.size(); ++i) {
                node = (KeyNode)this.keys.elementAt(i);
                --node.start_position;
            }
            if (node.count == 0) {
                this.keys.removeElementAt(key_pos);
            }
        }
        catch (ObjectInvalid e) {
            e.printStackTrace(System.out);
            throw new INTERNAL();
        }
    }
}

