/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.collection;

import org.jacorb.collection.CollectionImpl;
import org.jacorb.collection.IteratorFactory;
import org.jacorb.collection.NVPairManager;
import org.jacorb.collection.PositionalIteratorImpl;
import org.jacorb.collection.SequenceImpl;
import org.jacorb.collection.SequentialCollectionImpl;
import org.jacorb.collection.SequentialIteratorImpl;
import org.jacorb.util.ObjectUtil;
import org.omg.CORBA.INTERNAL;
import org.omg.CosCollection.CSequence;
import org.omg.CosCollection.CSequenceHelper;
import org.omg.CosCollection.CSequencePOATie;
import org.omg.CosCollection.Collection;
import org.omg.CosCollection.NVPair;
import org.omg.CosCollection.Operations;
import org.omg.CosCollection.OperationsOperations;
import org.omg.CosCollection.ParameterInvalid;
import org.omg.CosCollection.SequenceFactoryPOA;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public class SequenceFactoryImpl
extends SequenceFactoryPOA
implements IteratorFactory {
    public static final String IMPL_CATEGORY = "ArrayBased";
    private POA poa;

    public SequenceFactoryImpl(POA poa) {
        this.poa = poa;
        try {
            poa.servant_to_reference((Servant)this);
        }
        catch (Exception e) {
            System.out.println("Internal error: Can not activate factory");
            e.printStackTrace();
            throw new INTERNAL();
        }
    }

    @Override
    public CSequence create(Operations ops, int expected_size) {
        return this.create(ops, expected_size, this.poa);
    }

    public CSequence create(String ops_class, int expected_size) {
        OperationsOperations ops = null;
        try {
            Class operation_class = ObjectUtil.classForName((String)ops_class);
            ops = (OperationsOperations)operation_class.newInstance();
        }
        catch (Exception e) {
            System.out.println("Internal error: Can not instantiate object of class \"" + ops_class + "\"");
            throw new INTERNAL();
        }
        return this.create(ops, expected_size, this.poa);
    }

    public CSequence create(OperationsOperations ops, int expected_size, POA poa) {
        SequenceImpl collection = new SequenceImpl(ops, poa, this, expected_size);
        CSequence collection_ref = null;
        CSequencePOATie srvnt = new CSequencePOATie(collection);
        try {
            collection_ref = CSequenceHelper.narrow(poa.servant_to_reference((Servant)srvnt));
            collection.set_servant(srvnt);
        }
        catch (Exception e) {
            System.out.println("Internal error: Can not Activate collection");
            e.printStackTrace();
            throw new INTERNAL();
        }
        return collection_ref;
    }

    @Override
    public Collection generic_create(NVPair[] parameters) throws ParameterInvalid {
        Operations ops;
        NVPairManager pm = new NVPairManager(parameters);
        String implementation_category = pm.find_string_param("impl_category");
        if (implementation_category != null && !implementation_category.equals(IMPL_CATEGORY)) {
            throw new ParameterInvalid(pm.find_param_idx("impl_category"), "CollectionFactory : not support implementation category " + implementation_category);
        }
        Integer size = pm.find_ulong_param("expected_size");
        if (size == null) {
            size = new Integer(10);
        }
        if ((ops = pm.find_operations_param("operaions")) == null) {
            String ops_class = pm.find_string_param("operaions_class");
            if (ops_class == null) {
                throw new ParameterInvalid(pm.find_param_idx("operaions"), "CollectionFactory: OPERATION object not defined");
            }
            return this.create(ops_class, (int)size);
        }
        return this.create(ops, (int)size);
    }

    @Override
    public PositionalIteratorImpl create_iterator(CollectionImpl collection, boolean read_only) {
        return this.create_iterator(collection, read_only, false);
    }

    @Override
    public PositionalIteratorImpl create_iterator(CollectionImpl collection, boolean read_only, boolean reverse) {
        return new SequentialIteratorImpl((SequentialCollectionImpl)collection, read_only, reverse);
    }
}

