/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.collection.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.jacorb.collection.util.ArrayFactory;
import org.jacorb.collection.util.DynArrayEnumerator;

public class DynArray {
    protected Object[] elementData;
    protected int elementCount = 0;

    public DynArray(int initialCapacity) {
        this.elementData = ArrayFactory.get_array(initialCapacity);
    }

    public DynArray() {
        this.elementData = new Object[16];
    }

    public void copyInto(Object[] anArray) {
        System.arraycopy(this.elementData, 0, anArray, 0, this.elementCount);
    }

    public void ensureCapacity(int minCapacity) {
        if (minCapacity > this.elementData.length) {
            this.ensureCapacityHelper(minCapacity);
        }
    }

    private void ensureCapacityHelper(int minCapacity) {
        Object[] oldData = this.elementData;
        this.elementData = ArrayFactory.get_array(minCapacity);
        System.arraycopy(oldData, 0, this.elementData, 0, this.elementCount);
        ArrayFactory.free_array(oldData);
    }

    public void setSize(int newSize) {
        if (newSize > this.elementCount) {
            if (newSize > this.elementData.length) {
                this.ensureCapacityHelper(newSize);
            }
            int i = newSize;
            while (i >= this.elementCount) {
                this.elementData[--i] = null;
            }
        } else {
            for (int i = newSize; i < this.elementCount; ++i) {
                this.elementData[i] = null;
            }
        }
        this.elementCount = newSize;
    }

    public int capacity() {
        return this.elementData.length;
    }

    public int size() {
        return this.elementCount;
    }

    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    public Enumeration elements() {
        return new DynArrayEnumerator(this);
    }

    public boolean contains(Object elem) {
        return this.indexOf(elem, 0) >= 0;
    }

    public int indexOf(Object elem) {
        return this.indexOf(elem, 0);
    }

    public int indexOf(Object elem, int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        for (int i = index; i < this.elementCount; ++i) {
            if (!elem.equals(this.elementData[i])) continue;
            return i;
        }
        return -1;
    }

    public Object elementAt(int index) {
        return this.elementData[index];
    }

    public void setElementAt(Object obj, int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.elementCount);
        }
        this.elementData[index] = obj;
    }

    public void removeElementAt(int index) {
        if (index >= this.elementCount || index < 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int j = this.elementCount - index - 1;
        if (j > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, j);
        }
        --this.elementCount;
        this.elementData[this.elementCount] = null;
    }

    public void insertElementAt(Object obj, int index) {
        int newcount = this.elementCount + 1;
        if (index >= newcount) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        if (newcount > this.elementData.length) {
            this.ensureCapacityHelper(newcount);
        }
        System.arraycopy(this.elementData, index, this.elementData, index + 1, this.elementCount - index);
        this.elementData[index] = obj;
        ++this.elementCount;
    }

    public void addElement(Object obj) {
        int newcount = this.elementCount + 1;
        if (newcount > this.elementData.length) {
            this.ensureCapacityHelper(newcount);
        }
        this.elementData[this.elementCount++] = obj;
    }

    public boolean removeElement(Object obj) {
        int i = this.indexOf(obj);
        if (i >= 0) {
            this.removeElementAt(i);
            return true;
        }
        return false;
    }

    public void removeAllElements() {
        for (int i = 0; i < this.elementCount; ++i) {
            this.elementData[i] = null;
        }
        this.elementCount = 0;
    }

    public Object firstElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[0];
    }

    public Object lastElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[this.elementCount - 1];
    }

    protected void finalize() {
        if (this.elementData != null) {
            ArrayFactory.free_array(this.elementData);
        }
    }
}

