/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.ir;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Properties;
import java.util.StringTokenizer;
import org.omg.CORBA.ORB;

public class IRServer {
    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("Usage: jaco org.jacorb.ir.IRServer <classpath> <IOR filename>");
            System.exit(1);
        }
        try {
            StringTokenizer strtok = new StringTokenizer(args[0], File.pathSeparator);
            URL[] urls = new URL[strtok.countTokens()];
            int i = 0;
            while (strtok.hasMoreTokens()) {
                urls[i] = new File(strtok.nextToken()).toURL();
                ++i;
            }
            URLClassLoader classLoader = new URLClassLoader(urls);
            Class<?> repositoryClass = classLoader.loadClass("org.jacorb.ir.RepositoryImpl");
            Properties props = new Properties();
            props.setProperty("jacorb.orb.objectKeyMap.InterfaceRepository", "InterfaceRepository/InterfaceRepositoryPOA/IfR");
            props.setProperty("jacorb.implname", "InterfaceRepository");
            ORB orb = ORB.init((String[])args, (Properties)props);
            Object repository = repositoryClass.getConstructors()[0].newInstance(args[0], args[1], classLoader, orb);
            repositoryClass.getDeclaredMethod("loadContents", null).invoke(repository, (Object[])null);
            orb.run();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

