/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.poa;

import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.poa.AOM;
import org.jacorb.poa.POA;
import org.jacorb.poa.POAMonitor;
import org.jacorb.poa.RPPoolManager;
import org.jacorb.poa.RequestQueue;
import org.jacorb.util.ObjectUtil;
import org.slf4j.Logger;

public class POAMonitorLightImpl
implements POAMonitor {
    private POA poaModel;
    private AOM aomModel;
    private RequestQueue queueModel;
    private RPPoolManager pmModel;
    private Configuration configuration = null;
    private Logger logger;
    private boolean doMonitor;
    private String prefix;

    @Override
    public void changeState(String state) {
    }

    @Override
    public void closeMonitor() {
    }

    @Override
    public void init(POA poa, AOM aom, RequestQueue queue, RPPoolManager pm, String _prefix) {
        this.poaModel = poa;
        this.aomModel = aom;
        this.queueModel = queue;
        this.pmModel = pm;
        this.prefix = _prefix;
    }

    @Override
    public void configure(Configuration myConfiguration) throws ConfigurationException {
        this.configuration = myConfiguration;
        this.logger = this.configuration.getLogger("org.jacorb.poa.monitor");
        this.doMonitor = this.configuration.getAttributeAsBoolean("jacorb.poa.monitoring", false);
    }

    @Override
    public void openMonitor() {
        block3: {
            if (this.doMonitor) {
                try {
                    POAMonitor newMonitor = (POAMonitor)ObjectUtil.classForName("org.jacorb.poa.POAMonitorImpl").newInstance();
                    newMonitor.init(this.poaModel, this.aomModel, this.queueModel, this.pmModel, this.prefix);
                    newMonitor.configure(this.configuration);
                    this.poaModel.setMonitor(newMonitor);
                    newMonitor.openMonitor();
                }
                catch (Throwable exception) {
                    if (!this.logger.isWarnEnabled()) break block3;
                    this.logger.warn("Exception during openMonitor() of POAMonitorLightImpl" + exception.getMessage());
                }
            }
        }
    }
}

