/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.util;

import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NavigableSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.util.SelectorRequest;
import org.slf4j.Logger;

public class SelectorManager
extends Thread {
    private final HashMap<SelectorRequest.Type, RequestorPool> pools;
    private final ConcurrentSkipListSet<SelectorRequest> timeOrderedRequests;
    private final ConcurrentLinkedQueue<SelectorRequest> canceledRequests;
    private final ConcurrentLinkedQueue<SelectorRequest> newRequests;
    private final ConcurrentLinkedQueue<SelectorRequest> reActivateBuffer;
    private final Selector selector;
    private boolean running = true;
    private Logger logger;
    private final ExecutorService executor;
    private int threadPoolMin = 2;
    private int threadPoolMax = 10;
    private int threadPoolKeepAliveTime = 60;
    private int executorPendingQueueSize = 5;
    private boolean loggerDebugEnabled = false;
    private final Object runLock = new Object();

    public SelectorManager() {
        try {
            this.pools = new HashMap(4);
            this.pools.put(SelectorRequest.Type.CONNECT, new RequestorPool());
            this.pools.put(SelectorRequest.Type.ACCEPT, new RequestorPool());
            this.pools.put(SelectorRequest.Type.READ, new RequestorPool());
            this.pools.put(SelectorRequest.Type.WRITE, new RequestorPool());
            this.timeOrderedRequests = new ConcurrentSkipListSet<SelectorRequest>(new TimeOrderedComparitor());
            this.canceledRequests = new ConcurrentLinkedQueue();
            this.newRequests = new ConcurrentLinkedQueue();
            this.reActivateBuffer = new ConcurrentLinkedQueue();
            this.selector = SelectorProvider.provider().openSelector();
            this.executor = new ThreadPoolExecutor(this.threadPoolMin, this.threadPoolMax, this.threadPoolKeepAliveTime, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(this.executorPendingQueueSize), new SelectorManagerThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        if (configuration == null) {
            throw new ConfigurationException("SelectorManager.configure was passed a null Configuration object");
        }
        this.logger = configuration.getLogger("org.jacorb.util");
        this.loggerDebugEnabled = this.logger.isDebugEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (this.running) {
                this.removeCanceled();
                this.insertNew();
                this.reactivate();
                long sleepTime = this.cleanupExpiredRequests();
                try {
                    this.selector.select(sleepTime);
                }
                catch (IllegalArgumentException ex) {
                    this.logger.error("Select timeout (" + sleepTime + ") argument flawed: " + ex.toString());
                }
                Object ex = this.runLock;
                synchronized (ex) {
                    if (!this.running) {
                        if (this.loggerDebugEnabled) {
                            this.logger.debug("Breaking out of Selector loop; 'running' flag was disabled.");
                        }
                        break;
                    }
                }
                Iterator<SelectionKey> iter = this.selector.selectedKeys().iterator();
                while (iter.hasNext()) {
                    SelectionKey key = iter.next();
                    iter.remove();
                    if (!key.isValid()) continue;
                    this.dispatch(key);
                }
            }
        }
        catch (Exception ex) {
            this.logger.error("Exception in Selector loop. Bailing out: " + ex.toString());
            ex.printStackTrace();
        }
        this.running = false;
        try {
            if (this.loggerDebugEnabled) {
                this.logger.debug("SelectorManager loop is broken. Cleaning up pending requests");
            }
            this.cleanupAll();
            if (this.loggerDebugEnabled) {
                this.logger.debug("shutting down Threadpool executor.");
            }
            this.executor.shutdown();
        }
        catch (Exception ex) {
            this.logger.error("Selector manager cleanup: " + ex.toString());
            ex.printStackTrace();
        }
    }

    private void dispatch_i(int op, SelectorRequest.Type jobType, SelectionKey key) {
        if (this.loggerDebugEnabled) {
            this.logger.debug("Key " + key + " ready for action: " + (Object)((Object)jobType));
        }
        int newOps = key.interestOps() ^ op;
        try {
            key.interestOps(newOps);
        }
        catch (CancelledKeyException ex) {
            // empty catch block
        }
        SendJob sendJob = new SendJob(key, jobType);
        FutureTask<Object> task = new FutureTask<Object>(sendJob);
        this.executor.execute(task);
    }

    private void dispatch(SelectionKey key) {
        if (this.loggerDebugEnabled) {
            this.logger.debug("dispatch called for: " + key);
        }
        try {
            if (key.isConnectable()) {
                this.dispatch_i(8, SelectorRequest.Type.CONNECT, key);
            }
            if (key.isAcceptable()) {
                this.dispatch_i(16, SelectorRequest.Type.ACCEPT, key);
            }
            if (key.isReadable()) {
                this.dispatch_i(1, SelectorRequest.Type.READ, key);
            }
            if (key.isWritable()) {
                this.dispatch_i(4, SelectorRequest.Type.WRITE, key);
            }
        }
        catch (CancelledKeyException ex) {
            if (this.loggerDebugEnabled) {
                this.logger.debug("Cleaning up requests associated with key: " + key.toString());
            }
            this.cancelKey(key);
        }
    }

    private void cancelKey(SelectionKey key) {
        for (RequestorPool pool : this.pools.values()) {
            ConcurrentLinkedQueue<SelectorRequest> buffer = pool.remove(key);
            if (buffer == null) continue;
            this.cleanupBuffer(buffer);
        }
    }

    private void cleanupAll() {
        for (RequestorPool pool : this.pools.values()) {
            Iterator<ConcurrentLinkedQueue<SelectorRequest>> e = pool.values();
            while (e.hasNext()) {
                this.cleanupBuffer(e.next());
            }
        }
        this.cleanupBuffer(this.reActivateBuffer);
        this.cleanupBuffer(this.canceledRequests);
        this.cleanupBuffer(this.newRequests);
        this.timeOrderedRequests.clear();
    }

    private void cleanupBuffer(ConcurrentLinkedQueue<SelectorRequest> buffer) {
        SelectorRequest request = null;
        while ((request = buffer.poll()) != null) {
            if (this.loggerDebugEnabled) {
                this.logger.debug("Cleaning up request. Request type: " + (Object)((Object)request.type) + ", Request status: " + (Object)((Object)request.status));
            }
            if (!this.running) {
                request.setStatus(SelectorRequest.Status.SHUTDOWN);
            }
            SendJob sendJob = new SendJob(request);
            FutureTask<Object> task = new FutureTask<Object>(sendJob);
            this.executor.execute(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void halt() {
        Object object = this.runLock;
        synchronized (object) {
            if (!this.running) {
                return;
            }
            if (this.loggerDebugEnabled) {
                this.logger.debug("Halting Selector Manager.");
            }
            this.running = false;
            this.selector.wakeup();
        }
        if (this.loggerDebugEnabled) {
            this.logger.debug("Waiting for Threadpool executor to wind down.");
        }
        while (!this.executor.isTerminated()) {
            try {
                this.executor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public int poolSize(SelectorRequest.Type type) {
        if (type == SelectorRequest.Type.TIMER) {
            return this.timeOrderedRequests.size();
        }
        RequestorPool p = this.pools.get((Object)type);
        return p == null ? 0 : p.size();
    }

    public void remove(SelectorRequest request) {
        if (request == null || request.type == null) {
            return;
        }
        if (this.newRequests.remove(request)) {
            return;
        }
        this.canceledRequests.offer(request);
        if (this.loggerDebugEnabled) {
            this.logger.debug("Remove request. Request type: " + request.type.toString());
        }
        this.selector.wakeup();
    }

    private boolean sendFailure(SelectorRequest request, SelectorRequest.Status reason) {
        request.setStatus(reason);
        if (request.callback == null) {
            return false;
        }
        if (this.loggerDebugEnabled) {
            this.logger.debug("Immediate Requestor callback in client thread. Request type: " + request.type.toString() + ", Request status: " + request.status.toString());
        }
        try {
            request.callback.call(request);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.loggerDebugEnabled) {
            this.logger.debug("Callback concluded");
        }
        return false;
    }

    public boolean add(SelectorRequest request) {
        if (request == null) {
            return false;
        }
        if (!this.running) {
            return this.sendFailure(request, SelectorRequest.Status.SHUTDOWN);
        }
        if (request.nanoDeadline <= System.nanoTime()) {
            return this.sendFailure(request, SelectorRequest.Status.EXPIRED);
        }
        if (request.type == null || request.type != SelectorRequest.Type.TIMER && request.channel == null) {
            return this.sendFailure(request, SelectorRequest.Status.FAILED);
        }
        if (!(request.type != SelectorRequest.Type.READ && request.type != SelectorRequest.Type.WRITE || request.channel.isConnected())) {
            return this.sendFailure(request, SelectorRequest.Status.CLOSED);
        }
        if (this.loggerDebugEnabled) {
            this.logger.debug("Adding new request. Request type: " + request.type.toString());
        }
        request.setStatus(SelectorRequest.Status.PENDING);
        this.newRequests.offer(request);
        this.selector.wakeup();
        return true;
    }

    private void reactivate() {
        SelectorRequest request = null;
        while ((request = this.reActivateBuffer.poll()) != null) {
            if (request.type != SelectorRequest.Type.TIMER && !request.channel.isConnected()) {
                this.removeClosedRequests(request.key);
                continue;
            }
            if (this.loggerDebugEnabled) {
                this.logger.debug("Reactivating request. Request type: " + request.type.toString());
            }
            try {
                int currentOps = request.key.interestOps();
                int newOps = currentOps | request.op;
                request.key.interestOps(newOps);
                this.insertIntoActivePool(request);
            }
            catch (Exception ex) {
                this.logger.error("reactivate failed: " + ex.getMessage());
                request.setStatus(SelectorRequest.Status.FAILED);
                SendJob sendJob = new SendJob(request);
                FutureTask<Object> task = new FutureTask<Object>(sendJob);
                this.executor.execute(task);
            }
        }
    }

    private void removeClosedRequests(SelectionKey key) {
        if (key != null) {
            if (this.loggerDebugEnabled) {
                this.logger.debug("Removing request matching key " + key.toString());
            }
            key.cancel();
            for (RequestorPool pool : this.pools.values()) {
                ConcurrentLinkedQueue<SelectorRequest> requestBuffer = pool.remove(key);
                this.removeClosedRequests(requestBuffer);
            }
        }
    }

    private void removeClosedRequests(ConcurrentLinkedQueue<SelectorRequest> source) {
        if (source == null) {
            return;
        }
        LinkedList<SelectorRequest> local = new LinkedList<SelectorRequest>(source);
        while (local.size() > 0) {
            SelectorRequest request = local.poll();
            request.setStatus(SelectorRequest.Status.CLOSED);
            SendJob sendJob = new SendJob(request);
            FutureTask<Object> task = new FutureTask<Object>(sendJob);
            this.executor.execute(task);
        }
    }

    private void removeCanceled() {
        SelectorRequest request = null;
        while ((request = this.canceledRequests.poll()) != null) {
            if (this.loggerDebugEnabled) {
                this.logger.debug("Removing request type: " + request.type.toString());
            }
            if (request.type == SelectorRequest.Type.TIMER) {
                boolean result = this.timeOrderedRequests.remove(request);
                if (!this.loggerDebugEnabled) continue;
                this.logger.debug("Result of removing timer: " + result);
                continue;
            }
            this.removeFromActivePool(request);
        }
    }

    private void removeFromActivePool(SelectorRequest request) {
        RequestorPool pool = this.pools.get((Object)request.type);
        request.key = request.channel.keyFor(this.selector);
        if (request.key == null) {
            return;
        }
        ConcurrentLinkedQueue<SelectorRequest> requests = null;
        requests = pool.get(request.key);
        if (requests == null) {
            return;
        }
        requests.remove(request);
        this.timeOrderedRequests.remove(request);
        request.setStatus(SelectorRequest.Status.CLOSED);
        SendJob sendJob = new SendJob(request);
        FutureTask<Object> task = new FutureTask<Object>(sendJob);
        this.executor.execute(task);
    }

    private void insertNew() {
        SelectorRequest request = null;
        while ((request = this.newRequests.poll()) != null) {
            if (this.loggerDebugEnabled) {
                this.logger.debug("Inserting request type: " + request.type.toString());
            }
            if (request.type != SelectorRequest.Type.CONNECT && request.type != SelectorRequest.Type.TIMER && !request.channel.isConnected()) {
                this.removeClosedRequests(request.key);
                return;
            }
            if (request.type == SelectorRequest.Type.TIMER) {
                this.insertIntoTimedBuffer(request);
                continue;
            }
            this.insertIntoActivePool(request);
        }
    }

    private void insertIntoActivePool(SelectorRequest request) {
        ConcurrentLinkedQueue<SelectorRequest> requests;
        RequestorPool pool = this.pools.get((Object)request.type);
        request.key = request.channel.keyFor(this.selector);
        if (request.key == null) {
            try {
                request.key = request.channel.register(this.selector, request.op);
            }
            catch (ClosedChannelException e) {
                this.logger.error("Insert failed: " + e.getMessage());
                request.setStatus(SelectorRequest.Status.CLOSED);
                SendJob sendJob = new SendJob(request);
                FutureTask<Object> task = new FutureTask<Object>(sendJob);
                this.executor.execute(task);
                return;
            }
        }
        if ((requests = pool.get(request.key)) == null) {
            requests = new ConcurrentLinkedQueue();
            pool.put(request.key, requests);
        }
        boolean opUpdateFailed = false;
        int newOps = 0;
        try {
            if (requests.isEmpty()) {
                int currentOps = request.key.interestOps();
                newOps = currentOps | request.op;
                request.key.interestOps(newOps);
            }
            requests.offer(request);
            if (request.nanoDeadline != Long.MAX_VALUE) {
                this.insertIntoTimedBuffer(request);
            }
        }
        catch (CancelledKeyException ex) {
            this.logger.error("Insert failed to update selector interest " + ex.getMessage());
            opUpdateFailed = true;
        }
        catch (IllegalArgumentException ex) {
            this.logger.error("Insert failed to update selector interest: " + newOps + ": " + ex.getMessage());
            opUpdateFailed = true;
        }
        if (opUpdateFailed) {
            request.setStatus(SelectorRequest.Status.FAILED);
            SendJob sendJob = new SendJob(request);
            FutureTask<Object> task = new FutureTask<Object>(sendJob);
            this.executor.execute(task);
        }
    }

    private void insertIntoTimedBuffer(SelectorRequest newRequest) {
        this.timeOrderedRequests.add(newRequest);
    }

    private long cleanupExpiredRequests() {
        long sleepTime = 0L;
        SelectorRequest request2 = null;
        SelectorRequest atNow = new SelectorRequest(null, System.nanoTime());
        NavigableSet<SelectorRequest> expired = this.timeOrderedRequests.headSet(atNow, true);
        for (SelectorRequest request2 : expired) {
            if (this.loggerDebugEnabled) {
                this.logger.debug("Checking expiry. Request type: " + (Object)((Object)request2.type) + ", request status: " + (Object)((Object)request2.status));
            }
            if (request2.status != SelectorRequest.Status.PENDING) {
                this.timeOrderedRequests.remove(request2);
                continue;
            }
            if (this.loggerDebugEnabled) {
                this.logger.debug("Cleaning up expired request from timed requests queue:\n\trequest type: " + request2.type.toString() + ", request status: " + request2.status.toString());
            }
            if (request2.status != SelectorRequest.Status.EXPIRED) {
                RequestorPool pool;
                ConcurrentLinkedQueue<SelectorRequest> buffer;
                request2.setStatus(SelectorRequest.Status.EXPIRED);
                if (request2.type == SelectorRequest.Type.CONNECT && request2.key != null && (buffer = (pool = this.pools.get((Object)request2.type)).remove(request2.key)) != null) {
                    this.cleanupBuffer(buffer);
                }
            }
            SendJob sendJob = new SendJob(request2);
            FutureTask<Object> task = new FutureTask<Object>(sendJob);
            this.executor.execute(task);
            this.timeOrderedRequests.remove(request2);
        }
        if (!this.timeOrderedRequests.isEmpty()) {
            request2 = this.timeOrderedRequests.first();
            sleepTime = (request2.nanoDeadline - atNow.nanoDeadline) / 1000000L;
        }
        if (sleepTime <= 0L) {
            sleepTime = 1L;
        }
        return sleepTime;
    }

    private SelectorRequest getNextRequest(boolean anyStatus, ConcurrentLinkedQueue<SelectorRequest> buffer) {
        SelectorRequest request = null;
        while ((request = buffer.poll()) != null) {
            if (request.status == SelectorRequest.Status.EXPIRED) continue;
            if (!anyStatus && request.status != SelectorRequest.Status.PENDING || request.nanoDeadline > System.nanoTime()) break;
            request.setStatus(SelectorRequest.Status.EXPIRED);
        }
        return request;
    }

    private void callbackRequestor(SelectionKey key, RequestorPool pool) {
        ConcurrentLinkedQueue<SelectorRequest> buffer = pool.get(key);
        SelectorRequest request = this.getNextRequest(false, buffer);
        if (request == null) {
            return;
        }
        request.setStatus(SelectorRequest.Status.READY);
        boolean reActivate = false;
        if (request.callback != null) {
            if (this.loggerDebugEnabled) {
                this.logger.debug("Requestor callback in worker thread. Request type: " + request.type.toString());
            }
            try {
                reActivate = request.callback.call(request);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (this.loggerDebugEnabled) {
                this.logger.debug("Callback concluded. Reactivation request: " + (reActivate ? "TRUE" : "FALSE"));
            }
            if (!request.channel.isConnected()) {
                reActivate = true;
            }
        }
        if (reActivate) {
            request.setStatus(SelectorRequest.Status.ASSIGNED);
        } else {
            request.setStatus(SelectorRequest.Status.FINISHED);
            request = this.getNextRequest(true, buffer);
        }
        if (request != null) {
            this.reActivateBuffer.offer(request);
            if (this.loggerDebugEnabled) {
                this.logger.debug("Adding reactivate request. Request type: " + request.type.toString());
            }
            this.selector.wakeup();
        }
    }

    private void handleAction(SelectionKey key, SelectorRequest.Type type, SelectorRequest request) {
        if (this.loggerDebugEnabled) {
            this.logger.debug("Enter SelectorManager.handleAction");
        }
        if (request == null) {
            this.callbackRequestor(key, this.pools.get((Object)type));
            return;
        }
        if (request.callback == null) {
            return;
        }
        if (this.loggerDebugEnabled) {
            this.logger.debug("Selector Worker thread calling request callback directly:\n\tRequest type: " + request.type.toString() + ", Request status: " + request.status.toString());
        }
        try {
            request.callback.call(request);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (this.loggerDebugEnabled) {
            this.logger.debug("Callback concluded");
        }
    }

    private class SendJob
    implements Callable<Object> {
        private SelectionKey key = null;
        private SelectorRequest.Type type = null;
        private SelectorRequest request = null;

        SendJob(SelectionKey key, SelectorRequest.Type type) {
            this.key = key;
            this.type = type;
        }

        SendJob(SelectorRequest request) {
            this.request = request;
        }

        @Override
        public Object call() throws Exception {
            if (SelectorManager.this.running) {
                SelectorManager.this.handleAction(this.key, this.type, this.request);
            }
            return null;
        }
    }

    private static class SelectorManagerThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger poolNumber = new AtomicInteger(1);
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        private SelectorManagerThreadFactory() {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "SelectorManager worker-" + poolNumber.getAndIncrement() + "-thread-";
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread t = new Thread(this.group, runnable, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }

    private class RequestorPool {
        public ConcurrentHashMap<SelectionKey, ConcurrentLinkedQueue<SelectorRequest>> pool = new ConcurrentHashMap();

        private RequestorPool() {
        }

        public ConcurrentLinkedQueue<SelectorRequest> get(SelectionKey key) {
            return this.pool.get(key);
        }

        public ConcurrentLinkedQueue<SelectorRequest> put(SelectionKey key, ConcurrentLinkedQueue<SelectorRequest> requestBuffer) {
            return this.pool.put(key, requestBuffer);
        }

        public ConcurrentLinkedQueue<SelectorRequest> remove(SelectionKey key) {
            return this.pool.remove(key);
        }

        public Iterator<ConcurrentLinkedQueue<SelectorRequest>> values() {
            return this.pool.values().iterator();
        }

        public int size() {
            return this.pool.size();
        }
    }

    class TimeOrderedComparitor
    implements Comparator<SelectorRequest> {
        TimeOrderedComparitor() {
        }

        @Override
        public int compare(SelectorRequest arg0, SelectorRequest arg1) {
            long x = arg0.nanoDeadline - arg1.nanoDeadline;
            return x == 0L ? 0 : (x > 0L ? 1 : -1);
        }
    }
}

