/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.util;

import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import org.jacorb.util.SelectorRequestCallback;

public class SelectorRequest {
    public final Type type;
    public Status status = null;
    public final SocketChannel channel;
    public SelectionKey key = null;
    public final int op;
    public SelectorRequestCallback callback;
    public final long nanoDeadline;
    private final Object lock = new Object();

    public SelectorRequest(Type type, SocketChannel channel, SelectorRequestCallback callback, long nanoDeadline) {
        this.type = type;
        switch (type) {
            case CONNECT: {
                this.op = 8;
                break;
            }
            case READ: {
                this.op = 1;
                break;
            }
            case WRITE: {
                this.op = 4;
                break;
            }
            default: {
                this.op = 0;
            }
        }
        this.channel = channel;
        this.callback = callback;
        this.nanoDeadline = nanoDeadline == 0L ? Long.MAX_VALUE : nanoDeadline;
    }

    public SelectorRequest(SelectorRequestCallback callback, long nanoDeadline) {
        this.type = Type.TIMER;
        this.op = 0;
        this.channel = null;
        this.callback = callback;
        this.nanoDeadline = nanoDeadline == 0L ? Long.MAX_VALUE : nanoDeadline;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(Status status) {
        Object object = this.lock;
        synchronized (object) {
            this.status = status;
            this.lock.notify();
        }
    }

    public boolean isFinalized() {
        return this.status != null && this.status != Status.PENDING && this.status != Status.ASSIGNED && this.status != Status.READY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Status waitOnCompletion(long nanoDeadline) {
        long myNanoDeadline = nanoDeadline == 0L ? Long.MAX_VALUE : nanoDeadline;
        Object object = this.lock;
        // MONITORENTER : object
        while (myNanoDeadline > System.nanoTime() && !this.isFinalized()) {
            long remaining = myNanoDeadline - System.nanoTime();
            long millis = remaining / 1000000L;
            int nanos = (int)(remaining - millis * 1000000L);
            try {
                this.lock.wait(millis, nanos);
            }
            catch (InterruptedException e) {
            }
            catch (IllegalArgumentException ex) {
                return this.status;
            }
        }
        // MONITOREXIT : object
        return this.status;
    }

    public static enum Status {
        PENDING,
        ASSIGNED,
        READY,
        EXPIRED,
        FAILED,
        IOERROR,
        FINISHED,
        SHUTDOWN,
        CLOSED;

    }

    public static enum Type {
        CONNECT,
        ACCEPT,
        READ,
        WRITE,
        TIMER;

    }
}

