/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.scenegraph.io.state.com.sun.j3d.utils.geometry;

import com.sun.j3d.utils.geometry.Cylinder;
import com.sun.j3d.utils.scenegraph.io.retained.Controller;
import com.sun.j3d.utils.scenegraph.io.retained.SymbolTableData;
import com.sun.j3d.utils.scenegraph.io.state.com.sun.j3d.utils.geometry.PrimitiveState;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.media.j3d.Appearance;
import javax.media.j3d.SceneGraphObject;

public class CylinderState
extends PrimitiveState {
    private float radius = 1.0f;
    private float height = 2.0f;
    private int xdivision = 15;
    private int ydivision = 1;
    private int topAppearance;
    private int bottomAppearance;
    private int bodyAppearance;

    public CylinderState(SymbolTableData symbolTableData, Controller controller) {
        super(symbolTableData, controller);
        if (this.node != null) {
            this.bodyAppearance = controller.getSymbolTable().addReference((SceneGraphObject)((Cylinder)this.node).getShape(0).getAppearance());
            this.topAppearance = controller.getSymbolTable().addReference((SceneGraphObject)((Cylinder)this.node).getShape(1).getAppearance());
            this.bottomAppearance = controller.getSymbolTable().addReference((SceneGraphObject)((Cylinder)this.node).getShape(2).getAppearance());
        }
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        super.writeObject(dataOutput);
        dataOutput.writeInt(this.topAppearance);
        dataOutput.writeInt(this.bodyAppearance);
        dataOutput.writeInt(this.bottomAppearance);
    }

    public void readObject(DataInput dataInput) throws IOException {
        super.readObject(dataInput);
        this.topAppearance = dataInput.readInt();
        this.bodyAppearance = dataInput.readInt();
        this.bottomAppearance = dataInput.readInt();
    }

    public void writeConstructorParams(DataOutput dataOutput) throws IOException {
        super.writeConstructorParams(dataOutput);
        dataOutput.writeFloat(((Cylinder)this.node).getRadius());
        dataOutput.writeFloat(((Cylinder)this.node).getHeight());
        dataOutput.writeInt(((Cylinder)this.node).getXdivisions());
        dataOutput.writeInt(((Cylinder)this.node).getYdivisions());
    }

    public void readConstructorParams(DataInput dataInput) throws IOException {
        super.readConstructorParams(dataInput);
        this.radius = dataInput.readFloat();
        this.height = dataInput.readFloat();
        this.xdivision = dataInput.readInt();
        this.ydivision = dataInput.readInt();
    }

    public void buildGraph() {
        if (this.bodyAppearance == this.topAppearance && this.bodyAppearance == this.bottomAppearance) {
            ((Cylinder)this.node).setAppearance((Appearance)this.control.getSymbolTable().getJ3dNode(this.bodyAppearance));
        } else {
            ((Cylinder)this.node).setAppearance(0, (Appearance)this.control.getSymbolTable().getJ3dNode(this.bodyAppearance));
            ((Cylinder)this.node).setAppearance(1, (Appearance)this.control.getSymbolTable().getJ3dNode(this.topAppearance));
            ((Cylinder)this.node).setAppearance(2, (Appearance)this.control.getSymbolTable().getJ3dNode(this.bottomAppearance));
        }
        super.buildGraph();
    }

    public SceneGraphObject createNode(Class clazz) {
        Cylinder cylinder = (Cylinder)this.createNode(clazz, new Class[]{Float.TYPE, Float.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Appearance.class}, new Object[]{new Float(this.radius), new Float(this.height), new Integer(this.primflags), new Integer(this.xdivision), new Integer(this.ydivision), null});
        return cylinder;
    }

    protected SceneGraphObject createNode() {
        return new Cylinder(this.radius, this.height, this.primflags, this.xdivision, this.ydivision, null);
    }
}

