/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.openoffice;

import com.sun.star.frame.XController;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XModel;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.text.XParagraphCursor;
import com.sun.star.text.XText;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextViewCursor;
import com.sun.star.text.XTextViewCursorSupplier;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.languagetool.openoffice.Main;
import org.languagetool.tools.Tools;

class LOCursor {
    private XParagraphCursor xPCursor = null;
    private XTextViewCursor xVCursor = null;

    LOCursor(XComponentContext xContext) {
        this.xPCursor = LOCursor.getParagraphCursor(xContext);
        this.xVCursor = LOCursor.getViewCursor(xContext);
    }

    @Nullable
    private static XDesktop getCurrentDesktop(XComponentContext xContext) {
        try {
            if (xContext == null) {
                return null;
            }
            XMultiComponentFactory xMCF = (XMultiComponentFactory)UnoRuntime.queryInterface(XMultiComponentFactory.class, (Object)xContext.getServiceManager());
            if (xMCF == null) {
                return null;
            }
            Object desktop = xMCF.createInstanceWithContext("com.sun.star.frame.Desktop", xContext);
            if (desktop == null) {
                return null;
            }
            return (XDesktop)UnoRuntime.queryInterface(XDesktop.class, (Object)desktop);
        }
        catch (Exception e) {
            LOCursor.printException(e);
            return null;
        }
    }

    @Nullable
    private static XComponent getCurrentComponent(XComponentContext xContext) {
        try {
            XDesktop xdesktop = LOCursor.getCurrentDesktop(xContext);
            if (xdesktop == null) {
                return null;
            }
            return xdesktop.getCurrentComponent();
        }
        catch (Exception e) {
            LOCursor.printException(e);
            return null;
        }
    }

    @Nullable
    private static XTextDocument getCurrentDocument(XComponentContext xContext) {
        try {
            XComponent curcomp = LOCursor.getCurrentComponent(xContext);
            if (curcomp == null) {
                return null;
            }
            return (XTextDocument)UnoRuntime.queryInterface(XTextDocument.class, (Object)curcomp);
        }
        catch (Exception e) {
            LOCursor.printException(e);
            return null;
        }
    }

    @Nullable
    private static XTextCursor getCursor(XComponentContext xContext) {
        try {
            XTextDocument curdoc = LOCursor.getCurrentDocument(xContext);
            if (curdoc == null) {
                return null;
            }
            XText xText = curdoc.getText();
            if (xText == null) {
                return null;
            }
            return xText.createTextCursor();
        }
        catch (Exception e) {
            LOCursor.printException(e);
            return null;
        }
    }

    @Nullable
    private static XParagraphCursor getParagraphCursor(XComponentContext xContext) {
        try {
            XTextCursor xcursor = LOCursor.getCursor(xContext);
            if (xcursor == null) {
                return null;
            }
            return (XParagraphCursor)UnoRuntime.queryInterface(XParagraphCursor.class, (Object)xcursor);
        }
        catch (Exception e) {
            LOCursor.printException(e);
            return null;
        }
    }

    @Nullable
    private static XTextViewCursor getViewCursor(XComponentContext xContext) {
        try {
            XDesktop xDesktop = LOCursor.getCurrentDesktop(xContext);
            if (xDesktop == null) {
                return null;
            }
            XComponent xCurrentComponent = xDesktop.getCurrentComponent();
            if (xCurrentComponent == null) {
                return null;
            }
            XModel xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)xCurrentComponent);
            if (xModel == null) {
                return null;
            }
            XController xController = xModel.getCurrentController();
            if (xController == null) {
                return null;
            }
            XTextViewCursorSupplier xViewCursorSupplier = (XTextViewCursorSupplier)UnoRuntime.queryInterface(XTextViewCursorSupplier.class, (Object)xController);
            if (xViewCursorSupplier == null) {
                return null;
            }
            return xViewCursorSupplier.getViewCursor();
        }
        catch (Exception e) {
            LOCursor.printException(e);
            return null;
        }
    }

    private static void printException(Throwable e) {
        Main.printToLogFile(Tools.getFullStackTrace(e));
    }

    public int getNumberOfAllTextParagraphs() {
        try {
            if (this.xPCursor == null) {
                return 0;
            }
            this.xPCursor.gotoStart(false);
            int npara = 1;
            while (this.xPCursor.gotoNextParagraph(false)) {
                ++npara;
            }
            return npara;
        }
        catch (Exception e) {
            LOCursor.printException(e);
            return 0;
        }
    }

    @Nullable
    public List<String> getAllTextParagraphs() {
        try {
            ArrayList<String> allParas = new ArrayList<String>();
            if (this.xPCursor == null) {
                return null;
            }
            this.xPCursor.gotoStart(false);
            this.xPCursor.gotoStartOfParagraph(false);
            this.xPCursor.gotoEndOfParagraph(true);
            allParas.add(this.xPCursor.getString());
            while (this.xPCursor.gotoNextParagraph(false)) {
                this.xPCursor.gotoStartOfParagraph(false);
                this.xPCursor.gotoEndOfParagraph(true);
                allParas.add(this.xPCursor.getString());
            }
            return allParas;
        }
        catch (Exception e) {
            LOCursor.printException(e);
            return null;
        }
    }

    public int getViewCursorParagraph() {
        try {
            if (this.xVCursor == null) {
                return -4;
            }
            XText xDocumentText = this.xVCursor.getText();
            if (xDocumentText == null) {
                return -3;
            }
            XTextCursor xModelCursor = xDocumentText.createTextCursorByRange(this.xVCursor.getStart());
            if (xModelCursor == null) {
                return -2;
            }
            XParagraphCursor xParagraphCursor = (XParagraphCursor)UnoRuntime.queryInterface(XParagraphCursor.class, (Object)xModelCursor);
            if (xParagraphCursor == null) {
                return -1;
            }
            int pos = 0;
            while (xParagraphCursor.gotoPreviousParagraph(false)) {
                ++pos;
            }
            return pos;
        }
        catch (Exception e) {
            LOCursor.printException(e);
            return -5;
        }
    }
}

