/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.neuralnetwork;

import java.util.Arrays;
import java.util.Objects;
import org.languagetool.rules.neuralnetwork.Dictionary;
import org.languagetool.rules.neuralnetwork.Matrix;

class Embedding {
    private final Dictionary dictionary;
    private final Matrix embedding;

    public Embedding(Dictionary dictionary, Matrix embedding) {
        this.dictionary = Objects.requireNonNull(dictionary);
        this.embedding = Objects.requireNonNull(embedding);
    }

    public Matrix lookup(String[] words) {
        return new Matrix(Arrays.stream(words).map(this.dictionary::safeGet).map(this.embedding::row).reduce(Embedding::concat).get());
    }

    private static float[] concat(float[] a, float[] b) {
        int aLen = a.length;
        int bLen = b.length;
        float[] c = new float[aLen + bLen];
        System.arraycopy(a, 0, c, 0, aLen);
        System.arraycopy(b, 0, c, aLen, bLen);
        return c;
    }
}

