/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.spelling.morfologik;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import morfologik.fsa.FSA;
import morfologik.fsa.builders.CFSA2Serializer;
import morfologik.fsa.builders.FSABuilder;
import morfologik.stemming.Dictionary;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.JLanguageTool;
import org.languagetool.rules.spelling.morfologik.MorfologikSpeller;

public class MorfologikMultiSpeller {
    private static final LoadingCache<BufferedReaderWithSource, List<byte[]>> dictCache = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<BufferedReaderWithSource, List<byte[]>>(){

        public List<byte[]> load(@NotNull BufferedReaderWithSource reader) throws IOException {
            return MorfologikMultiSpeller.getLines(reader.br);
        }
    });
    private static final Map<String, Dictionary> dicPathToDict = new HashMap<String, Dictionary>();
    private final List<MorfologikSpeller> spellers;
    private final boolean convertsCase;

    public MorfologikMultiSpeller(String binaryDictPath, String plainTextPath, int maxEditDistance) throws IOException {
        this(binaryDictPath, new BufferedReader(new InputStreamReader(JLanguageTool.getDataBroker().getFromResourceDirAsStream(plainTextPath), "utf-8")), plainTextPath, maxEditDistance);
        if (!plainTextPath.endsWith(".txt")) {
            throw new RuntimeException("Unsupported dictionary, plain text file needs to have suffix .txt: " + plainTextPath);
        }
    }

    public MorfologikMultiSpeller(String binaryDictPath, BufferedReader plainTextReader, String plainTextReaderPath, int maxEditDistance) throws IOException {
        MorfologikSpeller speller = this.getBinaryDict(binaryDictPath, maxEditDistance);
        ArrayList<MorfologikSpeller> spellers = new ArrayList<MorfologikSpeller>();
        spellers.add(speller);
        this.convertsCase = speller.convertsCase();
        MorfologikSpeller plainTextSpeller = this.getPlainTextDictSpellerOrNull(plainTextReader, plainTextReaderPath, binaryDictPath, maxEditDistance);
        if (plainTextSpeller != null) {
            spellers.add(plainTextSpeller);
        }
        this.spellers = Collections.unmodifiableList(spellers);
    }

    private MorfologikSpeller getBinaryDict(String binaryDictPath, int maxEditDistance) throws IOException {
        if (binaryDictPath.endsWith(".dict")) {
            return new MorfologikSpeller(binaryDictPath, maxEditDistance);
        }
        throw new RuntimeException("Unsupported dictionary, binary Morfologik file needs to have suffix .dict: " + binaryDictPath);
    }

    @Nullable
    private MorfologikSpeller getPlainTextDictSpellerOrNull(BufferedReader plainTextReader, String plainTextReaderPath, String dictPath, int maxEditDistance) throws IOException {
        List lines = (List)dictCache.getUnchecked((Object)new BufferedReaderWithSource(plainTextReader, plainTextReaderPath));
        if (lines.isEmpty()) {
            return null;
        }
        Dictionary dictionary = this.getDictionary(lines, dictPath);
        return new MorfologikSpeller(dictionary, maxEditDistance);
    }

    private static List<byte[]> getLines(BufferedReader br) throws IOException {
        String line;
        ArrayList<byte[]> lines = new ArrayList<byte[]>();
        while ((line = br.readLine()) != null) {
            if (line.startsWith("#")) continue;
            lines.add(line.replaceFirst("#.*", "").trim().getBytes("utf-8"));
        }
        return lines;
    }

    private Dictionary getDictionary(List<byte[]> lines, String dictPath) throws IOException {
        Dictionary dictFromCache = dicPathToDict.get(dictPath);
        if (dictFromCache != null) {
            return dictFromCache;
        }
        ArrayList<byte[]> linesCopy = new ArrayList<byte[]>(lines);
        Collections.sort(linesCopy, FSABuilder.LEXICAL_ORDERING);
        FSA fsa = FSABuilder.build(linesCopy);
        ByteArrayOutputStream fsaOutStream = (ByteArrayOutputStream)new CFSA2Serializer().serialize(fsa, (OutputStream)new ByteArrayOutputStream());
        ByteArrayInputStream fsaInStream = new ByteArrayInputStream(fsaOutStream.toByteArray());
        String infoFile = dictPath.replace(".dict", ".info");
        Dictionary dict = Dictionary.read((InputStream)fsaInStream, (InputStream)JLanguageTool.getDataBroker().getFromResourceDirAsStream(infoFile));
        dicPathToDict.put(dictPath, dict);
        return dict;
    }

    public boolean isMisspelled(String word) {
        for (MorfologikSpeller speller : this.spellers) {
            if (speller.isMisspelled(word)) continue;
            return false;
        }
        return true;
    }

    public List<String> getSuggestions(String word) {
        ArrayList<String> result = new ArrayList<String>();
        for (MorfologikSpeller speller : this.spellers) {
            List<String> suggestions = speller.getSuggestions(word);
            for (String suggestion : suggestions) {
                if (result.contains(suggestion) || suggestion.equals(word)) continue;
                result.add(suggestion);
            }
        }
        return result;
    }

    public boolean convertsCase() {
        return this.convertsCase;
    }

    static class BufferedReaderWithSource {
        private BufferedReader br;
        private String path;

        BufferedReaderWithSource(BufferedReader br, String path) {
            this.br = Objects.requireNonNull(br);
            this.path = Objects.requireNonNull(path);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BufferedReaderWithSource that = (BufferedReaderWithSource)o;
            return this.path.equals(that.path);
        }

        public int hashCode() {
            return this.path.hashCode();
        }
    }
}

