/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.tools.j3d;

import com.bbn.openmap.tools.j3d.Camera;
import com.bbn.openmap.tools.j3d.OM3DConstants;
import com.bbn.openmap.tools.j3d.UniverseManager;
import java.awt.Dimension;
import java.awt.GraphicsConfigTemplate;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import javax.media.j3d.Background;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Vector3f;

public abstract class OM3DManager
implements OM3DConstants {
    protected float scaleFactor = 1.0f;
    protected UniverseManager universe = null;
    protected BranchGroup objRootBG = null;
    protected Camera cam = null;
    protected double boundsDimension = 1000.0;
    protected Background background = new Background();
    protected Canvas3D canvas = null;

    protected OM3DManager() {
        this.init();
    }

    protected void init() {
        GraphicsConfigTemplate3D template = new GraphicsConfigTemplate3D();
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice device = env.getDefaultScreenDevice();
        GraphicsConfiguration config = device.getBestConfiguration((GraphicsConfigTemplate)template);
        this.canvas = new Canvas3D(config);
        this.canvas.setSize(new Dimension(400, 400));
        this.objRootBG = new BranchGroup();
        this.objRootBG.setCapability(14);
        this.constructWorld(this.objRootBG);
    }

    protected void constructWorld(BranchGroup worldBranchGroup) {
        UniverseManager univ = new UniverseManager(worldBranchGroup);
        this.cam = new Camera();
        Vector3f loc = new Vector3f(0.0f, 0.0f, 0.0f);
        this.cam.setLocation(loc);
        this.cam.setHeadLight(true);
        this.cam.setCanvas(this.canvas);
        univ.addCamera(this.cam);
        this.universe = univ;
    }

    public Camera getCamera() {
        return this.cam;
    }

    public Canvas3D getCanvas() {
        return this.canvas;
    }

    public BranchGroup getWorld() {
        return this.objRootBG;
    }

    public void setScaleFactor(float sf) {
        this.scaleFactor = sf;
    }

    public float getScaleFactor() {
        return this.scaleFactor;
    }

    public void setBoundsDimension(double bd) {
        this.boundsDimension = bd;
    }

    public double getBoundsDimension() {
        return this.boundsDimension;
    }

    public VirtualUniverse getUniverse() {
        return this.universe;
    }

    public void setSceneBackground(Background background) {
        this.background = background;
    }

    public Background getSceneBackground() {
        return this.background;
    }
}

