/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap;

import com.bbn.openmap.Layer;
import com.bbn.openmap.MapBean;
import com.bbn.openmap.MapBeanRepaintPolicy;
import com.bbn.openmap.OMComponent;
import com.bbn.openmap.SoloMapComponent;
import com.bbn.openmap.util.Debug;
import java.awt.Graphics;

public class StandardMapBeanRepaintPolicy
extends OMComponent
implements MapBeanRepaintPolicy,
SoloMapComponent,
Cloneable {
    protected MapBean map;
    protected boolean DEBUG = false;

    public StandardMapBeanRepaintPolicy() {
        this.DEBUG = Debug.debugging("policy");
    }

    public StandardMapBeanRepaintPolicy(MapBean mb) {
        this.setMap(mb);
    }

    public void setMap(MapBean mb) {
        this.map = mb;
    }

    public MapBean getMap() {
        return this.map;
    }

    public void repaint(Layer layer) {
        if (this.map != null) {
            if (this.DEBUG) {
                Debug.output("SMBRP: forwarding repaint request for " + layer.getName());
            }
            this.map.repaint();
        } else {
            Debug.error("SMBRP: MapBean is null in repaint(" + layer.getName() + ")");
        }
    }

    public Graphics modifyGraphicsForPainting(Graphics graphics) {
        return graphics;
    }

    public void findAndInit(Object someObj) {
        if (someObj instanceof MapBean) {
            ((MapBean)someObj).setMapBeanRepaintPolicy(this);
            this.setMap((MapBean)someObj);
            if (this.DEBUG) {
                Debug.output(this.getClass().getName() + " found MapBean");
            }
        }
    }

    public void findAndUndo(Object someObj) {
        if (someObj instanceof MapBean && ((MapBean)someObj).getMapBeanRepaintPolicy() == this) {
            ((MapBean)someObj).setMapBeanRepaintPolicy(null);
            this.setMap(null);
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }
}

