/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.image;

import com.bbn.openmap.omGraphics.OMColor;
import doppelt.Quantize;
import doppelt.Quantize32;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.util.Arrays;

public class ColorReducer {
    private ColorReducer() {
    }

    public static BufferedImage reduce24(BufferedImage bi, int colors) {
        int width = bi.getWidth();
        int height = bi.getHeight();
        int[][] pixels = new int[width][height];
        boolean[][] transparent = new boolean[width][height];
        WritableRaster r1 = bi.getRaster();
        boolean inputHasAlpha = bi.getColorModel().hasAlpha();
        int[] argb = new int[4];
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                argb = r1.getPixel(x, y, argb);
                int r = argb[0];
                int g = argb[1];
                int b = argb[2];
                pixels[x][y] = r << 16 | g << 8 | b;
                if (!inputHasAlpha) continue;
                int a = argb[3];
                int[] nArray = pixels[x];
                int n = y;
                nArray[n] = nArray[n] | a << 24;
                transparent[x][y] = a < 128;
            }
        }
        int[] palette = Quantize.quantizeImage(pixels, colors - 1);
        byte[] r = new byte[colors];
        byte[] g = new byte[colors];
        byte[] b = new byte[colors];
        byte[] a = new byte[colors];
        Arrays.fill(r, (byte)OMColor.clear.getRed());
        Arrays.fill(g, (byte)OMColor.clear.getGreen());
        Arrays.fill(b, (byte)OMColor.clear.getBlue());
        Arrays.fill(a, (byte)OMColor.clear.getAlpha());
        for (int i = 0; i < palette.length; ++i) {
            Color c = new Color(palette[i], true);
            r[i + 1] = (byte)c.getRed();
            g[i + 1] = (byte)c.getGreen();
            b[i + 1] = (byte)c.getBlue();
            a[i + 1] = (byte)c.getAlpha();
        }
        IndexColorModel colorModel = new IndexColorModel(8, r.length, r, g, b, a);
        BufferedImage reducedImage = new BufferedImage(width, height, 13, colorModel);
        WritableRaster raster = reducedImage.getRaster();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int value = transparent[x][y] ? 0 : pixels[x][y] + 1;
                raster.setSample(x, y, 0, value);
            }
        }
        return reducedImage;
    }

    public static BufferedImage reduce32(BufferedImage bi, int colors) {
        int width = bi.getWidth();
        int height = bi.getHeight();
        int[][] pixels = new int[width][height];
        WritableRaster r1 = bi.getRaster();
        int[] argb = new int[4];
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                argb = r1.getPixel(x, y, argb);
                int a = argb[3];
                int r = argb[0];
                int g = argb[1];
                int b = argb[2];
                pixels[x][y] = a << 24 | r << 16 | g << 8 | b;
            }
        }
        int[] palette = Quantize32.quantizeImage(pixels, colors);
        colors = palette.length;
        boolean useExtraColors = false;
        int minimumColors = 2;
        if (colors < minimumColors) {
            colors = minimumColors;
            useExtraColors = true;
        }
        byte[] r = new byte[colors];
        byte[] g = new byte[colors];
        byte[] b = new byte[colors];
        byte[] a = new byte[colors];
        if (useExtraColors) {
            Arrays.fill(r, (byte)OMColor.green.getRed());
            Arrays.fill(g, (byte)OMColor.green.getGreen());
            Arrays.fill(b, (byte)OMColor.green.getBlue());
            Arrays.fill(a, (byte)OMColor.green.getAlpha());
        }
        for (int i = 0; i < palette.length; ++i) {
            Color c = new Color(palette[i], true);
            r[i] = (byte)c.getRed();
            g[i] = (byte)c.getGreen();
            b[i] = (byte)c.getBlue();
            a[i] = (byte)c.getAlpha();
        }
        IndexColorModel colorModel = new IndexColorModel(8, r.length, r, g, b, a);
        BufferedImage reducedImage = new BufferedImage(width, height, 13, colorModel);
        WritableRaster raster = reducedImage.getRaster();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int value = pixels[x][y];
                raster.setSample(x, y, 0, value);
            }
        }
        return reducedImage;
    }
}

