/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.event;

import com.bbn.openmap.OMComponent;
import com.bbn.openmap.event.OMEvent;
import com.bbn.openmap.io.CSVFile;
import com.bbn.openmap.layer.event.EventImporter;
import com.bbn.openmap.layer.event.EventLayer;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.time.TemporalOMGraphic;
import com.bbn.openmap.omGraphics.time.TemporalOMGraphicList;
import com.bbn.openmap.omGraphics.time.TemporalOMPoint;
import com.bbn.openmap.omGraphics.time.TemporalOMScalingIcon;
import com.bbn.openmap.omGraphics.time.TemporalPoint;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.time.TimeBounds;
import com.bbn.openmap.util.PropUtils;
import java.net.MalformedURLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;

public class CSVEventImporter
extends OMComponent
implements EventImporter {
    public static Logger logger = Logger.getLogger("com.bbn.openmap.layer.event.CSVEventImporter");
    public static final String LocationFileProperty = "locationFile";
    public static final String LocationHeaderProperty = "locationFileHasHeader";
    public static final String IconIndexProperty = "iconIndex";
    public static final String NameIndexProperty = "nameIndex";
    public static final String ActivityFileProperty = "activityFile";
    public static final String ActivityNameIndexProperty = "activityNameIndex";
    public static final String ActivityHeaderProperty = "activityFileHasHeader";
    public static final String LatIndexProperty = "latIndex";
    public static final String LonIndexProperty = "lonIndex";
    public static final String TimeIndexProperty = "timeIndex";
    public static final String EastIsNegProperty = "eastIsNeg";
    public static final String ShowNamesProperty = "showNames";
    public static final String DefaultIconURLProperty = "defaultURL";
    public static final String TimeFormatProperty = "timeFormat";
    protected SimpleDateFormat timeFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z");
    protected String locationFile;
    protected boolean locationHeader = true;
    protected int nameIndex;
    protected int iconIndex;
    protected String activityFile;
    protected boolean activityHeader = true;
    protected int activityNameIndex;
    protected int latIndex;
    protected int lonIndex;
    protected int timeIndex;
    protected boolean eastIsNeg = false;
    protected int orientation = 0;
    protected String defaultIconURL;
    protected boolean showNames = false;
    protected DrawingAttributes drawingAttributes = DrawingAttributes.getDefaultClone();

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public synchronized TemporalOMGraphicList createData(EventLayer callback) {
        list = new TemporalOMGraphicList();
        library = new Hashtable<String, TemporalOMPoint>();
        iconLibrary = new Hashtable<String, ImageIcon>();
        dataBounds = callback.getDataBounds();
        timeBounds = new TimeBounds();
        if (this.locationFile != null && this.nameIndex != -1) {
            CSVEventImporter.logger.fine("Reading location file...");
            try {
                locations = new CSVFile(this.locationFile);
                locations.loadData();
                records = locations.iterator();
                while (records.hasNext()) {
                    name = null;
                    iconName = null;
                    icon = null;
                    record = records.next();
                    if (record.isEmpty()) continue;
                    name = (String)record.elementAt(this.nameIndex);
                    if (this.iconIndex != -1 && (icon = (ImageIcon)iconLibrary.get(iconName = (String)record.elementAt(this.iconIndex))) == null && (icURL = PropUtils.getResourceOrFileOrURL(iconName)) != null && (icon = new ImageIcon(icURL)) != null) {
                        iconLibrary.put(iconName, icon);
                    }
                    if (name != null) {
                        location /* !! */  = icon == null ? new TemporalOMPoint(name, 1, true) : new TemporalOMScalingIcon((Object)name, 1, true, icon, 4000000.0f);
                        this.drawingAttributes.setTo(location /* !! */ );
                        library.put(name.intern(), location /* !! */ );
                        list.add(location /* !! */ );
                        continue;
                    }
                    CSVEventImporter.logger.warning("no name to use to create location: " + name);
                }
            }
            catch (MalformedURLException murle) {
                CSVEventImporter.logger.warning("problem finding the location file: " + this.locationFile);
                return list;
            }
            catch (ArrayIndexOutOfBoundsException aioobe) {
                CSVEventImporter.logger.warning("problem with parsing location file: " + this.locationFile);
                if (!CSVEventImporter.logger.isLoggable(Level.FINE)) ** GOTO lbl47
                CSVEventImporter.logger.fine("The problem is with one of the indexes into the file: \n" + aioobe.getMessage());
                aioobe.printStackTrace();
            }
            catch (NullPointerException npe) {
                CSVEventImporter.logger.warning("null pointer exception, most likely a problem finding the organization data file");
            }
        } else {
            CSVEventImporter.logger.warning("Location file (" + this.locationFile + ") not configured.");
            return list;
        }
lbl47:
        // 4 sources

        if (this.activityFile != null && this.activityNameIndex != -1 && this.latIndex != -1 && this.lonIndex != -1 && this.timeIndex != -1) {
            CSVEventImporter.logger.fine("Reading activity file...");
            try {
                activities = new CSVFile(this.activityFile);
                activities.loadData();
                records = activities.iterator();
                while (records.hasNext()) {
                    name = null;
                    record = records.next();
                    if (record.isEmpty()) continue;
                    name = record.elementAt(this.activityNameIndex).toString().intern();
                    try {
                        lat = ((Double)record.elementAt(this.latIndex)).floatValue();
                        lon = ((Double)record.elementAt(this.lonIndex)).floatValue();
                        timeString = (String)record.elementAt(this.timeIndex);
                        timeDate = this.timeFormat.parse(timeString);
                        time = timeDate.getTime();
                        timeBounds.addTimeToBounds(time);
                        dataBounds.add(lon, lat);
                        if (name != null) {
                            point = (TemporalOMGraphic)library.get(name);
                            if (point != null) {
                                location = new LatLonPoint.Double(lat, lon);
                                ts = new TemporalPoint(location, time);
                                point.addTimeStamp(ts);
                                event = new OMEvent(ts, name + " moving", time, location);
                                callback.events.add(event);
                                continue;
                            }
                            CSVEventImporter.logger.warning("ScenarioPoint not found for " + name + ", entry: " + record);
                            continue;
                        }
                        CSVEventImporter.logger.warning("no name to use to create activity point: " + name);
                    }
                    catch (ClassCastException cce) {
                        obj0 = record.elementAt(this.activityNameIndex);
                        obj1 = record.elementAt(this.latIndex);
                        obj2 = record.elementAt(this.lonIndex);
                        obj3 = record.elementAt(this.timeIndex);
                        CSVEventImporter.logger.warning("Problem with indexes in activity file for " + obj0 + " (" + obj0.getClass().getName() + "):\n\tlat index = " + this.latIndex + ", value = " + obj1 + " (" + obj1.getClass().getName() + ")\n\t lon index = " + this.lonIndex + ", value = " + obj2 + " (" + obj2.getClass().getName() + ")\n\t time index = " + this.timeIndex + ", value = " + obj3 + " (" + obj3.getClass().getName() + ")");
                    }
                    catch (ParseException pe) {
                        CSVEventImporter.logger.fine("Problem with time format. " + pe.getMessage());
                    }
                }
            }
            catch (MalformedURLException murle) {
                CSVEventImporter.logger.warning("problem with activity file: " + this.activityFile);
                return list;
            }
            catch (NullPointerException npe) {
                CSVEventImporter.logger.warning("null pointer exception, most likely a problem finding the activites data file");
            }
        } else {
            CSVEventImporter.logger.warning("Activity file (" + this.activityFile + ") not configured.");
            return list;
        }
        CSVEventImporter.logger.fine("Reading files OK");
        callback.setTimeBounds(timeBounds);
        return list;
    }

    public void setProperties(String prefix, Properties properties) {
        super.setProperties(prefix, properties);
        this.drawingAttributes.setProperties(prefix, properties);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.locationFile = properties.getProperty(prefix + LocationFileProperty);
        this.iconIndex = PropUtils.intFromProperties(properties, prefix + IconIndexProperty, -1);
        this.nameIndex = PropUtils.intFromProperties(properties, prefix + NameIndexProperty, -1);
        this.activityNameIndex = PropUtils.intFromProperties(properties, prefix + ActivityNameIndexProperty, -1);
        this.activityFile = properties.getProperty(prefix + ActivityFileProperty);
        this.latIndex = PropUtils.intFromProperties(properties, prefix + LatIndexProperty, -1);
        this.lonIndex = PropUtils.intFromProperties(properties, prefix + LonIndexProperty, -1);
        this.timeIndex = PropUtils.intFromProperties(properties, prefix + TimeIndexProperty, -1);
        this.eastIsNeg = PropUtils.booleanFromProperties(properties, prefix + EastIsNegProperty, this.eastIsNeg);
        this.showNames = PropUtils.booleanFromProperties(properties, prefix + ShowNamesProperty, this.showNames);
        this.defaultIconURL = properties.getProperty(prefix + DefaultIconURLProperty);
        this.locationHeader = PropUtils.booleanFromProperties(properties, prefix + LocationHeaderProperty, false);
        this.activityHeader = PropUtils.booleanFromProperties(properties, prefix + ActivityHeaderProperty, false);
        String timeFormatString = properties.getProperty(prefix + TimeFormatProperty, this.timeFormat.toPattern());
        this.timeFormat = new SimpleDateFormat(timeFormatString);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("EventLayer indexes:\n\tlocation file: " + this.locationFile + "\n\tlocation file has header: " + this.locationHeader + "\n\tnameIndex = " + this.nameIndex + "\n\ticonIndex = " + this.iconIndex + "\n\tactivity file: " + this.activityFile + "\n\tactivity file has header: " + this.activityHeader + "\n\tlatIndex = " + this.latIndex + "\n\tlonIndex = " + this.lonIndex + "\n\ttimeIndex = " + this.timeIndex);
        }
    }

    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        this.drawingAttributes.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        props.put(prefix + LocationFileProperty, PropUtils.unnull(this.locationFile));
        props.put(prefix + LocationHeaderProperty, new Boolean(this.locationHeader).toString());
        props.put(prefix + NameIndexProperty, this.nameIndex != -1 ? Integer.toString(this.nameIndex) : "");
        props.put(prefix + ActivityFileProperty, PropUtils.unnull(this.activityFile));
        props.put(prefix + ActivityHeaderProperty, new Boolean(this.activityHeader).toString());
        props.put(prefix + ActivityNameIndexProperty, this.activityNameIndex != -1 ? Integer.toString(this.activityNameIndex) : "");
        props.put(prefix + EastIsNegProperty, new Boolean(this.eastIsNeg).toString());
        props.put(prefix + ShowNamesProperty, new Boolean(this.showNames).toString());
        props.put(prefix + LatIndexProperty, this.latIndex != -1 ? Integer.toString(this.latIndex) : "");
        props.put(prefix + LonIndexProperty, this.lonIndex != -1 ? Integer.toString(this.lonIndex) : "");
        props.put(prefix + TimeIndexProperty, this.timeIndex != -1 ? Integer.toString(this.timeIndex) : "");
        props.put(prefix + IconIndexProperty, this.iconIndex != -1 ? Integer.toString(this.iconIndex) : "");
        props.put(prefix + DefaultIconURLProperty, PropUtils.unnull(this.defaultIconURL));
        return props;
    }

    public Properties getPropertyInfo(Properties list) {
        list = super.getPropertyInfo(list);
        list.put(LocationFileProperty, "URL of file containing location information.");
        list.put("locationFile.editor", "com.bbn.openmap.util.propertyEditor.FUPropertyEditor");
        list.put(LocationHeaderProperty, "Location file has a header row to be ignored.");
        list.put("locationFileHasHeader.editor", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        list.put(ActivityFileProperty, "URL of file containing scenario activity information.");
        list.put("activityFile.editor", "com.bbn.openmap.util.propertyEditor.FUPropertyEditor");
        list.put(ActivityHeaderProperty, "Activity file has a header row to be ignored.");
        list.put("activityFileHasHeader.editor", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        list.put(EastIsNegProperty, "Flag to note that negative latitude are over the eastern hemisphere.");
        list.put("eastIsNeg.editor", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        list.put(ShowNamesProperty, "Flag to note that locations should display their names.");
        list.put("showNames.editor", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        list.put(NameIndexProperty, "The column index, in the location file, of the location label text.");
        list.put(ActivityNameIndexProperty, "The column index, in the activity file, of the location label text.");
        list.put(LatIndexProperty, "The column index, in the activity file, of the latitudes.");
        list.put(LonIndexProperty, "The column index, in the activity file, of the longitudes.");
        list.put(TimeIndexProperty, "The column index, in the activity file, of the time of the activity.");
        list.put(IconIndexProperty, "The column index, in the location file, of the icon for locations (optional).");
        list.put(DefaultIconURLProperty, "The URL of an image file to use as a default for the location markers (optional).");
        this.drawingAttributes.getPropertyInfo(list);
        return list;
    }
}

