/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.test;

import com.bbn.openmap.geo.Geo;
import com.bbn.openmap.geo.Intersection;
import com.bbn.openmap.layer.editor.EditorLayer;
import com.bbn.openmap.omGraphics.OMAction;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMLine;
import com.bbn.openmap.omGraphics.OMPoint;
import com.bbn.openmap.util.Debug;
import java.awt.BasicStroke;
import java.awt.Color;

public class GeoCrossDemoLayer
extends EditorLayer {
    protected OMGraphicList lines = new OMGraphicList();

    public synchronized OMGraphicList prepare() {
        OMGraphicList list = this.getList();
        if (list == null) {
            list = new OMGraphicList();
        } else {
            list.clear();
        }
        OMLine oldLine = null;
        Geo ogc = null;
        for (OMGraphic omg : this.lines) {
            OMLine line = (OMLine)omg;
            double[] ll = line.getLL();
            Geo g1 = new Geo(ll[0], ll[1]);
            Geo g2 = new Geo(ll[2], ll[3]);
            Geo gc = g1.crossNormalize(g2);
            OMPoint p = new OMPoint((float)gc.getLatitude(), (float)gc.getLongitude(), 3);
            p.setLinePaint(line.getLinePaint());
            p.setFillPaint(line.getFillPaint());
            p.setStroke(line.getStroke());
            line.addArrowHead(true);
            list.add(line);
            list.add(p);
            if (oldLine != null && ogc != null) {
                double[] ll2 = oldLine.getLL();
                Geo g3 = new Geo(ll2[0], ll2[1]);
                Geo g4 = new Geo(ll2[2], ll2[3]);
                OMLine line2 = new OMLine((float)ogc.getLatitude(), (float)ogc.getLongitude(), (float)gc.getLatitude(), (float)gc.getLongitude(), 3);
                line2.setLinePaint(line.getLinePaint());
                line2.setStroke(new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{10.0f, 10.0f}, 0.0f));
                line2.addArrowHead(true);
                list.add(line2);
                Geo i = gc.crossNormalize(ogc);
                Color iColor = Color.white;
                if (!Intersection.isOnSegment(g1, g2, i) && !Intersection.isOnSegment(g3, g4, i)) {
                    i = i.antipode();
                    iColor = Color.black;
                }
                p = new OMPoint((float)i.getLatitude(), (float)i.getLongitude(), 3);
                p.setOval(true);
                p.setLinePaint(line.getLinePaint());
                p.setFillPaint(iColor);
                p.setStroke(line.getStroke());
                list.add(p);
            }
            oldLine = line;
            ogc = gc;
        }
        list.generate(this.getProjection());
        return list;
    }

    public void drawingComplete(OMGraphic omg, OMAction action) {
        this.releaseProxyMouseMode();
        if (omg instanceof OMLine && this.lines != null) {
            this.lines.doAction(omg, action);
            this.deselect(this.lines);
            this.doPrepare();
        } else {
            Debug.error("Layer " + this.getName() + " received " + omg + " and " + action + " with no list ready");
        }
        if (this.editorTool != null) {
            this.editorTool.drawingComplete(omg, action);
        }
    }
}

