/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.vpf;

import com.bbn.openmap.event.ProjectionListener;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.layer.policy.ListResetPCPolicy;
import com.bbn.openmap.layer.vpf.LibrarySelectionTable;
import com.bbn.openmap.layer.vpf.VPFAutoFeatureGraphicWarehouse;
import com.bbn.openmap.layer.vpf.VPFFeatureInfoHandler;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.proj.GeoProj;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.PropUtils;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VPFFeatureLayer
extends OMGraphicHandlerLayer
implements ProjectionListener,
ActionListener,
Serializable {
    private static final long serialVersionUID = 1L;
    public static Logger logger = Logger.getLogger("com.bbn.openmap.layer.vpf.VPFFeatureLayer");
    public static final String pathProperty = "vpfPath";
    public static final String cutoffScaleProperty = "cutoffScale";
    public static final String LibraryNameProperty = "libraryName";
    protected transient LibrarySelectionTable lst;
    protected transient VPFAutoFeatureGraphicWarehouse warehouse;
    protected String prefix;
    protected Properties props;
    protected String[] dataPaths = null;
    protected int cutoffScale = 31000000;
    protected String libraryName = null;
    private Properties defaultProps;

    public VPFFeatureLayer() {
        this.setProjectionChangePolicy(new ListResetPCPolicy(this));
        this.setMouseModeIDsForEvents(new String[]{"Gestures"});
        this.warehouse = new VPFAutoFeatureGraphicWarehouse();
    }

    public VPFFeatureLayer(String name) {
        this();
        this.setName(name);
    }

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        this.setAddToBeanContext(true);
        String realPrefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.cutoffScale = PropUtils.intFromProperties(props, realPrefix + cutoffScaleProperty, this.cutoffScale);
        this.libraryName = props.getProperty(realPrefix + LibraryNameProperty, this.libraryName);
        String[] path = PropUtils.initPathsFromProperties(props, realPrefix + pathProperty);
        if (path != null && path.length != 0) {
            this.setPath(path);
        }
        this.prefix = prefix;
        this.props = props;
        if (this.warehouse != null) {
            this.warehouse.setProperties(prefix, props);
            this.warehouse.setUseLibraries(PropUtils.parseSpacedMarkers(this.libraryName));
        }
    }

    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        String realPrefix = PropUtils.getScopedPropertyPrefix(this);
        props.put(realPrefix + cutoffScaleProperty, Integer.toString(this.cutoffScale));
        StringBuffer paths = new StringBuffer();
        String[] ps = this.getPath();
        for (int i = 0; ps != null && i < ps.length; ++i) {
            paths.append(ps[i]);
            if (i >= ps.length - 1) continue;
            paths.append(";");
        }
        props.put(realPrefix + pathProperty, paths.toString());
        props.put(realPrefix + LibraryNameProperty, PropUtils.unnull(this.libraryName));
        if (this.warehouse != null) {
            this.warehouse.getProperties(props);
        }
        return props;
    }

    public Properties getDefaultProperties() {
        if (this.defaultProps == null) {
            try {
                InputStream in = VPFFeatureLayer.class.getResourceAsStream("defaultVPFlayers.properties");
                Properties tmp = new Properties();
                if (in != null) {
                    tmp.load(in);
                    in.close();
                } else {
                    logger.warning("can't load default properties file");
                }
                this.defaultProps = tmp;
            }
            catch (IOException io) {
                logger.warning("can't load default properties: " + io);
                this.defaultProps = new Properties();
            }
        }
        return this.defaultProps;
    }

    public void setPath(String newPath) {
        logger.fine("setting paths to " + newPath);
        this.setPath(new String[]{newPath});
    }

    public void setPath(String[] newPaths) {
        this.dataPaths = newPaths;
        this.lst = null;
        this.initLST();
    }

    public String[] getPath() {
        return this.dataPaths;
    }

    protected void initLST() {
        logger.fine("initializing Library Selection Table (LST)");
        try {
            if (this.lst == null) {
                if (this.dataPaths == null) {
                    logger.info("VPFLayer|" + this.getName() + ": path not set");
                } else {
                    logger.fine("VPFLayer.initLST(dataPaths)");
                    this.lst = new LibrarySelectionTable(this.dataPaths);
                    this.lst.setCutoffScale(this.cutoffScale);
                }
            }
        }
        catch (FormatException f) {
            throw new IllegalArgumentException(f.getMessage());
        }
    }

    public VPFAutoFeatureGraphicWarehouse getWarehouse() {
        return this.warehouse;
    }

    public void checkWarehouse(boolean sbf) {
        if (this.warehouse == null) {
            logger.fine("need to create warehouse");
            this.warehouse = new VPFAutoFeatureGraphicWarehouse();
        }
    }

    public synchronized OMGraphicList prepare() {
        if (this.lst == null) {
            try {
                this.initLST();
            }
            catch (IllegalArgumentException iae) {
                logger.warning("VPFLayer.prepare: Illegal Argument Exception.\n\nPerhaps a file not found.  Check to make sure that the paths to the VPF data directories are the parents of \"lat\" or \"lat.\" files. \n\n" + iae);
                return null;
            }
            if (this.lst == null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("VPFLayer| " + this.getName() + " prepare(), Library Selection Table not set.");
                }
                return null;
            }
        }
        if (this.warehouse == null) {
            StringBuffer dpb = new StringBuffer();
            if (this.dataPaths != null) {
                for (int num = 0; num < this.dataPaths.length; ++num) {
                    if (num > 0) {
                        dpb.append(":");
                    }
                    dpb.append(this.dataPaths[num]);
                }
            }
            logger.warning("VPFLayer.getRectangle:  Data path probably wasn't set correctly (" + dpb.toString() + ").  The warehouse not initialized.");
            return null;
        }
        Projection p = this.getProjection();
        if (p == null || !(p instanceof GeoProj)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("VPFLayer.getRectangle() called with a projection (" + p + ") set in the layer, which isn't being handled.");
            }
            return new OMGraphicList();
        }
        LatLonPoint ll1 = (LatLonPoint)p.getUpperLeft();
        LatLonPoint ll2 = (LatLonPoint)p.getLowerRight();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("calling draw with boundaries: " + ll1 + " " + ll2);
        }
        long start = System.currentTimeMillis();
        OMGraphicList omgList = new OMGraphicList();
        try {
            omgList = this.warehouse.getFeatures(this.lst, ll1, ll2, p, omgList);
        }
        catch (FormatException fe) {
            logger.warning("Caught FormatException reading features: " + fe.getMessage());
        }
        long stop = System.currentTimeMillis();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("read time: " + (double)(stop - start) / 1000.0 + " seconds");
        }
        return omgList;
    }

    public String getToolTipTextFor(OMGraphic omg) {
        return (String)omg.getAttribute("Tooltip");
    }

    public String getInfoText(OMGraphic omg) {
        return (String)omg.getAttribute("Information Line");
    }

    public boolean isHighlightable(OMGraphic omg) {
        VPFFeatureInfoHandler vfih = this.warehouse.getFeatInfoHandler();
        if (vfih != null) {
            return vfih.isHighlightable(omg);
        }
        return false;
    }

    public void highlight(OMGraphic omg) {
        VPFFeatureInfoHandler vfih = this.warehouse.getFeatInfoHandler();
        if (vfih != null && vfih.shouldPaintHighlight(omg)) {
            super.highlight(omg);
        }
    }

    public void unhighlight(OMGraphic omg) {
        VPFFeatureInfoHandler vfih = this.warehouse.getFeatInfoHandler();
        if (vfih != null && vfih.shouldPaintHighlight(omg)) {
            super.unhighlight(omg);
        }
    }
}

