/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.dataAccess.image.WorldFile;
import com.bbn.openmap.image.BufferedImageHelper;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicAdapter;
import com.bbn.openmap.omGraphics.OMRaster;
import com.bbn.openmap.omGraphics.OMScalingRaster;
import com.bbn.openmap.omGraphics.util.ImageWarp;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.coords.GeoCoordTransformation;
import com.bbn.openmap.proj.coords.LatLonGCT;
import com.bbn.openmap.util.DataBounds;
import com.bbn.openmap.util.PropUtils;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.net.MalformedURLException;
import java.net.URL;

public class OMWarpingImage
extends OMGraphicAdapter
implements OMGraphic {
    private static final long serialVersionUID = 1L;
    protected ImageWarp warp;
    protected OMRaster raster;
    protected Projection lastProjection = null;

    public OMWarpingImage(String imagePath) throws MalformedURLException, InterruptedException {
        this.setWarp(imagePath, (GeoCoordTransformation)LatLonGCT.INSTANCE, new DataBounds(-180.0, -90.0, 180.0, 90.0));
    }

    public OMWarpingImage(String imagePath, GeoCoordTransformation transform, DataBounds imageBounds) throws MalformedURLException, InterruptedException {
        this.setWarp(imagePath, transform, imageBounds);
    }

    public OMWarpingImage(String imagePath, GeoCoordTransformation transform, WorldFile worldfile) throws MalformedURLException, InterruptedException {
        this.setWarp(imagePath, transform, worldfile);
    }

    public OMWarpingImage(BufferedImage bi) {
        this.setWarp(bi, (GeoCoordTransformation)LatLonGCT.INSTANCE, new DataBounds(-180.0, -90.0, 180.0, 90.0));
    }

    public OMWarpingImage(BufferedImage bi, GeoCoordTransformation transform, DataBounds imageBounds) {
        this.setWarp(bi, transform, imageBounds);
    }

    public OMWarpingImage(BufferedImage bi, GeoCoordTransformation transform, WorldFile worldfile) {
        this.setWarp(bi, transform, worldfile);
    }

    public OMWarpingImage(int[] pix, int width, int height) {
        this.setWarp(pix, width, height, (GeoCoordTransformation)LatLonGCT.INSTANCE, new DataBounds(-180.0, -90.0, 180.0, 90.0));
    }

    public OMWarpingImage(int[] pix, int width, int height, GeoCoordTransformation transform, DataBounds imageBounds) {
        this.setWarp(pix, width, height, transform, imageBounds);
    }

    public OMWarpingImage(int[] pix, int width, int height, GeoCoordTransformation transform, WorldFile worldfile) {
        this.setWarp(pix, width, height, transform, worldfile);
    }

    public OMWarpingImage(OMScalingRaster omsr, GeoCoordTransformation transform) {
        ImageWarp iw;
        if (omsr != null && (iw = omsr.getImageWarp(transform)) != null) {
            this.setWarp(iw);
        }
    }

    public void setWarp(String imagePath, GeoCoordTransformation transform, DataBounds imageBounds) throws MalformedURLException, InterruptedException {
        URL imageURL = PropUtils.getResourceOrFileOrURL(imagePath);
        BufferedImage bi = BufferedImageHelper.getBufferedImage(imageURL);
        this.setWarp(new ImageWarp(bi, transform, imageBounds));
    }

    public void setWarp(String imagePath, GeoCoordTransformation transform, WorldFile worldfile) throws MalformedURLException, InterruptedException {
        URL imageURL = PropUtils.getResourceOrFileOrURL(imagePath);
        BufferedImage bi = BufferedImageHelper.getBufferedImage(imageURL);
        this.setWarp(new ImageWarp(bi, transform, worldfile));
    }

    public void setWarp(int[] pix, int width, int height, GeoCoordTransformation transform, DataBounds imageBounds) {
        this.setWarp(new ImageWarp(pix, width, height, transform, imageBounds));
    }

    public void setWarp(int[] pix, int width, int height, GeoCoordTransformation transform, WorldFile worldfile) {
        this.setWarp(new ImageWarp(pix, width, height, transform, worldfile));
    }

    public void setWarp(BufferedImage bi, GeoCoordTransformation transform, DataBounds imageBounds) {
        this.setWarp(new ImageWarp(bi, transform, imageBounds));
    }

    public void setWarp(BufferedImage bi, GeoCoordTransformation transform, WorldFile worldfile) {
        this.setWarp(new ImageWarp(bi, transform, worldfile));
    }

    public void setWarp(ImageWarp wrp) {
        this.warp = wrp;
        this.setNeedToRegenerate(true);
    }

    public ImageWarp getWarp() {
        return this.warp;
    }

    public boolean generate(Projection proj) {
        if (this.warp != null && (this.updateImageForProjection(proj) || this.raster == null)) {
            this.raster = this.warp.getOMRaster(proj);
            DrawingAttributes.sTransfer(this, this.raster);
        }
        this.setNeedToRegenerate(false);
        return true;
    }

    protected boolean updateImageForProjection(Projection proj) {
        boolean ret = proj.equals(this.lastProjection);
        this.lastProjection = proj;
        return !ret;
    }

    public void render(Graphics g) {
        if (this.raster != null && this.isRenderable(this.raster.getShape())) {
            this.raster.setSelected(this.isSelected());
            this.raster.setMatted(this.isMatted());
            this.raster.render(g);
        }
    }

    public float distance(double x, double y) {
        if (this.raster != null) {
            return this.raster.distance(x, y);
        }
        return super.distance(x, y);
    }

    public float distanceToEdge(double x, double y) {
        if (this.raster != null) {
            return this.raster.distanceToEdge(x, y);
        }
        return super.distanceToEdge(x, y);
    }

    public boolean contains(double x, double y) {
        if (this.raster != null) {
            return this.raster.contains(x, y);
        }
        return super.contains(x, y);
    }
}

