/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics.grid;

import com.bbn.openmap.omGraphics.grid.ElevationColors;
import com.bbn.openmap.omGraphics.grid.GeneratorLoader;
import com.bbn.openmap.util.ComponentFactory;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.beans.PropertyChangeListener;
import java.util.Properties;

public class ColorGeneratorLoader
extends GeneratorLoader {
    public static final String ColorsClassProperty = "colorsClass";
    public static final String COLORS_PROPERTY = "COLORS";
    public static final String DEFAULT_COLORS_CLASS = "com.bbn.openmap.omGraphics.grid.GreyscaleSlopeColors";
    protected ElevationColors colors;

    public ColorGeneratorLoader() {
        this.setPrettyName(this.i18n.get(ColorGeneratorLoader.class, "name", "Color Shading"));
    }

    public void setColors(ElevationColors cols) {
        ElevationColors oldColors = this.colors;
        this.colors = cols;
        if (oldColors != this.colors) {
            this.firePropertyChange(COLORS_PROPERTY, oldColors, this.colors);
        }
    }

    public ElevationColors getColors() {
        if (this.colors == null) {
            try {
                this.colors = (ElevationColors)Class.forName(DEFAULT_COLORS_CLASS).newInstance();
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return this.colors;
    }

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        String colorsClassProperty = props.getProperty(prefix + ColorsClassProperty);
        if (colorsClassProperty != null) {
            try {
                this.setColors((ElevationColors)ComponentFactory.create(colorsClassProperty));
            }
            catch (ClassCastException cce) {
                Debug.output("SlopeGeneratorLoader created a " + colorsClassProperty + ", but it's not a ElevationColors object");
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        super.addPropertyChangeListener(COLORS_PROPERTY, pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        super.removePropertyChangeListener(COLORS_PROPERTY, pcl);
    }
}

