/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics.grid;

import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGrid;
import com.bbn.openmap.omGraphics.OMRaster;
import com.bbn.openmap.omGraphics.SinkGraphic;
import com.bbn.openmap.omGraphics.grid.GridData;
import com.bbn.openmap.omGraphics.grid.OMGridGenerator;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;

public class SimpleColorGenerator
implements OMGridGenerator {
    public OMGraphic generate(OMGrid grid, Projection proj) {
        Debug.message("grid", "SimpleColorGenerator: generating OMRaster from grid");
        if (grid.height <= 0 || grid.width <= 0) {
            Debug.message("grid", "SimpleColorGenerator: grid height/width ZERO!");
            return SinkGraphic.getSharedInstance();
        }
        OMRaster raster = new OMRaster(grid.point1.x, grid.point1.y, grid.width, grid.height, new int[grid.width * grid.height]);
        int rows = grid.getRows();
        int columns = grid.getColumns();
        RasterHelper rasterHelper = this.getRasterHelper(grid.getData());
        boolean major = grid.getMajor();
        double y_interval = (double)rows / (double)grid.height;
        double x_interval = (double)columns / (double)grid.width;
        Debug.message("grid", "SimpleColorGenerator: y_point_interval = " + y_interval + ", x_point_interval = " + x_interval);
        for (int x = 0; x < grid.width; ++x) {
            for (int y = 0; y < grid.height; ++y) {
                int value;
                int post_x = (int)Math.round(x_interval * (double)x);
                int post_y = grid.getRenderType() == 1 ? (int)Math.round(y_interval * ((double)(grid.height - 1) - (double)y)) : (int)Math.round(y_interval * (double)y);
                if (major) {
                    if (post_x >= columns) {
                        post_x = columns - 1;
                    }
                    if (post_y >= rows) {
                        post_y = rows - 1;
                    }
                    value = this.calibratePointValue(rasterHelper.get(post_x, post_y));
                } else {
                    if (post_y >= columns) {
                        post_y = columns - 1;
                    }
                    if (post_x >= rows) {
                        post_x = rows - 1;
                    }
                    value = this.calibratePointValue(rasterHelper.get(post_y, post_x));
                }
                raster.setPixel(x, y, value);
            }
        }
        raster.generate(proj);
        return raster;
    }

    public int calibratePointValue(int source) {
        return source;
    }

    public boolean needGenerateToRender() {
        return true;
    }

    public int[] createGreyscaleColors(int num_colors, int opaqueness) {
        int[] tempColors = new int[num_colors];
        if (num_colors == 0) {
            num_colors = 216;
        }
        int grey_interval = 256 / num_colors;
        for (int i = 0; i < num_colors; ++i) {
            if (i == 0) {
                tempColors[i] = (opaqueness & 0xFF) << 24 | 0xBF0000 | 0xEF00 | 0xFF;
                continue;
            }
            int color = i * grey_interval + grey_interval / 2;
            tempColors[i] = (opaqueness & 0xFF) << 24 | (color & 0xFF) << 16 | (color & 0xFF) << 8 | color & 0xFF;
        }
        return tempColors;
    }

    protected RasterHelper getRasterHelper(GridData gd) {
        if (gd instanceof GridData.Short) {
            return new ShortRasterHelper(((GridData.Short)gd).getData());
        }
        if (gd instanceof GridData.Int) {
            return new IntRasterHelper(((GridData.Int)gd).getData());
        }
        if (gd instanceof GridData.Float) {
            return new FloatRasterHelper(((GridData.Float)gd).getData());
        }
        if (gd instanceof GridData.Byte) {
            return new ByteRasterHelper(((GridData.Byte)gd).getData());
        }
        if (gd instanceof GridData.Char) {
            return new CharRasterHelper(((GridData.Char)gd).getData());
        }
        return new DoubleRasterHelper(((GridData.Double)gd).getData());
    }

    protected class CharRasterHelper
    implements RasterHelper {
        char[][] data;

        public CharRasterHelper(char[][] intData) {
            this.data = intData;
        }

        public int get(int x, int y) {
            return this.data[x][y];
        }
    }

    protected class DoubleRasterHelper
    implements RasterHelper {
        double[][] data;

        public DoubleRasterHelper(double[][] intData) {
            this.data = intData;
        }

        public int get(int x, int y) {
            return (int)this.data[x][y];
        }
    }

    protected class FloatRasterHelper
    implements RasterHelper {
        float[][] data;

        public FloatRasterHelper(float[][] intData) {
            this.data = intData;
        }

        public int get(int x, int y) {
            return (int)this.data[x][y];
        }
    }

    protected class ByteRasterHelper
    implements RasterHelper {
        byte[][] data;

        public ByteRasterHelper(byte[][] intData) {
            this.data = intData;
        }

        public int get(int x, int y) {
            return this.data[x][y];
        }
    }

    protected class ShortRasterHelper
    implements RasterHelper {
        short[][] data;

        public ShortRasterHelper(short[][] intData) {
            this.data = intData;
        }

        public int get(int x, int y) {
            return this.data[x][y];
        }
    }

    protected class IntRasterHelper
    implements RasterHelper {
        int[][] data;

        public IntRasterHelper(int[][] intData) {
            this.data = intData;
        }

        public int get(int x, int y) {
            return this.data[x][y];
        }
    }

    protected static interface RasterHelper {
        public int get(int var1, int var2);
    }
}

