/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.plugin;

import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMColorChooser;
import com.bbn.openmap.omGraphics.OMGeometry;
import com.bbn.openmap.omGraphics.OMGeometryList;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMLine;
import com.bbn.openmap.omGraphics.OMText;
import com.bbn.openmap.omGraphics.geom.PolygonGeometry;
import com.bbn.openmap.omGraphics.geom.PolylineGeometry;
import com.bbn.openmap.plugin.OMGraphicHandlerPlugIn;
import com.bbn.openmap.proj.Ellipsoid;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.proj.coords.MGRSPoint;
import com.bbn.openmap.proj.coords.UTMPoint;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PaletteHelper;
import com.bbn.openmap.util.PropUtils;
import com.bbn.openmap.util.quadtree.QuadTree;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Paint;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UTMGridPlugIn
extends OMGraphicHandlerPlugIn {
    protected boolean UTM_DEBUG = false;
    protected boolean UTM_DEBUG_VERBOSE = false;
    public static final int INTERVAL_100K = 100000;
    public static final float DEFAULT_UTM_LABEL_CUTOFF_SCALE = 3.3E7f;
    protected boolean showZones = true;
    protected boolean showLabels = true;
    protected float labelCutoffScale = 3.3E7f;
    protected boolean show100kGrid = false;
    protected boolean labelsAsMGRS = false;
    protected int distanceGridResolution = 0;
    protected Paint utmGridPaint = Color.black;
    protected Paint distanceGridPaint = Color.black;
    protected QuadTree<OMText> labelTree;
    protected OMGraphicList labelList;
    protected OMGeometryList verticalList;
    protected OMGeometryList horizontalList;
    public static final String ShowLabelsProperty = "showLabels";
    public static final String ShowZonesProperty = "showZones";
    public static final String LabelCutoffScaleProperty = "labelCutoffScale";
    public static final String Show100kGridProperty = "show100KmGrid";
    public static final String UTMGridColorProperty = "utmGridColor";
    public static final String DistanceGridColorProperty = "distanceGridColor";
    public static final String DistanceGridResolutionProperty = "distanceGridResolution";
    public static final String LabelsAsMGRSProperty = "mgrsLabels";
    private boolean colorChooserLock = false;

    public UTMGridPlugIn() {
        this.UTM_DEBUG = Debug.debugging("utmgrid");
        this.UTM_DEBUG_VERBOSE = Debug.debugging("utmgrid_verbose");
    }

    protected OMGeometryList createUTMZoneVerticalLines() {
        OMGeometryList verticalList = new OMGeometryList();
        double[] points = null;
        for (double lon = -180.0; lon < 180.0; lon += 6.0) {
            points = lon == 6.0 ? new double[]{56.0, lon, -80.0, lon} : (lon > 6.0 && lon < 42.0 ? new double[]{72.0, lon, -80.0, lon} : new double[]{84.0, lon, -80.0, lon});
            verticalList.add(new PolylineGeometry.LL(points, 0, 3));
        }
        points = new double[]{72.0, 6.0, 64.0, 6.0};
        verticalList.add(new PolylineGeometry.LL(points, 0, 3));
        points = new double[]{64.0, 3.0, 56.0, 3.0};
        verticalList.add(new PolylineGeometry.LL(points, 0, 3));
        points = new double[]{84.0, 9.0, 72.0, 9.0};
        verticalList.add(new PolylineGeometry.LL(points, 0, 3));
        points = new double[]{84.0, 21.0, 72.0, 21.0};
        verticalList.add(new PolylineGeometry.LL(points, 0, 3));
        points = new double[]{84.0, 33.0, 72.0, 33.0};
        verticalList.add(new PolylineGeometry.LL(points, 0, 3));
        verticalList.setLinePaint(this.utmGridPaint);
        return verticalList;
    }

    protected OMGeometryList createUTMZoneHorizontalLines() {
        OMGeometryList horizontalList = new OMGeometryList();
        double[] points = null;
        for (double lat = -80.0; lat <= 72.0; lat += 8.0) {
            points = new double[]{lat, -180.0, lat, -90.0, lat, 0.0, lat, 90.0, lat, 180.0};
            horizontalList.add(new PolylineGeometry.LL(points, 0, 2));
        }
        points = new double[]{84.0, -180.0, 84.0, -90.0, 84.0, 0.0, 84.0, 90.0, 84.0, 180.0};
        horizontalList.add(new PolylineGeometry.LL(points, 0, 2));
        horizontalList.setLinePaint(this.utmGridPaint);
        return horizontalList;
    }

    protected QuadTree<OMText> createUTMZoneLabels() {
        float latitude;
        QuadTree<OMText> labelTree = new QuadTree<OMText>();
        MGRSPoint utm = new MGRSPoint();
        LatLonPoint.Double llp = new LatLonPoint.Double();
        for (int lat = -80; lat <= 72; lat += 8) {
            for (int lon = -180; lon < 180; lon += 6) {
                latitude = lat;
                float longitude = lon;
                if (lat == 56 && lon == 6) {
                    longitude = 3.0f;
                } else if (lat == 72 && lon > 0 && lon < 42) continue;
                ((LatLonPoint)llp).setLatLon(latitude, longitude);
                this.addLabel(llp, UTMPoint.LLtoUTM(llp, utm), labelTree);
            }
        }
        latitude = 72.0f;
        ((LatLonPoint)llp).setLatLon(latitude, 9.0);
        this.addLabel(llp, UTMPoint.LLtoUTM(llp, utm), labelTree);
        ((LatLonPoint)llp).setLongitude(21.0);
        this.addLabel(llp, UTMPoint.LLtoUTM(llp, utm), labelTree);
        ((LatLonPoint)llp).setLongitude(33.0);
        this.addLabel(llp, UTMPoint.LLtoUTM(llp, utm), labelTree);
        return labelTree;
    }

    protected QuadTree<OMText> createMGRSZoneLabels() {
        float latitude;
        QuadTree<OMText> labelTree = new QuadTree<OMText>();
        MGRSPoint mgrs = new MGRSPoint();
        LatLonPoint.Double llp = new LatLonPoint.Double();
        for (int lat = -80; lat <= 72; lat += 8) {
            for (int lon = -180; lon < 180; lon += 6) {
                latitude = lat;
                float longitude = lon;
                if (lat == 56 && lon == 6) {
                    longitude = 3.0f;
                } else if (lat == 72 && lon > 0 && lon < 42) continue;
                ((LatLonPoint)llp).setLatLon(latitude, longitude);
                this.addLabel(llp, MGRSPoint.LLtoMGRS(llp, mgrs), labelTree);
            }
        }
        latitude = 72.0f;
        ((LatLonPoint)llp).setLatLon(latitude, 9.0);
        this.addLabel(llp, MGRSPoint.LLtoMGRS(llp, mgrs), labelTree);
        ((LatLonPoint)llp).setLongitude(21.0);
        this.addLabel(llp, MGRSPoint.LLtoMGRS(llp, mgrs), labelTree);
        ((LatLonPoint)llp).setLongitude(33.0);
        this.addLabel(llp, MGRSPoint.LLtoMGRS(llp, mgrs), labelTree);
        return labelTree;
    }

    protected void addLabel(LatLonPoint llp, UTMPoint utm, QuadTree<OMText> labelTree) {
        double latitude = llp.getY();
        double longitude = llp.getX();
        labelTree.put(latitude, longitude, new OMText(latitude, longitude, 2.0f, -2.0f, utm.zone_number + "" + utm.zone_letter, 0));
    }

    protected OMGraphicList createEquiDistanceLines(UTMPoint utm, int gridLineInterval) {
        OMLine line;
        int i;
        OMGraphicList list = new OMGraphicList();
        UTMPoint utm1 = new UTMPoint(utm);
        UTMPoint utm2 = new UTMPoint(utm);
        LatLonPoint point1 = new LatLonPoint.Double();
        LatLonPoint point2 = new LatLonPoint.Double();
        UTMPoint utmp = new UTMPoint(utm);
        LatLonPoint llp = new LatLonPoint.Double();
        int endNorthing = (int)Math.floor(utm.northing / 100000.0) + 10;
        int startNorthing = (int)Math.floor(utm.northing / 100000.0) - 10;
        int numVertLines = 9;
        int numHorLines = endNorthing - startNorthing;
        double[][] vertPoints = new double[numVertLines][numHorLines * 2];
        if (this.UTM_DEBUG_VERBOSE) {
            Debug.output("Array is [" + vertPoints.length + "][" + vertPoints[0].length + "]");
        }
        int coordCount = 0;
        boolean doPolys = true;
        utm1.easting = 100000.0;
        utm2.easting = 900000.0;
        for (i = startNorthing; i < endNorthing; ++i) {
            utm2.northing = utm1.northing = (double)((float)i * (float)gridLineInterval);
            utmp.northing = utm1.northing;
            if (doPolys) {
                for (int j = 0; j < numVertLines; ++j) {
                    utmp.easting = (float)(j + 1) * (float)gridLineInterval;
                    llp = utmp.toLatLonPoint(Ellipsoid.WGS_84, llp);
                    vertPoints[j][coordCount] = llp.getY();
                    vertPoints[j][coordCount + 1] = llp.getX();
                    if (!this.UTM_DEBUG_VERBOSE) continue;
                    Debug.output("for vline " + j + ", point " + i + ", easting: " + utmp.easting + ", northing: " + utmp.northing + ", lat:" + vertPoints[j][coordCount] + ", lon:" + vertPoints[j][coordCount + 1]);
                }
                coordCount += 2;
            }
            point1 = utm1.toLatLonPoint(Ellipsoid.WGS_84, point1);
            point2 = utm2.toLatLonPoint(Ellipsoid.WGS_84, point2);
            double lat2 = point1.getLatitude();
            if (!(lat2 < 84.0)) continue;
            line = new OMLine(point1.getY(), point1.getX(), point2.getY(), point2.getX(), 3);
            line.setLinePaint(this.distanceGridPaint);
            list.add(line);
        }
        if (doPolys) {
            OMGeometryList polys = new OMGeometryList();
            for (i = 0; i < vertPoints.length; ++i) {
                if (this.UTM_DEBUG_VERBOSE) {
                    for (int k = 0; k < vertPoints[i].length; k += 2) {
                        System.out.println(" for poly " + i + ": lat = " + vertPoints[i][k] + ", lon = " + vertPoints[i][k + 1]);
                    }
                }
                PolylineGeometry.LL poly = new PolylineGeometry.LL(vertPoints[i], 0, 3);
                polys.add(poly);
            }
            polys.setLinePaint(this.distanceGridPaint);
            list.add(polys);
        } else {
            if (this.UTM_DEBUG) {
                Debug.output("Doing vertical lines");
            }
            utm1.northing = startNorthing;
            utm2.northing = endNorthing;
            for (i = 1; i <= 9; ++i) {
                utm1.easting = (float)i * 100000.0f;
                utm2.easting = (float)i * 100000.0f;
                point1 = utm1.toLatLonPoint(Ellipsoid.WGS_84, point1);
                point2 = utm2.toLatLonPoint(Ellipsoid.WGS_84, point2);
                line = new OMLine(point1.getY(), point1.getX(), point2.getY(), point2.getX(), 3);
                line.setLinePaint(this.distanceGridPaint);
                list.add(line);
            }
        }
        return list;
    }

    protected OMGeometryList createMGRSRectangles(LatLonPoint llp, int accuracy, int numRects) {
        return this.createMGRSRectangles(llp, accuracy, numRects, Ellipsoid.WGS_84);
    }

    protected OMGeometryList createMGRSRectangles(LatLonPoint llp, int accuracy, int numRects, Ellipsoid ellipsoid) {
        MGRSPoint mgrs = new MGRSPoint();
        mgrs.setAccuracy(accuracy);
        MGRSPoint.LLtoMGRS(llp, ellipsoid, mgrs);
        double accuracyBonus = 100000.0 / Math.pow(10.0, accuracy);
        OMGeometryList list = new OMGeometryList();
        for (double i = (double)(-numRects) * accuracyBonus; i < (double)numRects * accuracyBonus; i += accuracyBonus) {
            for (double j = (double)(-numRects) * accuracyBonus; j < (double)numRects * accuracyBonus; j += accuracyBonus) {
                if (Debug.debugging("utmdistancegrid")) {
                    System.out.print(".");
                }
                list.add(this.createMGRSRectangle(mgrs, i, j, accuracyBonus, ellipsoid));
            }
            if (!Debug.debugging("utmdistancegrid")) continue;
            System.out.println();
        }
        return list;
    }

    protected OMGeometry createMGRSRectangle(MGRSPoint mgrsBasePoint, double voffset, double hoffset, double interval, Ellipsoid ellipsoid) {
        double[] llpoints = new double[10];
        double easting = mgrsBasePoint.easting + hoffset;
        double northing = mgrsBasePoint.northing + voffset;
        int zone_number = mgrsBasePoint.zone_number;
        char zone_letter = mgrsBasePoint.zone_letter;
        LatLonPoint llp1 = new LatLonPoint.Double();
        llp1 = MGRSPoint.MGRStoLL(ellipsoid, northing, easting, zone_number, zone_letter, llp1);
        llpoints[0] = llp1.getY();
        llpoints[1] = llp1.getX();
        llpoints[8] = llp1.getY();
        llpoints[9] = llp1.getX();
        MGRSPoint.MGRStoLL(ellipsoid, northing, easting + interval, zone_number, zone_letter, llp1);
        llpoints[2] = llp1.getY();
        llpoints[3] = llp1.getX();
        MGRSPoint.MGRStoLL(ellipsoid, northing + interval, easting + interval, zone_number, zone_letter, llp1);
        llpoints[4] = llp1.getY();
        llpoints[5] = llp1.getX();
        MGRSPoint.MGRStoLL(ellipsoid, northing + interval, easting, zone_number, zone_letter, llp1);
        llpoints[6] = llp1.getY();
        llpoints[7] = llp1.getX();
        MGRSPoint mgrs = new MGRSPoint(northing, easting, zone_number, zone_letter);
        mgrs.resolve(mgrsBasePoint.getAccuracy());
        String mgrsString = mgrs.getMGRS();
        if (Debug.debugging("utmgriddetail")) {
            Debug.output(" - assigning " + mgrsString + " to poly with " + mgrs.getAccuracy());
        }
        PolygonGeometry.LL poly = new PolygonGeometry.LL(llpoints, 0, interval <= 1000.0 ? 1 : 3);
        poly.putAttribute("APP_OBJECT", mgrsString);
        return poly;
    }

    @Override
    public OMGraphicList getRectangle(Projection p) {
        OMGraphicList list = this.getList();
        if (this.verticalList == null) {
            this.verticalList = this.createUTMZoneVerticalLines();
            this.horizontalList = this.createUTMZoneHorizontalLines();
            this.labelTree = this.labelsAsMGRS ? this.createMGRSZoneLabels() : this.createUTMZoneLabels();
        }
        list.clear();
        if (this.showZones) {
            list.add(this.verticalList);
            list.add(this.horizontalList);
        }
        LatLonPoint center = p.getCenter(new LatLonPoint.Double());
        UTMPoint utm = new UTMPoint(center);
        if (this.show100kGrid) {
            Debug.message("utmgrid", "Creating 100k distance lines...");
            OMGraphicList hunKLines = this.createEquiDistanceLines(utm, 100000);
            list.add(hunKLines);
        }
        if (this.distanceGridResolution > 0) {
            Debug.message("utmgrid", "Creating distance lines...");
            double decisionAid = 100000.0 / Math.pow(10.0, this.distanceGridResolution);
            double dglc = 30.0 * decisionAid;
            int numberBasedForScale = (int)((double)p.getScale() / (2.0 * decisionAid));
            if (numberBasedForScale > 10) {
                numberBasedForScale = 10;
            }
            OMGeometryList geoList = this.createMGRSRectangles(center, this.distanceGridResolution, numberBasedForScale);
            if (this.showLabels && (double)p.getScale() <= dglc) {
                Debug.message("utmgrid", "Creating labels for distance lines ...");
                OMGraphicList textList = new OMGraphicList();
                LatLonPoint.Double llp = new LatLonPoint.Double();
                Point point = new Point();
                for (PolygonGeometry.LL pll : geoList) {
                    String labelString = (String)pll.getAttribute("APP_OBJECT");
                    if (labelString == null) continue;
                    double[] ll = pll.getLatLonArray();
                    ((LatLonPoint)llp).setLatLon(ll[0], ll[1], true);
                    p.forward(llp, point);
                    double x = point.getX();
                    double y = point.getY();
                    int buffer = 20;
                    if (!(x > (double)(-buffer)) && !(x < (double)(p.getWidth() + buffer)) || !(y > (double)(-buffer)) && !(y < (double)(p.getHeight() + buffer))) continue;
                    OMText label = new OMText(((Point2D)llp).getY(), ((Point2D)llp).getX(), 4.0f, -4.0f, labelString, 0);
                    label.setLinePaint(this.distanceGridPaint);
                    textList.add(label);
                }
                list.add(textList);
            }
            geoList.setLinePaint(this.distanceGridPaint);
            list.add(geoList);
        }
        if (this.labelList != null) {
            this.labelList.clear();
        } else {
            this.labelList = new OMGraphicList();
        }
        if (this.showLabels && p.getScale() <= this.labelCutoffScale) {
            Debug.message("utmgrid", "Creating labels for map...");
            Object ul = p.getUpperLeft();
            Object lr = p.getLowerRight();
            Collection labels = this.labelTree.get(((Point2D)ul).getY(), ((Point2D)ul).getX(), ((Point2D)lr).getY(), ((Point2D)lr).getX());
            this.labelList.addAll(labels);
            this.labelList.setLinePaint(this.getUTMGridPaint());
            list.add(this.labelList);
        }
        Debug.message("utmgrid", "Generating OMGraphics...");
        list.generate(p);
        Debug.message("utmgrid", "Done.");
        return list;
    }

    @Override
    public Component getGUI() {
        JPanel panel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        panel.setLayout(gridbag);
        JCheckBox setZonesButton = new JCheckBox(this.i18n.get(UTMGridPlugIn.class, "setZonesButton", "Show UTM Zone Grid"), this.showZones);
        setZonesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JCheckBox button = (JCheckBox)ae.getSource();
                UTMGridPlugIn.this.showZones = button.isSelected();
                UTMGridPlugIn.this.doPrepare();
            }
        });
        c.gridy = 0;
        c.anchor = 17;
        gridbag.setConstraints(setZonesButton, c);
        panel.add(setZonesButton);
        JCheckBox set100kGridButton = new JCheckBox(this.i18n.get(UTMGridPlugIn.class, "set100kGridButton", "Show 100Km Distance Grid"), this.show100kGrid);
        set100kGridButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JCheckBox button = (JCheckBox)ae.getSource();
                UTMGridPlugIn.this.show100kGrid = button.isSelected();
                UTMGridPlugIn.this.doPrepare();
            }
        });
        c.gridy = 1;
        gridbag.setConstraints(set100kGridButton, c);
        panel.add(set100kGridButton);
        JCheckBox setLabelsButton = new JCheckBox(this.i18n.get(UTMGridPlugIn.class, "setLabelsButton", "Show Zone Labels"), this.showLabels);
        setLabelsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JCheckBox button = (JCheckBox)ae.getSource();
                UTMGridPlugIn.this.showLabels = button.isSelected();
                UTMGridPlugIn.this.doPrepare();
            }
        });
        c.gridy = 2;
        gridbag.setConstraints(setLabelsButton, c);
        panel.add(setLabelsButton);
        JPanel resPanel = PaletteHelper.createPaletteJPanel(this.i18n.get(UTMGridPlugIn.class, "resPanel", "Distance Grid Units"));
        String[] resStrings = new String[]{this.i18n.get(UTMGridPlugIn.class, "resStrings.noGrid", " No Grid "), this.i18n.get(UTMGridPlugIn.class, "resStrings.10000m", " 10,000 meter   "), this.i18n.get(UTMGridPlugIn.class, "resStrings.1000m", " 1000 meter "), this.i18n.get(UTMGridPlugIn.class, "resStrings.100m", " 100 meter "), this.i18n.get(UTMGridPlugIn.class, "resStrings.10m", " 10 meter "), this.i18n.get(UTMGridPlugIn.class, "resStrings.1m", " 1 meter ")};
        JComboBox<String> resList = new JComboBox<String>(resStrings);
        resList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JComboBox jcb = (JComboBox)e.getSource();
                UTMGridPlugIn.this.setDistanceGridResolution(jcb.getSelectedIndex());
                UTMGridPlugIn.this.doPrepare();
            }
        });
        resList.setSelectedIndex(this.getDistanceGridResolution());
        resPanel.add(resList);
        c.gridy = 3;
        c.anchor = 10;
        gridbag.setConstraints(resPanel, c);
        panel.add(resPanel);
        JButton utmGridColorButton = new JButton(DrawingAttributes.getIconForPaint(this.getUTMGridPaint(), true));
        utmGridColorButton.setContentAreaFilled(false);
        utmGridColorButton.setBorder(null);
        utmGridColorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                Color tmpPaint = UTMGridPlugIn.this.getNewPaint((Component)ae.getSource(), UTMGridPlugIn.this.i18n.get(UTMGridPlugIn.class, "utmGridColorChooser", "Choose UTM Grid Color"), (Color)UTMGridPlugIn.this.getUTMGridPaint());
                if (tmpPaint != null) {
                    UTMGridPlugIn.this.setUTMGridPaint(tmpPaint);
                    ((JButton)ae.getSource()).setIcon(DrawingAttributes.getIconForPaint(tmpPaint, true));
                    UTMGridPlugIn.this.doPrepare();
                }
            }
        });
        JLabel utmGridLabel = new JLabel(this.i18n.get(UTMGridPlugIn.class, "utmGridColorButton", "Set UTM Grid Color"));
        JPanel utmGridPanel = new JPanel();
        utmGridPanel.add(utmGridColorButton);
        utmGridPanel.add(utmGridLabel);
        c.gridy = 4;
        c.anchor = 17;
        gridbag.setConstraints(utmGridPanel, c);
        panel.add(utmGridPanel);
        JButton distGridColorButton = new JButton(DrawingAttributes.getIconForPaint(this.getDistanceGridPaint(), true));
        distGridColorButton.setContentAreaFilled(false);
        distGridColorButton.setBorder(null);
        distGridColorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                Color tmpPaint = UTMGridPlugIn.this.getNewPaint((Component)ae.getSource(), UTMGridPlugIn.this.i18n.get(UTMGridPlugIn.class, "distanceGridColorChooser", "Choose Distance Grid Color"), (Color)UTMGridPlugIn.this.getDistanceGridPaint());
                if (tmpPaint != null) {
                    UTMGridPlugIn.this.setDistanceGridPaint(tmpPaint);
                    ((JButton)ae.getSource()).setIcon(DrawingAttributes.getIconForPaint(tmpPaint, true));
                    UTMGridPlugIn.this.doPrepare();
                }
            }
        });
        JLabel distanceGridLabel = new JLabel(this.i18n.get(UTMGridPlugIn.class, "distGridColorButton", "Set Distance Grid Color"));
        JPanel distGridPanel = new JPanel();
        distGridPanel.add(distGridColorButton);
        distGridPanel.add(distanceGridLabel);
        c.gridy = 5;
        gridbag.setConstraints(distGridPanel, c);
        panel.add(distGridPanel);
        return panel;
    }

    protected Color getNewPaint(Component source, String title, Color startingColor) {
        Color newPaint = null;
        if (this.getLock()) {
            newPaint = OMColorChooser.showDialog(source, title, startingColor);
            this.releaseLock();
        }
        return newPaint;
    }

    protected synchronized boolean getLock() {
        if (!this.colorChooserLock) {
            this.colorChooserLock = true;
            return this.colorChooserLock;
        }
        return false;
    }

    protected synchronized void releaseLock() {
        this.colorChooserLock = false;
    }

    @Override
    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.showLabels = PropUtils.booleanFromProperties(props, prefix + ShowLabelsProperty, this.showLabels);
        this.showZones = PropUtils.booleanFromProperties(props, prefix + ShowZonesProperty, this.showZones);
        this.show100kGrid = PropUtils.booleanFromProperties(props, prefix + Show100kGridProperty, this.show100kGrid);
        this.labelCutoffScale = PropUtils.floatFromProperties(props, prefix + LabelCutoffScaleProperty, this.labelCutoffScale);
        this.utmGridPaint = PropUtils.parseColorFromProperties(props, prefix + UTMGridColorProperty, this.utmGridPaint);
        this.distanceGridPaint = PropUtils.parseColorFromProperties(props, prefix + DistanceGridColorProperty, this.distanceGridPaint);
        this.setDistanceGridResolution(PropUtils.intFromProperties(props, prefix + DistanceGridResolutionProperty, this.distanceGridResolution));
        this.labelsAsMGRS = PropUtils.booleanFromProperties(props, prefix + LabelsAsMGRSProperty, this.labelsAsMGRS);
    }

    @Override
    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        props.put(prefix + ShowLabelsProperty, Boolean.toString(this.showLabels));
        props.put(prefix + ShowZonesProperty, new Boolean(this.showZones).toString());
        props.put(prefix + LabelCutoffScaleProperty, Float.toString(this.labelCutoffScale));
        props.put(prefix + Show100kGridProperty, Boolean.toString(this.show100kGrid));
        props.put(prefix + UTMGridColorProperty, Integer.toHexString(((Color)this.utmGridPaint).getRGB()));
        props.put(prefix + DistanceGridColorProperty, Integer.toHexString(((Color)this.distanceGridPaint).getRGB()));
        props.put(prefix + DistanceGridResolutionProperty, Integer.toString(this.distanceGridResolution));
        props.put(prefix + LabelsAsMGRSProperty, Boolean.toString(this.labelsAsMGRS));
        return props;
    }

    @Override
    public Properties getPropertyInfo(Properties props) {
        props = super.getPropertyInfo(props);
        String interString = this.i18n.get(UTMGridPlugIn.class, ShowZonesProperty, 3, "Show UTM Zone Grid Lines.");
        props.put(ShowZonesProperty, interString);
        interString = this.i18n.get(UTMGridPlugIn.class, ShowZonesProperty, ShowZonesProperty);
        props.put("showZones.label", interString);
        props.put("showZones.editor", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        interString = this.i18n.get(UTMGridPlugIn.class, UTMGridColorProperty, 3, "Color for UTM Zone Grid lines.");
        props.put(UTMGridColorProperty, interString);
        interString = this.i18n.get(UTMGridPlugIn.class, UTMGridColorProperty, UTMGridColorProperty);
        props.put("utmGridColor.label", interString);
        props.put("utmGridColor.editor", "com.bbn.openmap.util.propertyEditor.ColorPropertyEditor");
        interString = this.i18n.get(UTMGridPlugIn.class, ShowLabelsProperty, 3, "Show Labels for Grid Lines");
        props.put(ShowLabelsProperty, interString);
        interString = this.i18n.get(UTMGridPlugIn.class, ShowLabelsProperty, ShowLabelsProperty);
        props.put("showLabels.label", interString);
        props.put("showLabels.editor", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        interString = this.i18n.get(UTMGridPlugIn.class, Show100kGridProperty, 3, "Show 100Km Distance Grid Lines");
        props.put(Show100kGridProperty, interString);
        interString = this.i18n.get(UTMGridPlugIn.class, Show100kGridProperty, Show100kGridProperty);
        props.put("show100KmGrid.label", interString);
        props.put("show100KmGrid.editor", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        interString = this.i18n.get(UTMGridPlugIn.class, DistanceGridColorProperty, 3, "Color for Equal-Distance Grid Lines.");
        props.put(DistanceGridColorProperty, interString);
        interString = this.i18n.get(UTMGridPlugIn.class, DistanceGridColorProperty, DistanceGridColorProperty);
        props.put("distanceGridColor.label", interString);
        props.put("distanceGridColor.editor", "com.bbn.openmap.util.propertyEditor.ColorPropertyEditor");
        interString = this.i18n.get(UTMGridPlugIn.class, DistanceGridResolutionProperty, 3, "Meter Resolution for Distance Grid Lines (0-5)");
        props.put(DistanceGridResolutionProperty, interString);
        interString = this.i18n.get(UTMGridPlugIn.class, DistanceGridResolutionProperty, DistanceGridResolutionProperty);
        props.put("distanceGridResolution.label", interString);
        PropUtils.setI18NPropertyInfo(this.i18n, props, UTMGridPlugIn.class, LabelsAsMGRSProperty, "Labels as MGRS", "Flag to display labels in MGRS notation, or UTM.", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        props.put("initProperties", "showZones utmGridColor show100KmGrid showLabels distanceGridResolution distanceGridColor mgrsLabels");
        return props;
    }

    public void setShowZones(boolean value) {
        this.showZones = value;
    }

    public boolean isShowZones() {
        return this.showZones;
    }

    public void setShowLabels(boolean value) {
        this.showLabels = value;
    }

    public boolean isShowLabels() {
        return this.showLabels;
    }

    public void setLabelCutoffScale(float value) {
        this.labelCutoffScale = value;
    }

    public float getLabelCutoffScale() {
        return this.labelCutoffScale;
    }

    public void setShow100kGrid(boolean value) {
        this.show100kGrid = value;
    }

    public boolean isShow100kGrid() {
        return this.show100kGrid;
    }

    public void setDistanceGridResolution(int value) {
        this.distanceGridResolution = value;
        if (this.distanceGridResolution < 0 || this.distanceGridResolution > 5) {
            this.distanceGridResolution = 0;
        }
    }

    public int getDistanceGridResolution() {
        return this.distanceGridResolution;
    }

    public void setUTMGridPaint(Paint value) {
        this.utmGridPaint = value;
        if (this.verticalList != null) {
            this.verticalList.setLinePaint(this.getUTMGridPaint());
            this.horizontalList.setLinePaint(this.getUTMGridPaint());
        }
    }

    public Paint getUTMGridPaint() {
        return this.utmGridPaint;
    }

    public void setDistanceGridPaint(Paint value) {
        this.distanceGridPaint = value;
    }

    public Paint getDistanceGridPaint() {
        return this.distanceGridPaint;
    }
}

