/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj;

import com.bbn.openmap.proj.GeoProj;
import com.bbn.openmap.proj.coords.DatumShiftGCT;
import com.bbn.openmap.proj.coords.LatLonPoint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Point2D;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatumShiftProjection
extends GeoProj {
    private GeoProj wrappedProjection;
    private DatumShiftGCT datum;

    public DatumShiftProjection(GeoProj proj, DatumShiftGCT datum) {
        super(proj.getCenter(), proj.getScale(), proj.getWidth(), proj.getHeight());
        this.datum = datum;
        this.wrappedProjection = proj;
        this.setCenter(proj.getCenter());
    }

    @Override
    public void setCenter(double lat, double lon) {
        super.setCenter(lat, lon);
        Point2D centerInDifferentDatum = this.datum.forward(lat, lon, new Point2D.Double());
        this.wrappedProjection.setCenter((float)centerInDifferentDatum.getY(), (float)centerInDifferentDatum.getX());
    }

    @Override
    public ArrayList<float[]> _forwardPoly(float[] rawllpts, int ltype, int nsegs, boolean isFilled) {
        float[] rawllptsInDifferentDatum = new float[rawllpts.length];
        Point2D tmpll = new Point2D.Double();
        for (int i = 0; i < rawllpts.length; i += 2) {
            tmpll = this.datum.forward(Math.toDegrees(rawllpts[i]), Math.toDegrees(rawllpts[i + 1]), tmpll);
            rawllptsInDifferentDatum[i] = (float)Math.toRadians(tmpll.getY());
            rawllptsInDifferentDatum[i + 1] = (float)Math.toRadians(tmpll.getX());
        }
        return this.wrappedProjection._forwardPoly(rawllptsInDifferentDatum, ltype, nsegs, isFilled);
    }

    @Override
    protected ArrayList<float[]> _forwardPoly(double[] rawllpts, int ltype, int nsegs, boolean isFilled) {
        double[] rawllptsInDifferentDatum = new double[rawllpts.length];
        Point2D tmpll = new Point2D.Double();
        for (int i = 0; i < rawllpts.length; i += 2) {
            tmpll = this.datum.forward(Math.toDegrees(rawllpts[i]), Math.toDegrees(rawllpts[i + 1]), tmpll);
            rawllptsInDifferentDatum[i] = Math.toRadians(tmpll.getY());
            rawllptsInDifferentDatum[i + 1] = Math.toRadians(tmpll.getX());
        }
        return this.wrappedProjection._forwardPoly(rawllptsInDifferentDatum, ltype, nsegs, isFilled);
    }

    @Override
    protected void computeParameters() {
        if (this.wrappedProjection != null) {
            this.wrappedProjection.width = this.width;
            this.wrappedProjection.height = this.height;
            this.wrappedProjection.scale = this.scale;
            this.wrappedProjection.computeParameters();
        }
    }

    @Override
    public void drawBackground(Graphics2D g, Paint p) {
        this.wrappedProjection.drawBackground(g, p);
    }

    @Override
    public void drawBackground(Graphics g) {
        this.wrappedProjection.drawBackground(g);
    }

    @Override
    public double normalizeLatitude(double lat) {
        if (lat > 1.5707963705062866) {
            return 1.5707963705062866;
        }
        if (lat < -1.5707963705062866) {
            return -1.5707963705062866;
        }
        return lat;
    }

    @Override
    public Point2D forward(double lat, double lon, Point2D pt, boolean isRadian) {
        Point2D t = isRadian ? this.datum.forward(Math.toDegrees(lat), Math.toDegrees(lon)) : this.datum.forward(lat, lon);
        return this.wrappedProjection.forward((float)t.getY(), (float)t.getX(), pt);
    }

    @Override
    public boolean forwardRaw(float[] rawllpts, int rawoff, float[] xcoords, float[] ycoords, boolean[] visible, int copyoff, int copylen) {
        float[] rawllptsInDifferentDatum = new float[rawllpts.length];
        Point2D tmpll = new Point2D.Double();
        int end = copylen + copyoff;
        int i = copyoff;
        int j = rawoff;
        while (i < end) {
            tmpll = this.datum.forward(Math.toDegrees(rawllpts[j]), Math.toDegrees(rawllpts[j + 1]), tmpll);
            rawllptsInDifferentDatum[j] = (float)Math.toRadians(tmpll.getY());
            rawllptsInDifferentDatum[j + 1] = (float)Math.toRadians(tmpll.getX());
            ++i;
            j += 2;
        }
        return this.wrappedProjection.forwardRaw(rawllptsInDifferentDatum, rawoff, xcoords, ycoords, visible, copyoff, copylen);
    }

    @Override
    public LatLonPoint getLowerRight() {
        Point2D llp = this.wrappedProjection.getLowerRight();
        return this.datum.inverse(llp.getX(), llp.getY());
    }

    @Override
    public LatLonPoint getUpperLeft() {
        Point2D llp = this.wrappedProjection.getUpperLeft();
        return this.datum.inverse(llp.getX(), llp.getY());
    }

    public LatLonPoint inverse(double x, double y, Point2D pt) {
        LatLonPoint llpt = this.assertLatLonPoint(pt);
        llpt = this.wrappedProjection.inverse(x, y, llpt);
        return this.datum.inverse(llpt.getX(), llpt.getY(), llpt);
    }

    @Override
    public boolean isPlotable(double lat, double lon) {
        Point2D t = this.datum.forward(lat, lon);
        return this.wrappedProjection.isPlotable(t.getY(), t.getX());
    }

    @Override
    public float getScale(Point2D ll1, Point2D ll2, Point2D point1, Point2D point2) {
        return this.wrappedProjection.getScale(ll1, ll2, point1, point2);
    }
}

