/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.time;

import com.bbn.openmap.time.TimerStatus;
import java.io.Serializable;

public class TimeEvent
implements Serializable {
    protected Object source;
    protected long systemTime;
    protected long offsetTime;
    protected long simTime;
    protected TimerStatus timerStatus;
    public static final TimeEvent NO_TIME = new TimeEvent(null, Long.MIN_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, TimerStatus.INACTIVE);

    public TimeEvent(Object src, long systemTime, long offsetTime, long simTime, TimerStatus timerStatus) {
        this.source = src;
        this.systemTime = systemTime;
        this.offsetTime = offsetTime;
        this.simTime = simTime;
        this.timerStatus = timerStatus;
    }

    public static TimeEvent create(Object src, long time, long systemTime, long simTime, TimerStatus timerStatus) {
        if (time == Long.MIN_VALUE || time == Long.MAX_VALUE) {
            return NO_TIME;
        }
        return new TimeEvent(src, time, time - systemTime, simTime + time - systemTime, timerStatus);
    }

    public Object getSource() {
        return this.source;
    }

    public long getSystemTime() {
        return this.systemTime;
    }

    public long getOffsetTime() {
        return this.offsetTime;
    }

    public long getSimTime() {
        return this.simTime;
    }

    public TimerStatus getTimerStatus() {
        return this.timerStatus;
    }

    public String toString() {
        return "TimeEvent: " + this.timerStatus + " [" + this.offsetTime + ", " + this.systemTime + ", " + this.simTime + "]";
    }
}

