/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.tools.beanbox;

import com.bbn.openmap.tools.beanbox.DoOnBean;
import com.bbn.openmap.tools.beanbox.JarInfo;
import com.bbn.openmap.tools.beanbox.Manifest;
import com.bbn.openmap.tools.beanbox.MessageHeader;
import java.beans.BeanInfo;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class JarLoader {
    private InputStream jarStream;
    private String jarName;
    private static boolean warnedAboutNoBeans;

    public JarLoader(String jarName) throws FileNotFoundException {
        this.jarName = jarName;
        FileInputStream is = new FileInputStream(jarName);
        this.jarStream = new BufferedInputStream(is);
    }

    public JarInfo loadJar() throws IOException {
        ZipInputStream zis = null;
        Manifest mf = null;
        boolean empty = true;
        try {
            zis = new ZipInputStream(this.jarStream);
            ZipEntry ent = null;
            while ((ent = zis.getNextEntry()) != null) {
                int len;
                empty = false;
                String name = ent.getName();
                if (!Manifest.isManifestName(name)) continue;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                while ((len = zis.read(buffer)) >= 0) {
                    baos.write(buffer, 0, len);
                }
                byte[] buf = baos.toByteArray();
                mf = new Manifest(buf);
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Throwable th) {
            th.printStackTrace();
            throw new IOException("loadJar caught: " + th);
        }
        finally {
            if (zis != null) {
                try {
                    zis.close();
                }
                catch (Exception exception) {}
            }
        }
        if (empty) {
            throw new IOException("JAR file is corrupt or empty");
        }
        JarInfo ji = this.createJarInfo(mf);
        return ji;
    }

    public static void loadJarDoOnBean(String jarFile, DoOnBean action) throws IOException {
        JarLoader jl = new JarLoader(jarFile);
        JarInfo ji = jl.loadJar();
        if (ji == null) {
            System.err.println("JAR file " + jarFile + " did not load properly!");
            System.err.println("Check for error messages possibly regarding");
            System.err.println("problems defining classes");
            return;
        }
        if (ji.getCount() == 0) {
            System.err.println("Jar file " + jarFile + " didn't have any beans!");
            if (!warnedAboutNoBeans) {
                warnedAboutNoBeans = true;
                System.err.println();
                System.err.println("Each jar file needs to contain a manifest file describing which entries are");
                System.err.println("beans.  You can should provide a suitable manifest when you create the jar.");
                System.err.println();
            }
        }
        for (int i = 0; i < ji.getCount(); ++i) {
            String beanName = ji.getName(i);
            BeanInfo bi = ji.getBeanInfo(i);
            Class bc = ji.getBeanClass(i);
            if (bi == null || bc == null) continue;
            action.action(ji, bi, bc, beanName);
        }
    }

    private JarInfo createJarInfo(Manifest mf) {
        Hashtable<String, Boolean> beans;
        Hashtable<String, MessageHeader> headersTable = new Hashtable<String, MessageHeader>();
        if (mf == null) {
            beans = new Hashtable<String, Boolean>();
        } else {
            beans = new Hashtable();
            Enumeration entries = mf.entries();
            while (entries.hasMoreElements()) {
                String beanName;
                MessageHeader mh = (MessageHeader)entries.nextElement();
                String name = mh.findValue("Name");
                String isBean = mh.findValue("Java-Bean");
                if (isBean == null || !isBean.equalsIgnoreCase("True")) continue;
                boolean fromPrototype = true;
                if (name.endsWith(".class")) {
                    fromPrototype = false;
                    beanName = name.substring(0, name.length() - 6);
                } else {
                    beanName = name.endsWith(".ser") ? name.substring(0, name.length() - 4) : name;
                }
                beanName = beanName.replace('/', '.');
                beans.put(beanName, new Boolean(fromPrototype));
                headersTable.put(beanName, mh);
            }
        }
        String[] beanNames = new String[beans.size()];
        boolean[] fromPrototype = new boolean[beans.size()];
        MessageHeader[] headers = new MessageHeader[beans.size()];
        Enumeration keys = beans.keys();
        int i = 0;
        while (keys.hasMoreElements()) {
            String key;
            beanNames[i] = key = (String)keys.nextElement();
            fromPrototype[i] = (Boolean)beans.get(key);
            headers[i] = (MessageHeader)headersTable.get(key);
            ++i;
        }
        return new JarInfo(this.jarName, beanNames, fromPrototype, headers);
    }
}

