/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.tools.icon;

import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.tools.icon.BasicIconPart;
import com.bbn.openmap.tools.icon.IconPart;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IconPartList
implements IconPart,
Iterable<IconPart>,
Cloneable {
    protected List<IconPart> parts;
    protected DrawingAttributes renderingAttributes = null;
    protected Shape clip = null;

    protected List<IconPart> getList() {
        if (this.parts == null) {
            this.parts = new LinkedList<IconPart>();
        }
        return this.parts;
    }

    @Override
    public Iterator<IconPart> iterator() {
        return this.parts.iterator();
    }

    public void add(IconPart part) {
        this.getList().add(part);
    }

    public boolean remove(IconPart part) {
        return this.getList().remove(part);
    }

    public void clear() {
        this.getList().clear();
    }

    @Override
    public void render(Graphics g, int width, int height) {
        this.render(g, width, height, null);
    }

    @Override
    public void render(Graphics g, int width, int height, DrawingAttributes appDA) {
        Shape clip = this.getClip();
        if (clip != null) {
            g.setClip(clip);
        }
        DrawingAttributes da = this.getRenderingAttributes();
        DrawingAttributes tmpDA = null;
        for (IconPart part : this) {
            if (da != null) {
                tmpDA = part.getRenderingAttributes();
                part.setRenderingAttributes(da);
            }
            Graphics2D g2 = (Graphics2D)g.create();
            part.render(g2, width, height);
            g2.dispose();
            if (da == null) continue;
            part.setRenderingAttributes(tmpDA);
            tmpDA = null;
        }
    }

    @Override
    public void setClip(Shape clipArea) {
        this.clip = clipArea;
    }

    @Override
    public Shape getClip() {
        return this.clip;
    }

    @Override
    public void setGeometry(Shape shape) {
        List<IconPart> list = this.getList();
        list.clear();
        list.add(new BasicIconPart(shape));
    }

    @Override
    public Shape getGeometry() {
        Path2D geometry = null;
        for (IconPart part : this) {
            Shape shp = part.getGeometry();
            if (shp == null) continue;
            if (geometry == null) {
                geometry = new GeneralPath(shp);
                continue;
            }
            geometry.append(shp, false);
        }
        return geometry;
    }

    @Override
    public void setRenderingAttributes(DrawingAttributes da) {
        this.renderingAttributes = da;
    }

    @Override
    public DrawingAttributes getRenderingAttributes() {
        return this.renderingAttributes;
    }

    @Override
    public Object clone() {
        IconPartList clone = new IconPartList();
        for (IconPart part : this) {
            clone.add((IconPart)part.clone());
        }
        clone.setRenderingAttributes(this.getRenderingAttributes());
        clone.setClip(this.getClip());
        return clone;
    }
}

