/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.specialist;

import com.bbn.openmap.corba.CSpecialist.BitmapPackage.BF_update;
import com.bbn.openmap.corba.CSpecialist.BitmapPackage.EBitmap;
import com.bbn.openmap.corba.CSpecialist.EComp;
import com.bbn.openmap.corba.CSpecialist.GraphicPackage.GF_update;
import com.bbn.openmap.corba.CSpecialist.LLPoint;
import com.bbn.openmap.corba.CSpecialist.XYPoint;
import com.bbn.openmap.layer.specialist.JGraphic;
import com.bbn.openmap.layer.specialist.JObjectHolder;
import com.bbn.openmap.omGraphics.OMBitmap;
import com.bbn.openmap.omGraphics.OMGraphic;
import java.io.Serializable;

public class JBitmap
extends OMBitmap
implements Serializable,
JObjectHolder {
    public String bmref;
    protected transient EComp object = null;
    protected int x_hot;
    protected int y_hot;

    public JBitmap(EBitmap ebit) {
        JGraphic.fillOMGraphicParams((OMGraphic)this, ebit.egraphic);
        this.x = ebit.p1.x;
        this.y = ebit.p1.y;
        this.lat = ebit.ll1.lat;
        this.lon = ebit.ll1.lon;
        this.height = ebit.height;
        this.width = ebit.width;
        this.bits = ebit.bits;
        this.x_hot = ebit.x_hot;
        this.y_hot = ebit.y_hot;
        this.bmref = ebit.bmref;
    }

    public void setObject(EComp aObject) {
        this.object = aObject;
    }

    public EComp getObject() {
        return this.object;
    }

    public void update(GF_update update) {
        JGraphic.update(this, update);
    }

    public void update(BF_update update) {
        switch (update.discriminator().value()) {
            case 1: {
                LLPoint ll = update.ll1();
                this.setLat(ll.lat);
                this.setLon(ll.lon);
                break;
            }
            case 0: {
                XYPoint pt = update.p1();
                this.setX(pt.x);
                this.setY(pt.y);
                break;
            }
            case 2: {
                this.setWidth(update.width());
                break;
            }
            case 3: {
                this.setHeight(update.height());
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                this.setBits(update.bits());
                break;
            }
            case 7: {
                System.err.println("CSBitmap.update: bmref update not supported/necessary.");
                break;
            }
            default: {
                System.err.println("CSBitmap.update: invalid bitmap update");
            }
        }
    }
}

