/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractRefreshableApplicationContext;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.util.SystemPropertyUtils;

public abstract class AbstractRefreshableConfigApplicationContext
extends AbstractRefreshableApplicationContext
implements BeanNameAware,
InitializingBean {
    private String[] configLocations;
    private boolean setIdCalled = false;

    public AbstractRefreshableConfigApplicationContext() {
    }

    public AbstractRefreshableConfigApplicationContext(ApplicationContext parent) {
        super(parent);
    }

    public void setConfigLocation(String location) {
        this.configLocations = StringUtils.tokenizeToStringArray((String)location, (String)",; \t\n");
    }

    public void setConfigLocations(String[] locations) {
        Assert.noNullElements((Object[])locations, (String)"Config locations must not be null");
        this.configLocations = new String[locations.length];
        for (int i = 0; i < locations.length; ++i) {
            this.configLocations[i] = this.resolvePath(locations[i]);
        }
    }

    protected String[] getConfigLocations() {
        return this.configLocations != null ? this.configLocations : this.getDefaultConfigLocations();
    }

    protected String[] getDefaultConfigLocations() {
        return null;
    }

    protected String resolvePath(String path) {
        return SystemPropertyUtils.resolvePlaceholders((String)path);
    }

    public void setId(String id) {
        super.setId(id);
        this.setIdCalled = true;
    }

    public void setBeanName(String name) {
        if (!this.setIdCalled) {
            super.setId(name);
        }
    }

    public void afterPropertiesSet() {
        if (!this.isActive()) {
            this.refresh();
        }
    }
}

