/*
 * Decompiled with CFR 0.152.
 */
package unity.functions;

import java.sql.SQLException;
import unity.engine.Relation;
import unity.engine.Tuple;
import unity.functions.Expression;
import unity.functions.Function;

public class F_Functionudf
extends Function {
    private static final long serialVersionUID = 1L;
    private Expression expr;

    public F_Functionudf(Expression expression) {
        this.expr = expression;
        this.returnType = this.expr.getReturnType();
    }

    @Override
    public Object evaluate(Tuple tuple) throws SQLException {
        Object object = this.expr.evaluate(tuple);
        if (object != null) {
            if (object instanceof Double) {
                return new Double((Double)object * 2.0);
            }
            if (object instanceof Float) {
                return new Float(((Float)object).floatValue() * 2.0f);
            }
            if (object instanceof Integer) {
                return new Integer((Integer)object * 2);
            }
            if (object instanceof Number) {
                return new Double(((Number)object).doubleValue() * 2.0);
            }
        }
        return null;
    }

    @Override
    public int getReturnType() {
        return this.returnType;
    }

    public static int[] getParamListTypes() {
        return new int[]{99999};
    }

    public static String getFunctionName() {
        return "UDF_TEST";
    }

    @Override
    public String toString(Relation relation) {
        return "UDF_TEST(" + this.expr.toString(relation) + ")";
    }
}

