/*
 * Decompiled with CFR 0.152.
 */
package unity.functions;

import java.sql.SQLException;
import unity.engine.Relation;
import unity.engine.Tuple;
import unity.functions.Expression;
import unity.functions.Function;

public class F_Log
extends Function {
    private static final long serialVersionUID = 1L;
    private Expression expr;

    public F_Log(Expression expression) {
        this.expr = expression;
        this.returnType = this.expr.getReturnType();
    }

    @Override
    public Object evaluate(Tuple tuple) throws SQLException {
        Object object = this.expr.evaluate(tuple);
        if (object == null) {
            return null;
        }
        if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            return new Double(Math.log(d) / Math.log(10.0));
        }
        return null;
    }

    @Override
    public int getReturnType() {
        return 8;
    }

    public static int[] getParamListTypes() {
        return new int[]{99999};
    }

    public static String getFunctionName() {
        return "LOG";
    }

    @Override
    public String toString(Relation relation) {
        return "LOG(" + this.expr.toString(relation) + ")";
    }
}

