/*
 * Decompiled with CFR 0.152.
 */
package unity.operators;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import unity.engine.Tuple;
import unity.io.FileManager;
import unity.operators.ResultSetScan;
import unity.query.LQNode;
import unity.query.LocalQuery;

public class BufferedResultSetScan
extends ResultSetScan {
    private static final long serialVersionUID = 1L;
    private boolean firstPass = true;
    private BufferedInputStream input;
    private BufferedOutputStream output;
    private String fileName;

    public BufferedResultSetScan(LocalQuery localQuery, LQNode lQNode) {
        super(localQuery, lQNode);
    }

    @Override
    public void init() throws SQLException {
        try {
            if (this.firstPass) {
                super.init();
                this.fileName = FileManager.createTempFileName("resultset");
                this.output = FileManager.openOutputFile(this.fileName);
            } else {
                if (this.input != null) {
                    FileManager.closeFile(this.input);
                }
                this.input = FileManager.openInputFile(this.fileName);
            }
        }
        catch (IOException iOException) {
            throw new SQLException(iOException);
        }
    }

    @Override
    public boolean next(Tuple tuple) throws SQLException {
        if (this.firstPass) {
            boolean bl = super.next(tuple);
            if (!bl) {
                this.firstPass = false;
                this.closeBufferFile();
            } else {
                tuple.write(this.output);
            }
            return bl;
        }
        boolean bl = tuple.read(this.input);
        tuple.setRelation(this.outputRelation);
        return bl;
    }

    @Override
    public void close() throws SQLException {
        super.close();
        this.closeBufferFile();
        FileManager.deleteFile(this.fileName);
    }

    private void closeBufferFile() throws SQLException {
        if (this.output != null) {
            try {
                FileManager.closeFile(this.output);
            }
            catch (IOException iOException) {
                throw new SQLException(iOException);
            }
            this.output = null;
        }
    }

    @Override
    public String getName() {
        return "BUFFERED RESULTSET SCAN";
    }
}

