/*
 * Decompiled with CFR 0.152.
 */
package unity.query;

import java.sql.SQLException;
import unity.operators.Operator;
import unity.query.GQTableRef;
import unity.query.GlobalQuery;
import unity.query.LQCondNode;
import unity.query.LQNode;
import unity.query.SubQuery;

public class LQDeleteNode
extends LQNode
implements Cloneable {
    private static final long serialVersionUID = 1L;
    private LQCondNode conditionRoot;
    private GQTableRef tableRef;
    private GlobalQuery nestedQuery;

    public LQDeleteNode() {
        this.type = 20;
        this.conditionRoot = null;
        this.nestedQuery = null;
    }

    public void setNestedQuery(GlobalQuery globalQuery) {
        this.nestedQuery = globalQuery;
    }

    public LQCondNode getCondition() {
        return this.conditionRoot;
    }

    public void setCondition(LQCondNode lQCondNode) {
        this.conditionRoot = lQCondNode;
    }

    @Override
    public String generateSQL() {
        String string = "";
        if (this.tableRef != null) {
            string = this.tableRef.getTable().getSQLTableNameWithSchema();
            if (this.tableRef.getAliasName() != null) {
                string = string + " " + this.tableRef.getAliasName();
            }
        }
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("DELETE FROM " + string);
        if (this.conditionRoot != null && this.nestedQuery == null) {
            stringBuffer.append(" WHERE " + this.conditionRoot.generateSQL());
        }
        return stringBuffer.toString();
    }

    public String generateSubQuerySQL() {
        if (this.nestedQuery != null) {
            LQCondNode lQCondNode = this.getCondition();
            String string = lQCondNode.getChild(0).generateSQL() + " " + lQCondNode.getContent() + " (";
            return string;
        }
        return "";
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(this.generateSQL());
        stringBuffer.append('\n');
        if (this.conditionRoot != null) {
            stringBuffer.append(" WHERE " + this.conditionRoot.generateSQL());
        }
        return stringBuffer.toString();
    }

    @Override
    public Operator buildOperator(Operator[] operatorArray, GlobalQuery globalQuery, SubQuery subQuery) throws SQLException {
        return null;
    }

    public void setSourceTable(GQTableRef gQTableRef) {
        this.tableRef = gQTableRef;
    }

    public GQTableRef getSourceTable() {
        return this.tableRef;
    }

    @Override
    public void computeCost() {
        this.cost = 0.0;
    }
}

