/*
 * Decompiled with CFR 0.152.
 */
package unity.query;

import java.util.BitSet;
import unity.engine.Relation;
import unity.operators.NestedLoopJoin;
import unity.operators.Operator;
import unity.predicates.JoinPredicate;
import unity.query.GlobalQuery;
import unity.query.LQNode;
import unity.query.SubQuery;

public class LQProductNode
extends LQNode {
    private static final long serialVersionUID = 1L;
    private boolean isReplaced;
    private BitSet leftTables;
    private BitSet rightTables;

    public LQProductNode() {
        this.type = 201;
        this.isReplaced = false;
    }

    @Override
    public String generateSQL() {
        return null;
    }

    @Override
    public String toString() {
        return "CROSS-PRODUCT: ";
    }

    @Override
    public Operator buildOperator(Operator[] operatorArray, GlobalQuery globalQuery, SubQuery subQuery) {
        this.outputRelation = new Relation(((LQNode)this.children.get(0)).getOutputRelation());
        this.outputRelation.mergeRelation(((LQNode)this.children.get(1)).getOutputRelation());
        int n = 50001;
        return new NestedLoopJoin(operatorArray, new JoinPredicate(), n, this);
    }

    @Override
    public int numTuples() {
        return ((LQNode)this.children.get(0)).numTuples() * ((LQNode)this.children.get(1)).numTuples();
    }

    @Override
    public int tupleSize() {
        return ((LQNode)this.children.get(0)).tupleSize() + ((LQNode)this.children.get(1)).tupleSize();
    }

    public void setLeftTables(BitSet bitSet) {
        this.leftTables = bitSet;
    }

    public void setRightTables(BitSet bitSet) {
        this.rightTables = bitSet;
    }

    public BitSet getLeftTables() {
        return this.leftTables;
    }

    public BitSet getRightTables() {
        return this.rightTables;
    }

    public boolean isReplaced() {
        return this.isReplaced;
    }

    public void replace() {
        this.isReplaced = true;
    }

    @Override
    public void computeCost() {
        long l = this.getChild(0).getRows();
        long l2 = this.getChild(1).getRows();
        int n = this.getChild(0).tupleSize();
        int n2 = this.getChild(1).tupleSize();
        this.cost = (double)(3L * (l + l2)) * (1.0 + 0.005 * (double)(n + n2));
        this.rows = l * l2;
    }
}

