/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.desktopcontainer.docktabdesktop;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.Icon;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.TabWidget;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.docktabdesktop.DockTabDesktopPane;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.docktabdesktop.SmallTabButton;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.docktabdesktop.TabHandleEvent;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.docktabdesktop.TabHandleListener;

public class TabHandle {
    private TabWidget _tabWidget;
    private DockTabDesktopPane _dockTabDesktopPane;
    private boolean _isSelected;
    private ArrayList<TabHandleListener> _tabHandleListeners = new ArrayList();
    private boolean _fireClosingProceedingOrDone;

    public TabHandle(TabWidget tabWidget, DockTabDesktopPane dockTabDesktopPane) {
        this._tabWidget = tabWidget;
        this._dockTabDesktopPane = dockTabDesktopPane;
    }

    public TabWidget getWidget() {
        return this._tabWidget;
    }

    public void addTabHandleListener(TabHandleListener l) {
        this._tabHandleListeners.add(l);
    }

    public void removeTabHandleListener(TabHandleListener l) {
        this._tabHandleListeners.remove(l);
    }

    public boolean fireClosing(ActionEvent e) {
        TabHandleListener[] clone;
        this._fireClosingProceedingOrDone = true;
        for (TabHandleListener listener : clone = this._tabHandleListeners.toArray(new TabHandleListener[this._tabHandleListeners.size()])) {
            if (listener.tabClosing(new TabHandleEvent(this, e))) continue;
            this._fireClosingProceedingOrDone = false;
            return false;
        }
        return true;
    }

    public void fireClosed(ActionEvent e) {
        TabHandleListener[] clone;
        for (TabHandleListener listener : clone = this._tabHandleListeners.toArray(new TabHandleListener[this._tabHandleListeners.size()])) {
            listener.tabClosed(new TabHandleEvent(this, e));
        }
    }

    public void fireAdded(boolean wasAddedToToMainApplicationWindow, boolean widgetMovedButNotCreated) {
        TabHandleListener[] clone;
        for (TabHandleListener listener : clone = this._tabHandleListeners.toArray(new TabHandleListener[this._tabHandleListeners.size()])) {
            listener.tabAdded(new TabHandleEvent(this, null, wasAddedToToMainApplicationWindow, widgetMovedButNotCreated));
        }
    }

    public void fireDeselected(ActionEvent e) {
        TabHandleListener[] clone;
        for (TabHandleListener listener : clone = this._tabHandleListeners.toArray(new TabHandleListener[this._tabHandleListeners.size()])) {
            listener.tabDeselected(new TabHandleEvent(this, null));
        }
    }

    public void fireSelected(ActionEvent e) {
        TabHandleListener[] clone;
        for (TabHandleListener listener : clone = this._tabHandleListeners.toArray(new TabHandleListener[this._tabHandleListeners.size()])) {
            listener.tabSelected(new TabHandleEvent(this, null));
        }
    }

    public boolean isSelected() {
        return this._isSelected;
    }

    public void setSelected(boolean b) {
        this._setSelected(b, false);
    }

    public void _setSelected(boolean b, boolean force) {
        TabHandleListener[] clone;
        if (this._isSelected == b && !force) {
            return;
        }
        this._isSelected = b;
        for (TabHandleListener listener : clone = this._tabHandleListeners.toArray(new TabHandleListener[this._tabHandleListeners.size()])) {
            if (this._isSelected) {
                listener.tabSelected(new TabHandleEvent(this, null));
                continue;
            }
            listener.tabDeselected(new TabHandleEvent(this, null));
        }
    }

    public void setTitle(String title) {
        this._dockTabDesktopPane.setTabTitle(this, title);
    }

    public void addSmallTabButton(SmallTabButton smallTabButton) {
        this._dockTabDesktopPane.addSmallTabButton(this, smallTabButton);
    }

    public void removeSmallTabButton(SmallTabButton smallTabButton) {
        this._dockTabDesktopPane.removeSmallTabButton(this, smallTabButton);
    }

    public String getTitle() {
        return this._dockTabDesktopPane.getTabTitle(this);
    }

    public void setIcon(Icon frameIcon) {
        this._dockTabDesktopPane.setTabIcon(this, frameIcon);
    }

    public boolean removeTab(DockTabDesktopPane.TabClosingMode tabClosingMode) {
        return this._dockTabDesktopPane.removeTab(this, null, tabClosingMode);
    }

    public void select() {
        this._dockTabDesktopPane.selectTab(this);
    }

    public boolean isFireClosingProceedingOrDone() {
        return this._fireClosingProceedingOrDone;
    }

    public TabHandle getPreviousTabHandle() {
        return this._dockTabDesktopPane.getPreviousTabHandle(this);
    }

    public TabHandle getNextTabHandle() {
        return this._dockTabDesktopPane.getNextTabHandle(this);
    }
}

