/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.dialects;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.sourceforge.squirrel_sql.fw.dialects.CommonHibernateDialect;
import net.sourceforge.squirrel_sql.fw.dialects.CreateScriptPreferences;
import net.sourceforge.squirrel_sql.fw.dialects.DatabaseObjectQualifier;
import net.sourceforge.squirrel_sql.fw.dialects.DialectType;
import net.sourceforge.squirrel_sql.fw.dialects.DialectUtils;
import net.sourceforge.squirrel_sql.fw.dialects.HibernateDialect;
import net.sourceforge.squirrel_sql.fw.dialects.SqlGenerationPreferences;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;
import org.antlr.stringtemplate.StringTemplate;
import org.hibernate.HibernateException;
import org.hibernate.dialect.FirebirdDialect;

public class FirebirdDialectExt
extends CommonHibernateDialect
implements HibernateDialect {
    private FirebirdDialectHelper _dialect = new FirebirdDialectHelper();

    @Override
    public String getTypeName(int code, int length, int precision, int scale) throws HibernateException {
        return this._dialect.getTypeName(code, length, precision, scale);
    }

    @Override
    public boolean supportsSchemasInTableDefinition() {
        return false;
    }

    @Override
    public String getLengthFunction(int dataType) {
        return "strlen";
    }

    @Override
    public int getMaxPrecision(int dataType) {
        return 18;
    }

    @Override
    public int getPrecisionDigits(int columnSize, int dataType) {
        return columnSize * 2;
    }

    @Override
    public int getColumnLength(int columnSize, int dataType) {
        if (dataType == -5 || dataType == 3 || dataType == 8 || dataType == 6 || dataType == 2 || dataType == 7) {
            return this.getMaxPrecision(dataType);
        }
        if (dataType == 2004 || dataType == -4 || dataType == -1) {
            return Integer.MAX_VALUE;
        }
        return columnSize;
    }

    @Override
    public String getDisplayName() {
        return "Firebird";
    }

    @Override
    public boolean supportsProduct(String databaseProductName, String databaseProductVersion) {
        if (databaseProductName == null) {
            return false;
        }
        return databaseProductName.trim().startsWith("Firebird");
    }

    @Override
    public String getColumnDropSQL(String tableName, String columnName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getColumnDropSQL(tableName, columnName, qualifier, prefs, this);
    }

    @Override
    public List<String> getTableDropSQL(ITableInfo iTableInfo, boolean cascadeConstraints, boolean isMaterializedView, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getTableDropSQL(iTableInfo, false, cascadeConstraints, false, "CASCADE", false, qualifier, prefs, this);
    }

    @Override
    public String[] getAddPrimaryKeySQL(String pkName, TableColumnInfo[] columns, ITableInfo ti, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringBuilder result = new StringBuilder();
        result.append("ALTER TABLE ");
        result.append(DialectUtils.shapeQualifiableIdentifier(ti.getSimpleName(), qualifier, prefs, this));
        result.append(" ADD CONSTRAINT ");
        result.append(pkName);
        result.append(" PRIMARY KEY (");
        for (int i = 0; i < columns.length; ++i) {
            String shapedColumn = DialectUtils.shapeIdentifier(columns[i].getColumnName(), prefs, this);
            result.append(shapedColumn);
            if (i + 1 >= columns.length) continue;
            result.append(", ");
        }
        result.append(")");
        return new String[]{result.toString()};
    }

    @Override
    public boolean supportsColumnComment() {
        return false;
    }

    @Override
    public String getColumnCommentAlterSQL(TableColumnInfo info, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) throws UnsupportedOperationException {
        int featureId = 0;
        String msg = DialectUtils.getUnsupportedMessage(this, featureId);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public boolean supportsAlterColumnNull() {
        return false;
    }

    @Override
    public String[] getColumnNullableAlterSQL(TableColumnInfo info, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        int featureId = 4;
        String msg = DialectUtils.getUnsupportedMessage(this, featureId);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public boolean supportsRenameColumn() {
        return true;
    }

    @Override
    public String getColumnNameAlterSQL(TableColumnInfo from, TableColumnInfo to, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        String alterClause = "ALTER COLUMN";
        String renameToClause = "TO";
        return DialectUtils.getColumnNameAlterSQL(from, to, alterClause, renameToClause, qualifier, prefs, this);
    }

    @Override
    public boolean supportsAlterColumnType() {
        return true;
    }

    @Override
    public List<String> getColumnTypeAlterSQL(TableColumnInfo from, TableColumnInfo to, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) throws UnsupportedOperationException {
        StringBuilder result = new StringBuilder();
        result.append("ALTER TABLE ");
        result.append(from.getTableName());
        result.append(" ALTER COLUMN ");
        result.append(from.getColumnName());
        result.append(" TYPE ");
        result.append(DialectUtils.getTypeName(to, this));
        ArrayList<String> list = new ArrayList<String>();
        list.add(result.toString());
        return list;
    }

    @Override
    public boolean supportsAlterColumnDefault() {
        return false;
    }

    @Override
    public String getColumnDefaultAlterSQL(TableColumnInfo info, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        int featureId = 1;
        String msg = DialectUtils.getUnsupportedMessage(this, featureId);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public String getDropPrimaryKeySQL(String pkName, String tableName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getDropPrimaryKeySQL(pkName, tableName, true, false, qualifier, prefs, this);
    }

    @Override
    public String getDropForeignKeySQL(String fkName, String tableName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getDropForeignKeySQL(fkName, tableName, qualifier, prefs, this);
    }

    @Override
    public List<String> getCreateTableSQL(List<ITableInfo> tables, ISQLDatabaseMetaData md, CreateScriptPreferences prefs, boolean isJdbcOdbc) throws SQLException {
        return DialectUtils.getCreateTableSQL(tables, md, this, prefs, isJdbcOdbc);
    }

    @Override
    public DialectType getDialectType() {
        return DialectType.FIREBIRD;
    }

    @Override
    public String[] getIndexAccessMethodsTypes() {
        return null;
    }

    @Override
    public String[] getIndexStorageOptions() {
        return null;
    }

    @Override
    public String[] getAddAutoIncrementSQL(TableColumnInfo column, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        String incrementNotSupported = null;
        String minValueNotSupported = null;
        String maxValueNotSupported = null;
        String startValueNotSupported = null;
        String cacheNotSupported = null;
        boolean cycle = false;
        String sequenceName = column.getColumnName() + "_AUTOINC_SEQ";
        String generatorSql = this.getCreateSequenceSQL(sequenceName, incrementNotSupported, minValueNotSupported, maxValueNotSupported, startValueNotSupported, cacheNotSupported, cycle, qualifier, prefs);
        String triggerName = "CREATE_" + column.getColumnName().toUpperCase();
        String trigTemplate = "CREATE TRIGGER $triggerName$ FOR $tableName$ BEFORE INSERT POSITION 0 AS BEGIN NEW.$columnName$ = GEN_ID($sequenceName$, 1); END";
        StringTemplate st = new StringTemplate(trigTemplate);
        HashMap<String, String> valuesMap = DialectUtils.getValuesMap("columnName", column.getColumnName());
        valuesMap.put("tableName", column.getTableName());
        valuesMap.put("sequenceName", sequenceName);
        valuesMap.put("triggerName", triggerName);
        String trigSql = DialectUtils.bindTemplateAttributes(this, st, valuesMap, qualifier, prefs);
        return new String[]{generatorSql, trigSql};
    }

    @Override
    public String[] getAddColumnSQL(TableColumnInfo column, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        boolean addDefaultClause = true;
        boolean supportsNullQualifier = false;
        boolean addNullClause = true;
        String sql = DialectUtils.getAddColumSQL(column, this, addDefaultClause, supportsNullQualifier, addNullClause, qualifier, prefs);
        return new String[]{sql};
    }

    @Override
    public String[] getAddForeignKeyConstraintSQL(String localTableName, String refTableName, String constraintName, Boolean deferrable, Boolean initiallyDeferred, Boolean matchFull, boolean autoFKIndex, String fkIndexName, Collection<String[]> localRefColumns, String onUpdateAction, String onDeleteAction, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringTemplate fkST = new StringTemplate("ALTER TABLE $childTableName$ ADD $constraint$ $constraintName$ FOREIGN KEY ( $childColumn; separator=\",\"$ ) REFERENCES $parentTableName$ ( $parentColumn; separator=\",\"$ )");
        HashMap<String, String> fkValuesMap = DialectUtils.getValuesMap("childTableName", localTableName);
        fkValuesMap.put("constraint", "CONSTRAINT");
        fkValuesMap.put("constraintName", constraintName);
        fkValuesMap.put("parentTableName", refTableName);
        StringTemplate childIndexST = null;
        HashMap<String, String> ckIndexValuesMap = null;
        if (autoFKIndex) {
            childIndexST = new StringTemplate("CREATE $unique$ $storageOption$ INDEX $indexName$ ON $tableName$ ( $columnName; separator=\",\"$ )");
            ckIndexValuesMap = new HashMap<String, String>();
            ckIndexValuesMap.put("indexName", "fk_child_idx");
        }
        return DialectUtils.getAddForeignKeyConstraintSQL(fkST, fkValuesMap, childIndexST, ckIndexValuesMap, localRefColumns, qualifier, prefs, this);
    }

    @Override
    public String[] getAddUniqueConstraintSQL(String tableName, String constraintName, TableColumnInfo[] columns, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        String templateStr = "ALTER TABLE $tableName$ ADD CONSTRAINT $constraintName$ UNIQUE ($columnName;  separator=\",\"$)";
        StringTemplate st = new StringTemplate(templateStr);
        HashMap<String, String> valuesMap = DialectUtils.getValuesMap("tableName", tableName, "constraintName", constraintName);
        return new String[]{DialectUtils.getAddUniqueConstraintSQL(st, valuesMap, columns, qualifier, prefs, (HibernateDialect)this)};
    }

    @Override
    public String[] getAlterSequenceSQL(String sequenceName, String increment, String minimum, String maximum, String restart, String cache, boolean cycle, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringTemplate st = new StringTemplate("SET GENERATOR $generatorName$ TO $value$");
        st.setAttribute("generatorName", (Object)sequenceName);
        st.setAttribute("value", (Object)minimum);
        return new String[]{st.toString()};
    }

    @Override
    public String getCreateIndexSQL(String indexName, String tableName, String accessMethod, String[] columns, boolean unique, String tablespace, String constraints, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringTemplate st = new StringTemplate("CREATE $unique$ INDEX $indexName$ ON $tableName$ ( $columnName; separator=\",\"$ )");
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        if (unique) {
            valuesMap.put("unique", "UNIQUE");
        }
        valuesMap.put("indexName", indexName);
        valuesMap.put("tableName", tableName);
        return DialectUtils.getAddIndexSQL(this, st, valuesMap, columns, qualifier, prefs);
    }

    @Override
    public String getCreateSequenceSQL(String sequenceName, String increment, String minimum, String maximum, String start, String cache, boolean cycle, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringTemplate st = new StringTemplate("CREATE GENERATOR $generatorName$");
        st.setAttribute("generatorName", (Object)sequenceName);
        return st.toString();
    }

    @Override
    public String getCreateTableSQL(String tableName, List<TableColumnInfo> columns, List<TableColumnInfo> primaryKeys, SqlGenerationPreferences prefs, DatabaseObjectQualifier qualifier) {
        return DialectUtils.getCreateTableSQL(tableName, columns, primaryKeys, prefs, qualifier, this);
    }

    @Override
    public String getCreateViewSQL(String viewName, String definition, String checkOption, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringTemplate st = new StringTemplate("CREATE VIEW $viewName$ AS $selectStatement$ $withCheckOption$");
        HashMap<String, String> valuesMap = DialectUtils.getValuesMap("viewName", viewName, "selectStatement", definition);
        if (checkOption != null) {
            valuesMap.put("withcheckOption", "WITH CHECK OPTION");
        }
        return DialectUtils.bindTemplateAttributes(this, st, valuesMap, qualifier, prefs);
    }

    @Override
    public String getDropConstraintSQL(String tableName, String constraintName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringTemplate st = new StringTemplate("ALTER TABLE $tableName$ DROP CONSTRAINT $constraintName$");
        HashMap<String, String> valuesMap = DialectUtils.getValuesMap("tableName", tableName, "constraintName", constraintName);
        return DialectUtils.bindTemplateAttributes(this, st, valuesMap, qualifier, prefs);
    }

    @Override
    public String getDropIndexSQL(String tableName, String indexName, boolean cascade, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringTemplate st = new StringTemplate("DROP INDEX $indexName$");
        HashMap<String, String> valuesMap = DialectUtils.getValuesMap("indexName", indexName);
        return DialectUtils.bindTemplateAttributes(this, st, valuesMap, qualifier, prefs);
    }

    @Override
    public String getDropSequenceSQL(String sequenceName, boolean cascade, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringTemplate st = new StringTemplate("DROP GENERATOR $generatorName$");
        st.setAttribute("generatorName", (Object)sequenceName);
        return st.toString();
    }

    @Override
    public String getRenameTableSQL(String oldTableName, String newTableName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        int featureId = 9;
        String msg = DialectUtils.getUnsupportedMessage(this, featureId);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public String[] getRenameViewSQL(String oldViewName, String newViewName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        int featureId = 11;
        String msg = DialectUtils.getUnsupportedMessage(this, featureId);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public String getSequenceInformationSQL(String sequenceName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        int featureId = 17;
        String msg = DialectUtils.getUnsupportedMessage(this, featureId);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public boolean supportsAccessMethods() {
        return false;
    }

    @Override
    public boolean supportsAddForeignKeyConstraint() {
        return true;
    }

    @Override
    public boolean supportsAddUniqueConstraint() {
        return true;
    }

    @Override
    public boolean supportsAlterSequence() {
        return true;
    }

    @Override
    public boolean supportsAutoIncrement() {
        return true;
    }

    @Override
    public boolean supportsCheckOptionsForViews() {
        return true;
    }

    @Override
    public boolean supportsCreateIndex() {
        return true;
    }

    @Override
    public boolean supportsCreateSequence() {
        return true;
    }

    @Override
    public boolean supportsCreateTable() {
        return true;
    }

    @Override
    public boolean supportsCreateView() {
        return true;
    }

    @Override
    public boolean supportsDropConstraint() {
        return true;
    }

    @Override
    public boolean supportsDropIndex() {
        return true;
    }

    @Override
    public boolean supportsDropSequence() {
        return true;
    }

    @Override
    public boolean supportsEmptyTables() {
        return false;
    }

    @Override
    public boolean supportsIndexes() {
        return true;
    }

    @Override
    public boolean supportsMultipleRowInserts() {
        return false;
    }

    @Override
    public boolean supportsRenameTable() {
        return false;
    }

    @Override
    public boolean supportsRenameView() {
        return false;
    }

    @Override
    public boolean supportsSequence() {
        return true;
    }

    @Override
    public boolean supportsSequenceInformation() {
        return false;
    }

    @Override
    public boolean supportsTablespace() {
        return false;
    }

    @Override
    public boolean supportsUpdate() {
        return true;
    }

    @Override
    public boolean supportsAddColumn() {
        return true;
    }

    @Override
    public boolean supportsViewDefinition() {
        return true;
    }

    @Override
    public String getViewDefinitionSQL(String viewName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return "select rdb$view_source from rdb$relations where rdb$relation_name = '" + viewName + "'";
    }

    @Override
    public String getQualifiedIdentifier(String identifier, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return identifier;
    }

    @Override
    public boolean supportsCorrelatedSubQuery() {
        return true;
    }

    @Override
    public String getDropViewSQL(String viewName, boolean cascade, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringTemplate st = new StringTemplate("DROP VIEW $viewName$");
        HashMap<String, String> valuesMap = DialectUtils.getValuesMap("viewName", viewName);
        return DialectUtils.bindTemplateAttributes(this, st, valuesMap, qualifier, prefs);
    }

    @Override
    public boolean supportsDropView() {
        return true;
    }

    @Override
    public boolean supportsSubSecondTimestamps() {
        return false;
    }

    private class FirebirdDialectHelper
    extends FirebirdDialect {
        public FirebirdDialectHelper() {
            this.registerColumnType(-5, "bigint");
            this.registerColumnType(-2, "blob sub_type 0");
            this.registerColumnType(-7, "char(1)");
            this.registerColumnType(2004, "blob sub_type -1");
            this.registerColumnType(16, "char(1)");
            this.registerColumnType(1, Short.MAX_VALUE, "char($l)");
            this.registerColumnType(1, "char(32767)");
            this.registerColumnType(2005, "blob sub_type text");
            this.registerColumnType(91, "date");
            this.registerColumnType(3, "decimal($p,$s)");
            this.registerColumnType(8, "double precision");
            this.registerColumnType(6, "double precision");
            this.registerColumnType(4, "integer");
            this.registerColumnType(-4, "blob sub_type 0");
            this.registerColumnType(-1, "blob sub_type 1");
            this.registerColumnType(2, 18, "numeric($p,$s)");
            this.registerColumnType(2, "double precision");
            this.registerColumnType(7, "double precision");
            this.registerColumnType(5, "smallint");
            this.registerColumnType(92, "time");
            this.registerColumnType(93, "timestamp");
            this.registerColumnType(-6, "smallint");
            this.registerColumnType(-3, "blob sub_type -1");
            this.registerColumnType(12, 32765, "varchar($l)");
            this.registerColumnType(12, "varchar(32765)");
        }
    }
}

