/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui;

import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.util.ArrayList;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ExtTableColumn;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.steppschuh.markdowngenerator.table.Table;

public class TableCopyAsMarkdownCommand {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(TableCopyAsMarkdownCommand.class);
    private final ISession _session;
    private final JTable _table;

    public TableCopyAsMarkdownCommand(JTable table, ISession session) {
        this._session = session;
        this._table = table;
    }

    public void execute() {
        int nbrSelRows = this._table.getSelectedRowCount();
        int nbrSelCols = this._table.getSelectedColumnCount();
        int[] selRows = this._table.getSelectedRows();
        int[] selCols = this._table.getSelectedColumns();
        ArrayList<ColumnDisplayDefinition> columnDisplayDefinitions = new ArrayList<ColumnDisplayDefinition>();
        for (int colIdx = 0; colIdx < nbrSelCols; ++colIdx) {
            TableColumn col = this._table.getColumnModel().getColumn(selCols[colIdx]);
            if (!(col instanceof ExtTableColumn)) {
                this._session.showErrorMessage(s_stringMgr.getString("TableCopyAsMarkdownCommand.failed.to.copy"));
                return;
            }
            columnDisplayDefinitions.add(((ExtTableColumn)col).getColumnDisplayDefinition());
        }
        ColumnDisplayDefinition[] colDefs = columnDisplayDefinitions.toArray(new ColumnDisplayDefinition[columnDisplayDefinitions.size()]);
        Object[] colNames = new String[colDefs.length];
        for (int i = 0; i < colDefs.length; ++i) {
            colNames[i] = colDefs[i].getColumnName();
        }
        Table.Builder tableBuilder = new Table.Builder();
        tableBuilder.addRow(colNames);
        for (int rowIdx = 0; rowIdx < nbrSelRows; ++rowIdx) {
            Object[] row = new Object[colDefs.length];
            int curIx = 0;
            for (int colIdx = 0; colIdx < nbrSelCols; ++colIdx) {
                Object cellObj = this._table.getValueAt(selRows[rowIdx], selCols[colIdx]);
                if (cellObj instanceof String && -1 < ((String)cellObj).indexOf(10)) {
                    int lineBreakPos = ((String)cellObj).indexOf(10);
                    row[curIx] = ((String)cellObj).substring(0, lineBreakPos);
                } else {
                    row[curIx] = null == cellObj ? "<null>" : cellObj;
                }
                ++curIx;
            }
            tableBuilder.addRow(row);
        }
        String markdownTable = tableBuilder.build().toString();
        int width = markdownTable.indexOf(10);
        String line = new String(new char[width]).replace('\u0000', '-') + "\n";
        StringSelection ss = new StringSelection(line + markdownTable + "\n" + line);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, ss);
    }
}

