/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.util.log;

import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.ILoggerListener;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class Log4jLogger
implements ILogger {
    private Logger _log;
    private ILoggerListener _listener;
    private Class<?> _clazz;

    Log4jLogger(Class<?> clazz, ILoggerListener listener) {
        Utilities.checkNull("Log4jLogger.init", "clazz", clazz, "listener", listener);
        this._listener = listener;
        this._clazz = clazz;
        this._log = Logger.getLogger(clazz);
    }

    @Override
    public void debug(Object message) {
        this._log.debug(message);
    }

    @Override
    public void debug(Object message, Throwable th) {
        this._log.debug(message, th);
    }

    @Override
    public void info(Object message) {
        this._log.info(message);
        this._listener.info(this._clazz, message);
    }

    @Override
    public void info(Object message, Throwable th) {
        this._log.info(message, th);
        this._listener.info(this._clazz, message, th);
    }

    @Override
    public void warn(Object message) {
        this._log.warn(message);
        this._listener.warn(this._clazz, message);
    }

    @Override
    public void warn(Object message, Throwable th) {
        this._log.warn(message, th);
        this._listener.warn(this._clazz, message, th);
    }

    @Override
    public void error(Object message) {
        this._log.error(message);
        this._listener.error(this._clazz, message);
    }

    @Override
    public void error(Object message, Throwable th) {
        this._log.error(message, th);
        this._listener.error(this._clazz, message, th);
    }

    @Override
    public boolean isDebugEnabled() {
        return this._log.isDebugEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this._log.isInfoEnabled();
    }

    @Override
    public void setLevel(Level l) {
        this._log.setLevel(l);
    }
}

