/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.dataimport.importer.csv;

import com.csvreader.CsvReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.dataimport.importer.IFileImporter;
import net.sourceforge.squirrel_sql.plugins.dataimport.importer.UnsupportedFormatException;
import net.sourceforge.squirrel_sql.plugins.dataimport.importer.csv.CSVSettingsBean;
import net.sourceforge.squirrel_sql.plugins.dataimport.importer.csv.CSVSettingsPanel;

public class CSVFileImporter
implements IFileImporter {
    private static final StringManager stringMgr = StringManagerFactory.getStringManager(CSVFileImporter.class);
    private CSVSettingsBean settings = null;
    private File importFile = null;
    private CsvReader reader = null;
    private boolean safetySwitch = true;

    public CSVFileImporter(File importFile) {
        this.importFile = importFile;
        this.settings = new CSVSettingsBean();
    }

    @Override
    public boolean open() throws IOException {
        this.reset();
        return true;
    }

    @Override
    public boolean close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
        return true;
    }

    @Override
    public String[][] getPreview(int noOfLines) throws IOException {
        int row;
        CsvReader csvReader = new CsvReader(new InputStreamReader((InputStream)new FileInputStream(this.importFile), this.settings.getImportCharset()), this.settings.getSeperator());
        String[][] data = new String[noOfLines][];
        int columns = -1;
        for (row = 0; csvReader.readRecord() && row < noOfLines; ++row) {
            if (columns == -1) {
                columns = csvReader.getColumnCount();
            }
            data[row] = new String[columns];
            for (int i = 0; i < columns; ++i) {
                data[row][i] = csvReader.get(i);
            }
        }
        csvReader.close();
        String[][] outData = new String[row][];
        for (int i = 0; i < row; ++i) {
            outData[i] = data[i];
        }
        return outData;
    }

    @Override
    public int getRows() {
        return -1;
    }

    @Override
    public boolean next() throws IOException {
        return this.reader.readRecord();
    }

    @Override
    public boolean reset() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
        this.reader = new CsvReader(new InputStreamReader((InputStream)new FileInputStream(this.importFile), this.settings.getImportCharset()), this.settings.getSeperator());
        this.reader.setSafetySwitch(this.safetySwitch);
        return true;
    }

    @Override
    public String getString(int column) throws IOException {
        return this.reader.get(column);
    }

    @Override
    public Long getLong(int column) throws IOException, UnsupportedFormatException {
        String longS = this.reader.get(column);
        try {
            if (null == longS || 0 == longS.trim().length()) {
                return null;
            }
            return Long.parseLong(longS);
        }
        catch (NumberFormatException nfe) {
            throw new UnsupportedFormatException("Could not interpret value as long type. Value is: " + longS, nfe);
        }
    }

    @Override
    public Integer getInt(int column) throws IOException, UnsupportedFormatException {
        try {
            String intS = this.reader.get(column);
            if (null == intS || 0 == intS.trim().length()) {
                return null;
            }
            return Integer.parseInt(intS);
        }
        catch (NumberFormatException nfe) {
            throw new UnsupportedFormatException(nfe);
        }
    }

    @Override
    public Date getDate(int column) throws IOException, UnsupportedFormatException {
        Date d = null;
        String dateString = this.reader.get(column);
        try {
            SimpleDateFormat f = new SimpleDateFormat(this.settings.getDateFormat());
            if (null != dateString && dateString.trim().length() > 0) {
                d = f.parse(dateString);
            }
        }
        catch (IllegalArgumentException e) {
            JOptionPane.showMessageDialog(null, stringMgr.getString("CSVFileImporter.invalidDateFormat"));
            throw new UnsupportedFormatException("Could not interpret value as date type. Value is: " + dateString, e);
        }
        catch (ParseException pe) {
            throw new UnsupportedFormatException("Could not interpret value as date type. Value is: " + dateString, pe);
        }
        return d;
    }

    @Override
    public JComponent getConfigurationPanel() {
        return new CSVSettingsPanel(this.settings);
    }

    public void setSafetySwitch(boolean safetySwitch) {
        this.safetySwitch = safetySwitch;
    }
}

