/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseButtonListener;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicToggleButtonUI;
import javax.swing.text.View;

public class BaseToggleButtonUI
extends BasicToggleButtonUI {
    private static Rectangle viewRect = new Rectangle();
    private static Rectangle textRect = new Rectangle();
    private static Rectangle iconRect = new Rectangle();
    protected static Color[] rolloverPressedColors = null;

    public static ComponentUI createUI(JComponent b) {
        return new BaseToggleButtonUI();
    }

    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        b.setOpaque(false);
        b.setRolloverEnabled(true);
        Color[] cArr = AbstractLookAndFeel.getTheme().getPressedColors();
        rolloverPressedColors = new Color[cArr.length];
        for (int i = 0; i < cArr.length; ++i) {
            BaseToggleButtonUI.rolloverPressedColors[i] = ColorHelper.brighter(cArr[i], 20.0);
        }
    }

    public void uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
        b.setOpaque(true);
        b.setRolloverEnabled(false);
    }

    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return new BaseButtonListener(b);
    }

    protected void paintBackground(Graphics g, AbstractButton b) {
        Color background;
        if (!b.isContentAreaFilled() || b.getParent() instanceof JMenuBar) {
            return;
        }
        int width = b.getWidth();
        int height = b.getHeight();
        ButtonModel model = b.getModel();
        Color[] colors = b.isEnabled() ? ((background = b.getBackground()) instanceof ColorUIResource ? (model.isPressed() && model.isArmed() ? AbstractLookAndFeel.getTheme().getPressedColors() : (b.isRolloverEnabled() && model.isRollover() ? (model.isSelected() ? rolloverPressedColors : AbstractLookAndFeel.getTheme().getRolloverColors()) : (model.isSelected() ? AbstractLookAndFeel.getTheme().getPressedColors() : (AbstractLookAndFeel.getTheme().doShowFocusFrame() && b.hasFocus() ? AbstractLookAndFeel.getTheme().getFocusColors() : AbstractLookAndFeel.getTheme().getButtonColors())))) : (model.isPressed() && model.isArmed() ? ColorHelper.createColorArr(ColorHelper.darker(background, 30.0), ColorHelper.darker(background, 10.0), 20) : (b.isRolloverEnabled() && model.isRollover() ? (model.isSelected() ? ColorHelper.createColorArr(ColorHelper.darker(background, 20.0), background, 20) : ColorHelper.createColorArr(ColorHelper.brighter(background, 50.0), ColorHelper.brighter(background, 10.0), 20)) : (model.isSelected() ? ColorHelper.createColorArr(ColorHelper.darker(background, 40.0), ColorHelper.darker(background, 20.0), 20) : ColorHelper.createColorArr(ColorHelper.brighter(background, 30.0), ColorHelper.darker(background, 10.0), 20))))) : AbstractLookAndFeel.getTheme().getDisabledColors();
        JTattooUtilities.fillHorGradient(g, colors, 1, 1, width - 2, height - 2);
    }

    protected void paintText(Graphics g, AbstractButton b, Rectangle textRect, String text) {
        ButtonModel model = b.getModel();
        FontMetrics fm = g.getFontMetrics();
        int mnemIndex = JTattooUtilities.getJavaVersion() >= 1.4 ? b.getDisplayedMnemonicIndex() : JTattooUtilities.findDisplayedMnemonicIndex(b.getText(), model.getMnemonic());
        if (model.isEnabled()) {
            Color foreground = b.getForeground();
            int offs = 0;
            if (model.isArmed() && model.isPressed() || model.isSelected()) {
                offs = 1;
            }
            if (foreground instanceof ColorUIResource) {
                if (model.isRollover()) {
                    g.setColor(AbstractLookAndFeel.getTheme().getRolloverForegroundColor());
                } else {
                    g.setColor(b.getForeground());
                }
            } else {
                g.setColor(b.getForeground());
            }
            JTattooUtilities.drawStringUnderlineCharAt(b, g, text, mnemIndex, textRect.x + offs, textRect.y + offs + fm.getAscent());
        } else {
            g.setColor(Color.white);
            JTattooUtilities.drawStringUnderlineCharAt(b, g, text, mnemIndex, textRect.x + 1, textRect.y + 1 + fm.getAscent());
            g.setColor(AbstractLookAndFeel.getDisabledForegroundColor());
            JTattooUtilities.drawStringUnderlineCharAt(b, g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
        }
    }

    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        g.setColor(AbstractLookAndFeel.getFocusColor());
        BasicGraphicsUtils.drawDashedRect(g, 4, 3, b.getWidth() - 8, b.getHeight() - 6);
    }

    public void paint(Graphics g, JComponent c) {
        Graphics2D g2D = (Graphics2D)g;
        AbstractButton b = (AbstractButton)c;
        Font f = c.getFont();
        g.setFont(f);
        FontMetrics fm = g.getFontMetrics();
        Insets insets = c.getInsets();
        BaseToggleButtonUI.viewRect.x = insets.left;
        BaseToggleButtonUI.viewRect.y = insets.top;
        BaseToggleButtonUI.viewRect.width = b.getWidth() - (insets.right + BaseToggleButtonUI.viewRect.x);
        BaseToggleButtonUI.viewRect.height = b.getHeight() - (insets.bottom + BaseToggleButtonUI.viewRect.y);
        BaseToggleButtonUI.textRect.height = 0;
        BaseToggleButtonUI.textRect.width = 0;
        BaseToggleButtonUI.textRect.y = 0;
        BaseToggleButtonUI.textRect.x = 0;
        BaseToggleButtonUI.iconRect.height = 0;
        BaseToggleButtonUI.iconRect.width = 0;
        BaseToggleButtonUI.iconRect.y = 0;
        BaseToggleButtonUI.iconRect.x = 0;
        String text = SwingUtilities.layoutCompoundLabel(c, fm, b.getText(), b.getIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getText() == null ? 0 : this.defaultTextIconGap);
        this.paintBackground(g, b);
        if (b.getIcon() != null) {
            if (!b.isEnabled()) {
                Composite savedComposite = g2D.getComposite();
                AlphaComposite alpha = AlphaComposite.getInstance(3, 0.5f);
                g2D.setComposite(alpha);
                this.paintIcon(g, c, iconRect);
                g2D.setComposite(savedComposite);
            } else {
                this.paintIcon(g, c, iconRect);
            }
        }
        if (text != null && !text.equals("") && textRect != null) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                Object savedRenderingHint = null;
                if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
                    savedRenderingHint = g2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
                    g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, AbstractLookAndFeel.getTheme().getTextAntiAliasingHint());
                }
                v.paint(g, textRect);
                if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
                    g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, savedRenderingHint);
                }
            } else {
                this.paintText(g, b, textRect, text);
            }
        }
        if (b.isFocusPainted() && b.hasFocus()) {
            this.paintFocus(g, b, viewRect, textRect, iconRect);
        }
    }
}

