/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.ui.util;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import org.jmeld.diff.JMDelta;
import org.jmeld.settings.EditorSettings;
import org.jmeld.settings.JMeldSettings;

public class RevisionUtil {
    private static Map<Color, Color> darker = new HashMap<Color, Color>();

    public static Color getColor(JMDelta delta) {
        if (delta.isDelete()) {
            return RevisionUtil.getSettings().getDeletedColor();
        }
        if (delta.isChange()) {
            return RevisionUtil.getSettings().getChangedColor();
        }
        return RevisionUtil.getSettings().getAddedColor();
    }

    public static Color getDarkerColor(JMDelta delta) {
        Color c = RevisionUtil.getColor(delta);
        Color result = darker.get(c);
        if (result == null) {
            result = c.darker();
            darker.put(c, result);
        }
        return result;
    }

    private static EditorSettings getSettings() {
        return JMeldSettings.getInstance().getEditor();
    }
}

