/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.util;

import org.jmeld.diff.JMDelta;
import org.jmeld.diff.JMRevision;

public class DiffUtil {
    public static boolean debug = false;

    public static int getRevisedLine(JMRevision revision, int originalLine) {
        int revisedSize;
        int revisedAnchor;
        int originalSize;
        int originalAnchor;
        if (revision == null) {
            return 0;
        }
        int revisedLine = originalLine;
        JMDelta delta = DiffUtil.findOriginalDelta(revision, originalLine);
        if (delta != null) {
            originalAnchor = delta.getOriginal().getAnchor();
            originalSize = delta.getOriginal().getSize();
            revisedAnchor = delta.getRevised().getAnchor();
            revisedSize = delta.getRevised().getSize();
            revisedLine = originalLine - originalAnchor < originalSize ? revisedAnchor : revisedAnchor + revisedSize - originalSize + (originalLine - originalAnchor);
        } else {
            originalAnchor = 0;
            originalSize = 0;
            revisedAnchor = 0;
            revisedSize = 0;
        }
        if (debug) {
            System.out.printf("%03d-%02d, %03d-%02d == ", originalAnchor, originalSize, revisedAnchor, revisedSize);
        }
        return revisedLine;
    }

    public static int getOriginalLine(JMRevision revision, int revisedLine) {
        int revisedSize;
        int revisedAnchor;
        int originalSize;
        int originalAnchor;
        int originalLine = revisedLine;
        JMDelta delta = DiffUtil.findRevisedDelta(revision, revisedLine);
        if (delta != null) {
            originalAnchor = delta.getOriginal().getAnchor();
            originalSize = delta.getOriginal().getSize();
            revisedAnchor = delta.getRevised().getAnchor();
            originalLine = revisedLine - revisedAnchor < (revisedSize = delta.getRevised().getSize()) ? originalAnchor : originalAnchor + originalSize - revisedSize + (revisedLine - revisedAnchor);
        } else {
            originalAnchor = 0;
            originalSize = 0;
            revisedAnchor = 0;
            revisedSize = 0;
        }
        if (debug) {
            System.out.printf("%03d-%02d, %03d-%02d == ", originalAnchor, originalSize, revisedAnchor, revisedSize);
        }
        return originalLine;
    }

    private static JMDelta findOriginalDelta(JMRevision revision, int line) {
        return DiffUtil.findDelta(revision, line, true);
    }

    private static JMDelta findRevisedDelta(JMRevision revision, int line) {
        return DiffUtil.findDelta(revision, line, false);
    }

    private static JMDelta findDelta(JMRevision revision, int line, boolean originalDelta) {
        if (revision == null) {
            return null;
        }
        JMDelta previousDelta = null;
        for (JMDelta delta : revision.getDeltas()) {
            int anchor = originalDelta ? delta.getOriginal().getAnchor() : delta.getRevised().getAnchor();
            if (anchor > line) break;
            previousDelta = delta;
        }
        return previousDelta;
    }
}

