/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.hibernate.server;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.HibernatePropertyInfo;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.MappedClassInfoData;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.PlainValue;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.PropertySubstitute;

public class ObjectSubstitute
implements Serializable {
    private HashMap<String, PropertySubstitute> _substituteValueByPropertyName = new HashMap();
    private MappedClassInfoData _mappedClassInfoData;
    private String _toString;
    public static final String PLAIN_VALUES = "<plain values>";
    private ArrayList<Object> _plainValueArray;
    private HashMap<String, PlainValue> _plainValueByPropertyName = new HashMap();

    ObjectSubstitute(MappedClassInfoData mappedClassInfoData, String toString) {
        this._mappedClassInfoData = mappedClassInfoData;
        this._toString = toString;
    }

    ObjectSubstitute(ArrayList<Object> plainValueArray) {
        this._plainValueArray = plainValueArray;
        this._toString = "<plain values>[" + plainValueArray.size() + "]";
        String className = null == plainValueArray.get(0) ? "<unknown>" : plainValueArray.get(0).getClass().getName();
        String propertyName = "value 1";
        HibernatePropertyInfo indentifierHibernatePropertyInfo = new HibernatePropertyInfo(propertyName, className, "<unknown>", new String[]{"<unknown>"});
        this._plainValueByPropertyName.put(propertyName, new PlainValue(plainValueArray.get(0), indentifierHibernatePropertyInfo));
        HibernatePropertyInfo[] hibernatePropertyInfos = new HibernatePropertyInfo[plainValueArray.size() - 1];
        for (int i = 1; i < plainValueArray.size(); ++i) {
            className = null == plainValueArray.get(i) ? "<unknown>" : plainValueArray.get(i).getClass().getName();
            propertyName = "value " + (i + 1);
            hibernatePropertyInfos[i - 1] = new HibernatePropertyInfo(propertyName, className, "<unknown>", new String[]{"<unknown>"});
            this._plainValueByPropertyName.put(propertyName, new PlainValue(plainValueArray.get(i), hibernatePropertyInfos[i - 1]));
        }
        this._mappedClassInfoData = new MappedClassInfoData(PLAIN_VALUES, "<unknown>", indentifierHibernatePropertyInfo, hibernatePropertyInfos);
        this._mappedClassInfoData.setPlainValueArray(true);
    }

    void putSubstituteValueByPropertyName(String propertyName, PropertySubstitute propertySubstitute) {
        if (null != this._plainValueArray) {
            throw new IllegalStateException("Should not be called for plain values");
        }
        this._substituteValueByPropertyName.put(propertyName, propertySubstitute);
    }

    public String getClassName() {
        return this._mappedClassInfoData.getMappedClassName();
    }

    public Object getValue(String propertyName) {
        if (null == this._plainValueArray) {
            return this._substituteValueByPropertyName.get(propertyName).getSingleValue();
        }
        return this._plainValueByPropertyName.get(propertyName).getValue();
    }

    public String getTypeName(String propertyName) {
        if (null == this._plainValueArray) {
            return this._substituteValueByPropertyName.get(propertyName).getHibernatePropertyInfo().getClassName();
        }
        return this._plainValueByPropertyName.get(propertyName).getHibernatePropertyInfo().getClassName();
    }

    public boolean wasInitialized(String propertyName) {
        if (null == this._plainValueArray) {
            return this._substituteValueByPropertyName.get(propertyName).isInitialized();
        }
        return true;
    }

    public Collection<? extends ObjectSubstitute> getPersistentCollection(String propertyName) {
        return this._substituteValueByPropertyName.get(propertyName).getObjectSubstituteCollection();
    }

    public boolean isPersistenCollection(String propertyName) {
        if (null == this._plainValueArray) {
            return this._substituteValueByPropertyName.get(propertyName).isPersistenCollection();
        }
        return false;
    }

    public boolean isNull(String propertyName) {
        if (null == this._plainValueArray) {
            return this._substituteValueByPropertyName.get(propertyName).isNull();
        }
        return null == this._plainValueByPropertyName.get(propertyName).getValue();
    }

    public HibernatePropertyInfo getHibernatePropertyInfo(String propertyName) {
        if (null == this._plainValueArray) {
            return this._substituteValueByPropertyName.get(propertyName).getHibernatePropertyInfo();
        }
        return this._plainValueByPropertyName.get(propertyName).getHibernatePropertyInfo();
    }

    public String toString() {
        return this._toString;
    }

    public MappedClassInfoData getPlainValueArrayMappedClassInfo() {
        if (null == this._plainValueArray) {
            return null;
        }
        return this._mappedClassInfoData;
    }
}

