/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.sqlreplace;

import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.IWidget;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.SelectWidgetCommand;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.event.SQLExecutionAdapter;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.sqlreplace.ReplacementManager;
import net.sourceforge.squirrel_sql.plugins.sqlreplace.SQLReplacePlugin;

public class SQLReplaceExecutionListener
extends SQLExecutionAdapter {
    private static final ILogger log = LoggerController.createLogger(SQLReplacePlugin.class);
    private ISession session = null;
    private SQLReplacePlugin plugin = null;

    public SQLReplaceExecutionListener() {
    }

    public SQLReplaceExecutionListener(SQLReplacePlugin plugin, ISession session) {
        this.session = session;
        this.plugin = plugin;
    }

    public void statementExecuted(String sql) {
    }

    public String statementExecuting(String sql) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("statementExecuting: original SQL = " + sql));
        }
        StringBuffer buffer = new StringBuffer(sql);
        ReplacementManager repMan = this.plugin.getReplacementManager();
        String replacedStmnt = repMan.replace(buffer);
        if (log.isDebugEnabled()) {
            log.debug((Object)("statementExecuting: replacedStmnt = " + replacedStmnt));
        }
        GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

            @Override
            public void run() {
                new SelectWidgetCommand((IWidget)SQLReplaceExecutionListener.this.session.getActiveSessionWindow()).execute();
            }
        });
        return replacedStmnt;
    }
}

