// -*- C++ -*-
/**
 * Code generated by the The ACE ORB (TAO) IDL Compiler v2.4.0
 * TAO and the TAO IDL Compiler have been developed by:
 *       Center for Distributed Object Computing
 *       Washington University
 *       St. Louis, MO
 *       USA
 *       http://www.cs.wustl.edu/~schmidt/doc-center.html
 * and
 *       Distributed Object Computing Laboratory
 *       University of California at Irvine
 *       Irvine, CA
 *       USA
 * and
 *       Institute for Software Integrated Systems
 *       Vanderbilt University
 *       Nashville, TN
 *       USA
 *       http://www.isis.vanderbilt.edu/
 *
 * Information about TAO is available at:
 *     http://www.dre.vanderbilt.edu/~schmidt/TAO.html
 **/


// TAO_IDL - Generated from
// be/be_codegen.cpp:649

#ifndef _TAO_IDL_QUOTERS_PCW9AY_CPP_
#define _TAO_IDL_QUOTERS_PCW9AY_CPP_


#include "QuoterS.h"
#include "tao/PortableServer/Operation_Table_Perfect_Hash.h"
#include "tao/Exception_Data.h"
#include "tao/Messaging/ExceptionHolder_i.h"
#include "tao/PortableServer/Upcall_Command.h"
#include "tao/PortableServer/Upcall_Wrapper.h"
#include "tao/TAO_Server_Request.h"
#include "tao/ORB_Core.h"
#include "tao/Profile.h"
#include "tao/Stub.h"
#include "tao/IFR_Client_Adapter.h"
#include "tao/Object_T.h"
#include "tao/AnyTypeCode/TypeCode.h"
#include "tao/AnyTypeCode/DynamicC.h"
#include "tao/CDR.h"
#include "tao/operation_details.h"
#include "tao/PortableInterceptor.h"
#include "ace/Dynamic_Service.h"
#include "ace/Malloc_Allocator.h"

// TAO_IDL - Generated from
// be/be_interface.cpp:1865

class TAO_Quoter_Stock_Factory_Perfect_Hash_OpTable
  : public TAO_Perfect_Hash_OpTable
{
private:
  unsigned int hash (const char *str, unsigned int len);

public:
  const TAO_operation_db_entry * lookup (const char *str, unsigned int len);
};

/* C++ code produced by gperf version 2.8 (ACE version) */
/* Command-line: /xusr/Repository/tao/src/ACE_wrappers/bin/ace_gperf -m -M -J -c -C -D -E -T -f 0 -F 0,0 -a -o -t -p -K opname -L C++ -Z TAO_Quoter_Stock_Factory_Perfect_Hash_OpTable -N lookup  */
unsigned int
TAO_Quoter_Stock_Factory_Perfect_Hash_OpTable::hash (const char *str, unsigned int len)
{
  static const unsigned char asso_values[] =
    {
     16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
     16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
     16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
     16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
     16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
     16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
     16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
     16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
     16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
     16, 16, 16, 16, 16,  0, 16,  0, 16, 16,
      0,  5, 16,  0, 16, 16, 16,  0, 16, 16,
     16, 16, 16, 16, 16, 16,  0, 16, 16, 16,
     16, 16, 16, 16, 16, 16, 16, 16,
    };
  return len + asso_values[static_cast<int>(str[len - 1])] + asso_values[static_cast<int>(str[0])];
}

const TAO_operation_db_entry *
TAO_Quoter_Stock_Factory_Perfect_Hash_OpTable::lookup (const char *str, unsigned int len)
{
  enum
    {
      TOTAL_KEYWORDS = 6,
      MIN_WORD_LENGTH = 5,
      MAX_WORD_LENGTH = 14,
      MIN_HASH_VALUE = 5,
      MAX_HASH_VALUE = 15,
      HASH_VALUE_RANGE = 11,
      DUPLICATES = 0,
      WORDLIST_SIZE = 11
    };

  static const TAO_operation_db_entry wordlist[] =
    {
      {"",0,0},{"",0,0},{"",0,0},{"",0,0},{"",0,0},
      {"_is_a", &TAO_ServantBase::_is_a_thru_poa_skel, 0},
      {"",0,0},{"",0,0},{"",0,0},
      {"get_stock", &POA_Quoter::Stock_Factory::get_stock_skel, 0},
      {"_component", &TAO_ServantBase::_component_thru_poa_skel, 0},
      {"",0,0},{"",0,0},
      {"_non_existent", &TAO_ServantBase::_non_existent_thru_poa_skel, 0},
      {"_repository_id", &TAO_ServantBase::_repository_id_thru_poa_skel, 0},
      {"_interface", &TAO_ServantBase::_interface_skel, 0},
    };

  if (len <= MAX_WORD_LENGTH && len >= MIN_WORD_LENGTH)
    {
      unsigned int key = hash (str, len);

      if (key <= MAX_HASH_VALUE && key >= MIN_HASH_VALUE)
        {
          const char *s = wordlist[key].opname;

          if (*str == *s && !ACE_OS::strncmp (str + 1, s + 1, len - 1))
            return &wordlist[key];
        }
    }
  return 0;
}

static TAO_Quoter_Stock_Factory_Perfect_Hash_OpTable tao_Quoter_Stock_Factory_optable;

// TAO_IDL - Generated from
// be/be_visitor_interface/interface_ss.cpp:90

POA_Quoter::Stock_Factory::Stock_Factory (void)
  : TAO_ServantBase ()
{
  this->optable_ = &tao_Quoter_Stock_Factory_optable;
}

POA_Quoter::Stock_Factory::Stock_Factory (const Stock_Factory& rhs)
  : TAO_Abstract_ServantBase (rhs),
    TAO_ServantBase (rhs)
{
}

POA_Quoter::Stock_Factory::~Stock_Factory (void)
{
}

namespace POA_Quoter
{
  

  // TAO_IDL - Generated from
  // be/be_visitor_operation/upcall_command_ss.cpp:80

  class get_stock_Stock_Factory
    : public TAO::Upcall_Command
  {
  public:
    inline get_stock_Stock_Factory (
      POA_Quoter::Stock_Factory * servant,
      TAO_Operation_Details const * operation_details,
      TAO::Argument * const args[])
      : servant_ (servant)
        , operation_details_ (operation_details)
        , args_ (args)
    {
    }

    virtual void execute (void)
    {
      TAO::SArg_Traits< ::Quoter::Stock>::ret_arg_type retval =
        TAO::Portable_Server::get_ret_arg< ::Quoter::Stock> (
          this->operation_details_,
          this->args_);
      
      TAO::SArg_Traits< char *>::in_arg_type arg_1 =
        TAO::Portable_Server::get_in_arg< char *> (
          this->operation_details_,
          this->args_,
          1);
        
      retval =
        this->servant_->get_stock (
          arg_1);
    }
  
  private:
    POA_Quoter::Stock_Factory * const servant_;
    TAO_Operation_Details const * const operation_details_;
    TAO::Argument * const * const args_;
  };
}

// TAO_IDL - Generated from
// be/be_visitor_operation/operation_ss.cpp:168

void POA_Quoter::Stock_Factory::get_stock_skel (
  TAO_ServerRequest & server_request,
  TAO::Portable_Server::Servant_Upcall *TAO_INTERCEPTOR (servant_upcall),
  TAO_ServantBase *servant)
{
#if TAO_HAS_INTERCEPTORS == 1
  static ::CORBA::TypeCode_ptr const exceptions[] = 
    {
      Quoter::_tc_Invalid_Stock_Symbol
    };
  static ::CORBA::ULong const nexceptions = 1;
#endif /* TAO_HAS_INTERCEPTORS */

  TAO::SArg_Traits< ::Quoter::Stock>::ret_val retval;
  TAO::SArg_Traits< char *>::in_arg_val _tao_stock_symbol;

  TAO::Argument * const args[] =
    {
      &retval,
      &_tao_stock_symbol
    };
  
  static size_t const nargs = 2;

  POA_Quoter::Stock_Factory * const impl =
    dynamic_cast<POA_Quoter::Stock_Factory *> (servant);

  if (!impl)
    {
      throw ::CORBA::INTERNAL ();
    }

  get_stock_Stock_Factory command (
    impl,
    server_request.operation_details (),
    args);
  
  TAO::Upcall_Wrapper upcall_wrapper;
  upcall_wrapper.upcall (server_request
                         , args
                         , nargs
                         , command
#if TAO_HAS_INTERCEPTORS == 1
                         , servant_upcall
                         , exceptions
                         , nexceptions
#endif  /* TAO_HAS_INTERCEPTORS == 1 */
                         );
}



// TAO_IDL - Generated from
// be/be_visitor_interface/interface_ss.cpp:163



::CORBA::Boolean POA_Quoter::Stock_Factory::_is_a (const char* value)
{
  return
    (
      ACE_OS::strcmp (
          value,
          "IDL:Quoter/Stock_Factory:1.0"
        ) == 0 ||
      !ACE_OS::strcmp (
          value,
          "IDL:omg.org/CORBA/Object:1.0"
        )
    );
}

const char* POA_Quoter::Stock_Factory::_interface_repository_id (void) const
{
  return "IDL:Quoter/Stock_Factory:1.0";
}

// TAO_IDL - Generated from
// be/be_visitor_interface/interface_ss.cpp:423

void POA_Quoter::Stock_Factory::_dispatch (
  TAO_ServerRequest & req,
  TAO::Portable_Server::Servant_Upcall* servant_upcall)
{
  this->synchronous_upcall_dispatch (req, servant_upcall, this);
}

// TAO_IDL - Generated from
// be/be_visitor_interface/interface_ss.cpp:370

Quoter::Stock_Factory *
POA_Quoter::Stock_Factory::_this (void)
{
  TAO_Stub *stub = this->_create_stub ();

  TAO_Stub_Auto_Ptr safe_stub (stub);
  ::CORBA::Object_ptr tmp = CORBA::Object_ptr ();

  ::CORBA::Boolean const _tao_opt_colloc =
    stub->servant_orb_var ()->orb_core ()->optimize_collocation_objects ();
  
  ACE_NEW_RETURN (
      tmp,
      ::CORBA::Object (stub, _tao_opt_colloc, this),
      0);
  
  ::CORBA::Object_var obj = tmp;
  (void) safe_stub.release ();

  typedef ::Quoter::Stock_Factory STUB_SCOPED_NAME;
  return
    TAO::Narrow_Utils<STUB_SCOPED_NAME>::unchecked_narrow (
        obj.in ());
}

// TAO_IDL - Generated from
// be/be_interface.cpp:1865

class TAO_Quoter_AMI_Stock_FactoryHandler_Perfect_Hash_OpTable
  : public TAO_Perfect_Hash_OpTable
{
private:
  unsigned int hash (const char *str, unsigned int len);

public:
  const TAO_operation_db_entry * lookup (const char *str, unsigned int len);
};

/* C++ code produced by gperf version 2.8 (ACE version) */
/* Command-line: /xusr/Repository/tao/src/ACE_wrappers/bin/ace_gperf -m -M -J -c -C -D -E -T -f 0 -F 0,0 -a -o -t -p -K opname -L C++ -Z TAO_Quoter_AMI_Stock_FactoryHandler_Perfect_Hash_OpTable -N lookup  */
unsigned int
TAO_Quoter_AMI_Stock_FactoryHandler_Perfect_Hash_OpTable::hash (const char *str, unsigned int len)
{
  static const unsigned char asso_values[] =
    {
     16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
     16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
     16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
     16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
     16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
     16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
     16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
     16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
     16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
     16, 16, 16, 16, 16,  0, 16,  0, 16, 16,
      0,  2, 16,  0, 16, 16, 16,  0, 16, 16,
     16, 16,  0, 16, 16, 16,  0, 16, 16, 16,
     16, 16, 16, 16, 16, 16, 16, 16,
    };
  return len + asso_values[static_cast<int>(str[len - 1])] + asso_values[static_cast<int>(str[0])];
}

const TAO_operation_db_entry *
TAO_Quoter_AMI_Stock_FactoryHandler_Perfect_Hash_OpTable::lookup (const char *str, unsigned int len)
{
  enum
    {
      TOTAL_KEYWORDS = 7,
      MIN_WORD_LENGTH = 5,
      MAX_WORD_LENGTH = 15,
      MIN_HASH_VALUE = 5,
      MAX_HASH_VALUE = 15,
      HASH_VALUE_RANGE = 11,
      DUPLICATES = 0,
      WORDLIST_SIZE = 12
    };

  static const TAO_operation_db_entry wordlist[] =
    {
      {"",0,0},{"",0,0},{"",0,0},{"",0,0},{"",0,0},
      {"_is_a", &TAO_ServantBase::_is_a_thru_poa_skel, 0},
      {"",0,0},{"",0,0},{"",0,0},
      {"get_stock", &POA_Quoter::AMI_Stock_FactoryHandler::get_stock_skel, 0},
      {"_component", &TAO_ServantBase::_component_thru_poa_skel, 0},
      {"",0,0},
      {"_interface", &TAO_ServantBase::_interface_skel, 0},
      {"_non_existent", &TAO_ServantBase::_non_existent_thru_poa_skel, 0},
      {"_repository_id", &TAO_ServantBase::_repository_id_thru_poa_skel, 0},
      {"get_stock_excep", &POA_Quoter::AMI_Stock_FactoryHandler::get_stock_excep_skel, 0},
    };

  if (len <= MAX_WORD_LENGTH && len >= MIN_WORD_LENGTH)
    {
      unsigned int key = hash (str, len);

      if (key <= MAX_HASH_VALUE && key >= MIN_HASH_VALUE)
        {
          const char *s = wordlist[key].opname;

          if (*str == *s && !ACE_OS::strncmp (str + 1, s + 1, len - 1))
            return &wordlist[key];
        }
    }
  return 0;
}

static TAO_Quoter_AMI_Stock_FactoryHandler_Perfect_Hash_OpTable tao_Quoter_AMI_Stock_FactoryHandler_optable;

// TAO_IDL - Generated from
// be/be_visitor_interface/interface_ss.cpp:90

POA_Quoter::AMI_Stock_FactoryHandler::AMI_Stock_FactoryHandler (void)
  : TAO_ServantBase ()
{
  this->optable_ = &tao_Quoter_AMI_Stock_FactoryHandler_optable;
}

POA_Quoter::AMI_Stock_FactoryHandler::AMI_Stock_FactoryHandler (const AMI_Stock_FactoryHandler& rhs)
  : TAO_Abstract_ServantBase (rhs),
    TAO_ServantBase (rhs),
    ::POA_Messaging::ReplyHandler (rhs)
{
}

POA_Quoter::AMI_Stock_FactoryHandler::~AMI_Stock_FactoryHandler (void)
{
}

namespace POA_Quoter
{
  

  // TAO_IDL - Generated from
  // be/be_visitor_operation/upcall_command_ss.cpp:80

  class get_stock_AMI_Stock_FactoryHandler
    : public TAO::Upcall_Command
  {
  public:
    inline get_stock_AMI_Stock_FactoryHandler (
      POA_Quoter::AMI_Stock_FactoryHandler * servant,
      TAO_Operation_Details const * operation_details,
      TAO::Argument * const args[])
      : servant_ (servant)
        , operation_details_ (operation_details)
        , args_ (args)
    {
    }

    virtual void execute (void)
    {
      TAO::SArg_Traits< ::Quoter::Stock>::in_arg_type arg_1 =
        TAO::Portable_Server::get_in_arg< ::Quoter::Stock> (
          this->operation_details_,
          this->args_,
          1);
        
      this->servant_->get_stock (
        arg_1);
    }
  
  private:
    POA_Quoter::AMI_Stock_FactoryHandler * const servant_;
    TAO_Operation_Details const * const operation_details_;
    TAO::Argument * const * const args_;
  };
}

// TAO_IDL - Generated from
// be/be_visitor_operation/operation_ss.cpp:168

void POA_Quoter::AMI_Stock_FactoryHandler::get_stock_skel (
  TAO_ServerRequest & server_request,
  TAO::Portable_Server::Servant_Upcall *TAO_INTERCEPTOR (servant_upcall),
  TAO_ServantBase *servant)
{
#if TAO_HAS_INTERCEPTORS == 1
  static ::CORBA::TypeCode_ptr const exceptions[] = 
    {
      Quoter::_tc_Invalid_Stock_Symbol
    };
  static ::CORBA::ULong const nexceptions = 1;
#endif /* TAO_HAS_INTERCEPTORS */

  TAO::SArg_Traits< void>::ret_val retval;
  TAO::SArg_Traits< ::Quoter::Stock>::in_arg_val _tao_ami_return_val;

  TAO::Argument * const args[] =
    {
      &retval,
      &_tao_ami_return_val
    };
  
  static size_t const nargs = 2;

  POA_Quoter::AMI_Stock_FactoryHandler * const impl =
    dynamic_cast<POA_Quoter::AMI_Stock_FactoryHandler *> (servant);

  if (!impl)
    {
      throw ::CORBA::INTERNAL ();
    }

  get_stock_AMI_Stock_FactoryHandler command (
    impl,
    server_request.operation_details (),
    args);
  
  TAO::Upcall_Wrapper upcall_wrapper;
  upcall_wrapper.upcall (server_request
                         , args
                         , nargs
                         , command
#if TAO_HAS_INTERCEPTORS == 1
                         , servant_upcall
                         , exceptions
                         , nexceptions
#endif  /* TAO_HAS_INTERCEPTORS == 1 */
                         );
}


namespace POA_Quoter
{
  

  // TAO_IDL - Generated from
  // be/be_visitor_operation/upcall_command_ss.cpp:80

  class get_stock_excep_AMI_Stock_FactoryHandler
    : public TAO::Upcall_Command
  {
  public:
    inline get_stock_excep_AMI_Stock_FactoryHandler (
      POA_Quoter::AMI_Stock_FactoryHandler * servant,
      TAO_Operation_Details const * operation_details,
      TAO::Argument * const args[])
      : servant_ (servant)
        , operation_details_ (operation_details)
        , args_ (args)
    {
    }

    virtual void execute (void)
    {
      TAO::SArg_Traits< ::Messaging::ExceptionHolder>::in_arg_type arg_1 =
        TAO::Portable_Server::get_in_arg< ::Messaging::ExceptionHolder> (
          this->operation_details_,
          this->args_,
          1);
        
      

      static TAO::Exception_Data
      _tao_Quoter_AMI_Stock_FactoryHandler_get_stock_excep_exceptiondata [] = 
        {
          {
            "IDL:Quoter/Invalid_Stock_Symbol:1.0",
            Quoter::Invalid_Stock_Symbol::_alloc
#if TAO_HAS_INTERCEPTORS == 1
            , Quoter::_tc_Invalid_Stock_Symbol
#endif /* TAO_HAS_INTERCEPTORS */
          }
        };
      TAO::ExceptionHolder *tao_excepholder = 
        dynamic_cast<TAO::ExceptionHolder *> (arg_1);
      if (tao_excepholder != 0)
        {
          tao_excepholder->set_exception_data (_tao_Quoter_AMI_Stock_FactoryHandler_get_stock_excep_exceptiondata, 1);
        }
      
      this->servant_->get_stock_excep (
        arg_1);
    }
  
  private:
    POA_Quoter::AMI_Stock_FactoryHandler * const servant_;
    TAO_Operation_Details const * const operation_details_;
    TAO::Argument * const * const args_;
  };
}

// TAO_IDL - Generated from
// be/be_visitor_operation/operation_ss.cpp:168

void POA_Quoter::AMI_Stock_FactoryHandler::get_stock_excep_skel (
  TAO_ServerRequest & server_request,
  TAO::Portable_Server::Servant_Upcall *TAO_INTERCEPTOR (servant_upcall),
  TAO_ServantBase *servant)
{
#if TAO_HAS_INTERCEPTORS == 1
  static ::CORBA::TypeCode_ptr const exceptions[] = 
    {
      Quoter::_tc_Invalid_Stock_Symbol
    };
  static ::CORBA::ULong const nexceptions = 1;
#endif /* TAO_HAS_INTERCEPTORS */

  TAO::SArg_Traits< void>::ret_val retval;
  TAO::SArg_Traits< ::Messaging::ExceptionHolder>::in_arg_val _tao_excep_holder;

  TAO::Argument * const args[] =
    {
      &retval,
      &_tao_excep_holder
    };
  
  static size_t const nargs = 2;

  POA_Quoter::AMI_Stock_FactoryHandler * const impl =
    dynamic_cast<POA_Quoter::AMI_Stock_FactoryHandler *> (servant);

  if (!impl)
    {
      throw ::CORBA::INTERNAL ();
    }

  get_stock_excep_AMI_Stock_FactoryHandler command (
    impl,
    server_request.operation_details (),
    args);
  
  TAO::Upcall_Wrapper upcall_wrapper;
  upcall_wrapper.upcall (server_request
                         , args
                         , nargs
                         , command
#if TAO_HAS_INTERCEPTORS == 1
                         , servant_upcall
                         , exceptions
                         , nexceptions
#endif  /* TAO_HAS_INTERCEPTORS == 1 */
                         );
}



// TAO_IDL - Generated from
// be/be_visitor_interface/interface_ss.cpp:163



::CORBA::Boolean POA_Quoter::AMI_Stock_FactoryHandler::_is_a (const char* value)
{
  return
    (
      ACE_OS::strcmp (
          value,
          "IDL:omg.org/Messaging/ReplyHandler:1.0"
        ) == 0 ||
      ACE_OS::strcmp (
          value,
          "IDL:Quoter/AMI_Stock_FactoryHandler:1.0"
        ) == 0 ||
      !ACE_OS::strcmp (
          value,
          "IDL:omg.org/CORBA/Object:1.0"
        )
    );
}

const char* POA_Quoter::AMI_Stock_FactoryHandler::_interface_repository_id (void) const
{
  return "IDL:Quoter/AMI_Stock_FactoryHandler:1.0";
}

// TAO_IDL - Generated from
// be/be_visitor_interface/interface_ss.cpp:423

void POA_Quoter::AMI_Stock_FactoryHandler::_dispatch (
  TAO_ServerRequest & req,
  TAO::Portable_Server::Servant_Upcall* servant_upcall)
{
  this->synchronous_upcall_dispatch (req, servant_upcall, this);
}

// TAO_IDL - Generated from
// be/be_visitor_interface/interface_ss.cpp:370

Quoter::AMI_Stock_FactoryHandler *
POA_Quoter::AMI_Stock_FactoryHandler::_this (void)
{
  TAO_Stub *stub = this->_create_stub ();

  TAO_Stub_Auto_Ptr safe_stub (stub);
  ::CORBA::Object_ptr tmp = CORBA::Object_ptr ();

  ::CORBA::Boolean const _tao_opt_colloc =
    stub->servant_orb_var ()->orb_core ()->optimize_collocation_objects ();
  
  ACE_NEW_RETURN (
      tmp,
      ::CORBA::Object (stub, _tao_opt_colloc, this),
      0);
  
  ::CORBA::Object_var obj = tmp;
  (void) safe_stub.release ();

  typedef ::Quoter::AMI_Stock_FactoryHandler STUB_SCOPED_NAME;
  return
    TAO::Narrow_Utils<STUB_SCOPED_NAME>::unchecked_narrow (
        obj.in ());
}

// TAO_IDL - Generated from
// be/be_interface.cpp:1865

class TAO_Quoter_Stock_Perfect_Hash_OpTable
  : public TAO_Perfect_Hash_OpTable
{
private:
  unsigned int hash (const char *str, unsigned int len);

public:
  const TAO_operation_db_entry * lookup (const char *str, unsigned int len);
};

/* C++ code produced by gperf version 2.8 (ACE version) */
/* Command-line: /xusr/Repository/tao/src/ACE_wrappers/bin/ace_gperf -m -M -J -c -C -D -E -T -f 0 -F 0,0 -a -o -t -p -K opname -L C++ -Z TAO_Quoter_Stock_Perfect_Hash_OpTable -N lookup  */
unsigned int
TAO_Quoter_Stock_Perfect_Hash_OpTable::hash (const char *str, unsigned int len)
{
  static const unsigned char asso_values[] =
    {
     20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
     20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
     20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
     20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
     20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
     20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
     20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
     20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
     20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
     20, 20, 20, 20, 20,  0, 20,  2, 20, 20,
      5,  0, 20, 20, 20, 20, 20, 20,  0, 20,
     20, 20,  0, 20, 20, 20,  5, 20, 20, 20,
     20, 20, 20, 20, 20, 20, 20, 20,
    };
  return len + asso_values[static_cast<int>(str[len - 1])] + asso_values[static_cast<int>(str[0])];
}

const TAO_operation_db_entry *
TAO_Quoter_Stock_Perfect_Hash_OpTable::lookup (const char *str, unsigned int len)
{
  enum
    {
      TOTAL_KEYWORDS = 8,
      MIN_WORD_LENGTH = 5,
      MAX_WORD_LENGTH = 14,
      MIN_HASH_VALUE = 5,
      MAX_HASH_VALUE = 19,
      HASH_VALUE_RANGE = 15,
      DUPLICATES = 0,
      WORDLIST_SIZE = 13
    };

  static const TAO_operation_db_entry wordlist[] =
    {
      {"",0,0},{"",0,0},{"",0,0},{"",0,0},{"",0,0},
      {"price", &POA_Quoter::Stock::price_skel, 0},
      {"",0,0},
      {"_is_a", &TAO_ServantBase::_is_a_thru_poa_skel, 0},
      {"",0,0},{"",0,0},
      {"_interface", &TAO_ServantBase::_interface_skel, 0},
      {"_get_symbol", &POA_Quoter::Stock::_get_symbol_skel, 0},
      {"",0,0},{"",0,0},
      {"_get_full_name", &POA_Quoter::Stock::_get_full_name_skel, 0},
      {"_component", &TAO_ServantBase::_component_thru_poa_skel, 0},
      {"",0,0},{"",0,0},
      {"_non_existent", &TAO_ServantBase::_non_existent_thru_poa_skel, 0},
      {"_repository_id", &TAO_ServantBase::_repository_id_thru_poa_skel, 0},
    };

  if (len <= MAX_WORD_LENGTH && len >= MIN_WORD_LENGTH)
    {
      unsigned int key = hash (str, len);

      if (key <= MAX_HASH_VALUE && key >= MIN_HASH_VALUE)
        {
          const char *s = wordlist[key].opname;

          if (*str == *s && !ACE_OS::strncmp (str + 1, s + 1, len - 1))
            return &wordlist[key];
        }
    }
  return 0;
}

static TAO_Quoter_Stock_Perfect_Hash_OpTable tao_Quoter_Stock_optable;

// TAO_IDL - Generated from
// be/be_visitor_interface/interface_ss.cpp:90

POA_Quoter::Stock::Stock (void)
  : TAO_ServantBase ()
{
  this->optable_ = &tao_Quoter_Stock_optable;
}

POA_Quoter::Stock::Stock (const Stock& rhs)
  : TAO_Abstract_ServantBase (rhs),
    TAO_ServantBase (rhs)
{
}

POA_Quoter::Stock::~Stock (void)
{
}

namespace POA_Quoter
{
  

  // TAO_IDL - Generated from
  // be/be_visitor_operation/upcall_command_ss.cpp:80

  class _get_symbol_Stock
    : public TAO::Upcall_Command
  {
  public:
    inline _get_symbol_Stock (
      POA_Quoter::Stock * servant,
      TAO_Operation_Details const * operation_details,
      TAO::Argument * const args[])
      : servant_ (servant)
        , operation_details_ (operation_details)
        , args_ (args)
    {
    }

    virtual void execute (void)
    {
      TAO::SArg_Traits< char *>::ret_arg_type retval =
        TAO::Portable_Server::get_ret_arg< char *> (
          this->operation_details_,
          this->args_);
      
      retval =
        this->servant_->symbol ();
    }
  
  private:
    POA_Quoter::Stock * const servant_;
    TAO_Operation_Details const * const operation_details_;
    TAO::Argument * const * const args_;
  };
}

// TAO_IDL - Generated from
// be/be_visitor_operation/operation_ss.cpp:168

void POA_Quoter::Stock::_get_symbol_skel (
  TAO_ServerRequest & server_request,
  TAO::Portable_Server::Servant_Upcall *TAO_INTERCEPTOR (servant_upcall),
  TAO_ServantBase *servant)
{
#if TAO_HAS_INTERCEPTORS == 1
  static ::CORBA::TypeCode_ptr const * const exceptions = 0;
  static ::CORBA::ULong const nexceptions = 0;
#endif /* TAO_HAS_INTERCEPTORS */

  TAO::SArg_Traits< char *>::ret_val retval;

  TAO::Argument * const args[] =
    {
      &retval
    };
  
  static size_t const nargs = 1;

  POA_Quoter::Stock * const impl =
    dynamic_cast<POA_Quoter::Stock *> (servant);

  if (!impl)
    {
      throw ::CORBA::INTERNAL ();
    }

  _get_symbol_Stock command (
    impl,
    server_request.operation_details (),
    args);
  
  TAO::Upcall_Wrapper upcall_wrapper;
  upcall_wrapper.upcall (server_request
                         , args
                         , nargs
                         , command
#if TAO_HAS_INTERCEPTORS == 1
                         , servant_upcall
                         , exceptions
                         , nexceptions
#endif  /* TAO_HAS_INTERCEPTORS == 1 */
                         );
}


namespace POA_Quoter
{
  

  // TAO_IDL - Generated from
  // be/be_visitor_operation/upcall_command_ss.cpp:80

  class _get_full_name_Stock
    : public TAO::Upcall_Command
  {
  public:
    inline _get_full_name_Stock (
      POA_Quoter::Stock * servant,
      TAO_Operation_Details const * operation_details,
      TAO::Argument * const args[])
      : servant_ (servant)
        , operation_details_ (operation_details)
        , args_ (args)
    {
    }

    virtual void execute (void)
    {
      TAO::SArg_Traits< char *>::ret_arg_type retval =
        TAO::Portable_Server::get_ret_arg< char *> (
          this->operation_details_,
          this->args_);
      
      retval =
        this->servant_->full_name ();
    }
  
  private:
    POA_Quoter::Stock * const servant_;
    TAO_Operation_Details const * const operation_details_;
    TAO::Argument * const * const args_;
  };
}

// TAO_IDL - Generated from
// be/be_visitor_operation/operation_ss.cpp:168

void POA_Quoter::Stock::_get_full_name_skel (
  TAO_ServerRequest & server_request,
  TAO::Portable_Server::Servant_Upcall *TAO_INTERCEPTOR (servant_upcall),
  TAO_ServantBase *servant)
{
#if TAO_HAS_INTERCEPTORS == 1
  static ::CORBA::TypeCode_ptr const * const exceptions = 0;
  static ::CORBA::ULong const nexceptions = 0;
#endif /* TAO_HAS_INTERCEPTORS */

  TAO::SArg_Traits< char *>::ret_val retval;

  TAO::Argument * const args[] =
    {
      &retval
    };
  
  static size_t const nargs = 1;

  POA_Quoter::Stock * const impl =
    dynamic_cast<POA_Quoter::Stock *> (servant);

  if (!impl)
    {
      throw ::CORBA::INTERNAL ();
    }

  _get_full_name_Stock command (
    impl,
    server_request.operation_details (),
    args);
  
  TAO::Upcall_Wrapper upcall_wrapper;
  upcall_wrapper.upcall (server_request
                         , args
                         , nargs
                         , command
#if TAO_HAS_INTERCEPTORS == 1
                         , servant_upcall
                         , exceptions
                         , nexceptions
#endif  /* TAO_HAS_INTERCEPTORS == 1 */
                         );
}


namespace POA_Quoter
{
  

  // TAO_IDL - Generated from
  // be/be_visitor_operation/upcall_command_ss.cpp:80

  class price_Stock
    : public TAO::Upcall_Command
  {
  public:
    inline price_Stock (
      POA_Quoter::Stock * servant,
      TAO_Operation_Details const * operation_details,
      TAO::Argument * const args[])
      : servant_ (servant)
        , operation_details_ (operation_details)
        , args_ (args)
    {
    }

    virtual void execute (void)
    {
      TAO::SArg_Traits< ::CORBA::Double>::ret_arg_type retval =
        TAO::Portable_Server::get_ret_arg< ::CORBA::Double> (
          this->operation_details_,
          this->args_);
      
      retval =
        this->servant_->price ();
    }
  
  private:
    POA_Quoter::Stock * const servant_;
    TAO_Operation_Details const * const operation_details_;
    TAO::Argument * const * const args_;
  };
}

// TAO_IDL - Generated from
// be/be_visitor_operation/operation_ss.cpp:168

void POA_Quoter::Stock::price_skel (
  TAO_ServerRequest & server_request,
  TAO::Portable_Server::Servant_Upcall *TAO_INTERCEPTOR (servant_upcall),
  TAO_ServantBase *servant)
{
#if TAO_HAS_INTERCEPTORS == 1
  static ::CORBA::TypeCode_ptr const * const exceptions = 0;
  static ::CORBA::ULong const nexceptions = 0;
#endif /* TAO_HAS_INTERCEPTORS */

  TAO::SArg_Traits< ::CORBA::Double>::ret_val retval;

  TAO::Argument * const args[] =
    {
      &retval
    };
  
  static size_t const nargs = 1;

  POA_Quoter::Stock * const impl =
    dynamic_cast<POA_Quoter::Stock *> (servant);

  if (!impl)
    {
      throw ::CORBA::INTERNAL ();
    }

  price_Stock command (
    impl,
    server_request.operation_details (),
    args);
  
  TAO::Upcall_Wrapper upcall_wrapper;
  upcall_wrapper.upcall (server_request
                         , args
                         , nargs
                         , command
#if TAO_HAS_INTERCEPTORS == 1
                         , servant_upcall
                         , exceptions
                         , nexceptions
#endif  /* TAO_HAS_INTERCEPTORS == 1 */
                         );
}



// TAO_IDL - Generated from
// be/be_visitor_interface/interface_ss.cpp:163



::CORBA::Boolean POA_Quoter::Stock::_is_a (const char* value)
{
  return
    (
      ACE_OS::strcmp (
          value,
          "IDL:Quoter/Stock:1.0"
        ) == 0 ||
      !ACE_OS::strcmp (
          value,
          "IDL:omg.org/CORBA/Object:1.0"
        )
    );
}

const char* POA_Quoter::Stock::_interface_repository_id (void) const
{
  return "IDL:Quoter/Stock:1.0";
}

// TAO_IDL - Generated from
// be/be_visitor_interface/interface_ss.cpp:423

void POA_Quoter::Stock::_dispatch (
  TAO_ServerRequest & req,
  TAO::Portable_Server::Servant_Upcall* servant_upcall)
{
  this->synchronous_upcall_dispatch (req, servant_upcall, this);
}

// TAO_IDL - Generated from
// be/be_visitor_interface/interface_ss.cpp:370

Quoter::Stock *
POA_Quoter::Stock::_this (void)
{
  TAO_Stub *stub = this->_create_stub ();

  TAO_Stub_Auto_Ptr safe_stub (stub);
  ::CORBA::Object_ptr tmp = CORBA::Object_ptr ();

  ::CORBA::Boolean const _tao_opt_colloc =
    stub->servant_orb_var ()->orb_core ()->optimize_collocation_objects ();
  
  ACE_NEW_RETURN (
      tmp,
      ::CORBA::Object (stub, _tao_opt_colloc, this),
      0);
  
  ::CORBA::Object_var obj = tmp;
  (void) safe_stub.release ();

  typedef ::Quoter::Stock STUB_SCOPED_NAME;
  return
    TAO::Narrow_Utils<STUB_SCOPED_NAME>::unchecked_narrow (
        obj.in ());
}

// TAO_IDL - Generated from
// be/be_interface.cpp:1865

class TAO_Quoter_AMI_StockHandler_Perfect_Hash_OpTable
  : public TAO_Perfect_Hash_OpTable
{
private:
  unsigned int hash (const char *str, unsigned int len);

public:
  const TAO_operation_db_entry * lookup (const char *str, unsigned int len);
};

/* C++ code produced by gperf version 2.8 (ACE version) */
/* Command-line: /xusr/Repository/tao/src/ACE_wrappers/bin/ace_gperf -m -M -J -c -C -D -E -T -f 0 -F 0,0 -a -o -t -p -K opname -L C++ -Z TAO_Quoter_AMI_StockHandler_Perfect_Hash_OpTable -N lookup  */
unsigned int
TAO_Quoter_AMI_StockHandler_Perfect_Hash_OpTable::hash (const char *str, unsigned int len)
{
  static const unsigned char asso_values[] =
    {
     26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
     26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
     26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
     26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
     26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
     26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
     26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
     26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
     26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
     26, 26, 26, 26, 26,  0, 26, 15, 26, 26,
      0,  0, 26,  0, 26, 26, 26, 26, 15, 26,
     26, 26,  0, 26, 26, 26,  5, 26, 26, 26,
     26, 26, 26, 26, 26, 26, 26, 26,
    };
  return len + asso_values[static_cast<int>(str[len - 1])] + asso_values[static_cast<int>(str[0])];
}

const TAO_operation_db_entry *
TAO_Quoter_AMI_StockHandler_Perfect_Hash_OpTable::lookup (const char *str, unsigned int len)
{
  enum
    {
      TOTAL_KEYWORDS = 11,
      MIN_WORD_LENGTH = 5,
      MAX_WORD_LENGTH = 19,
      MIN_HASH_VALUE = 5,
      MAX_HASH_VALUE = 25,
      HASH_VALUE_RANGE = 21,
      DUPLICATES = 0,
      WORDLIST_SIZE = 16
    };

  static const TAO_operation_db_entry wordlist[] =
    {
      {"",0,0},{"",0,0},{"",0,0},{"",0,0},{"",0,0},
      {"price", &POA_Quoter::AMI_StockHandler::price_skel, 0},
      {"",0,0},{"",0,0},{"",0,0},{"",0,0},
      {"_interface", &TAO_ServantBase::_interface_skel, 0},
      {"price_excep", &POA_Quoter::AMI_StockHandler::price_excep_skel, 0},
      {"",0,0},
      {"get_full_name", &POA_Quoter::AMI_StockHandler::get_full_name_skel, 0},
      {"_repository_id", &TAO_ServantBase::_repository_id_thru_poa_skel, 0},
      {"_component", &TAO_ServantBase::_component_thru_poa_skel, 0},
      {"get_symbol_excep", &POA_Quoter::AMI_StockHandler::get_symbol_excep_skel, 0},
      {"",0,0},
      {"_non_existent", &TAO_ServantBase::_non_existent_thru_poa_skel, 0},
      {"get_full_name_excep", &POA_Quoter::AMI_StockHandler::get_full_name_excep_skel, 0},
      {"_is_a", &TAO_ServantBase::_is_a_thru_poa_skel, 0},
      {"",0,0},{"",0,0},{"",0,0},{"",0,0},
      {"get_symbol", &POA_Quoter::AMI_StockHandler::get_symbol_skel, 0},
    };

  if (len <= MAX_WORD_LENGTH && len >= MIN_WORD_LENGTH)
    {
      unsigned int key = hash (str, len);

      if (key <= MAX_HASH_VALUE && key >= MIN_HASH_VALUE)
        {
          const char *s = wordlist[key].opname;

          if (*str == *s && !ACE_OS::strncmp (str + 1, s + 1, len - 1))
            return &wordlist[key];
        }
    }
  return 0;
}

static TAO_Quoter_AMI_StockHandler_Perfect_Hash_OpTable tao_Quoter_AMI_StockHandler_optable;

// TAO_IDL - Generated from
// be/be_visitor_interface/interface_ss.cpp:90

POA_Quoter::AMI_StockHandler::AMI_StockHandler (void)
  : TAO_ServantBase ()
{
  this->optable_ = &tao_Quoter_AMI_StockHandler_optable;
}

POA_Quoter::AMI_StockHandler::AMI_StockHandler (const AMI_StockHandler& rhs)
  : TAO_Abstract_ServantBase (rhs),
    TAO_ServantBase (rhs),
    ::POA_Messaging::ReplyHandler (rhs)
{
}

POA_Quoter::AMI_StockHandler::~AMI_StockHandler (void)
{
}

namespace POA_Quoter
{
  

  // TAO_IDL - Generated from
  // be/be_visitor_operation/upcall_command_ss.cpp:80

  class get_symbol_AMI_StockHandler
    : public TAO::Upcall_Command
  {
  public:
    inline get_symbol_AMI_StockHandler (
      POA_Quoter::AMI_StockHandler * servant,
      TAO_Operation_Details const * operation_details,
      TAO::Argument * const args[])
      : servant_ (servant)
        , operation_details_ (operation_details)
        , args_ (args)
    {
    }

    virtual void execute (void)
    {
      TAO::SArg_Traits< char *>::in_arg_type arg_1 =
        TAO::Portable_Server::get_in_arg< char *> (
          this->operation_details_,
          this->args_,
          1);
        
      this->servant_->get_symbol (
        arg_1);
    }
  
  private:
    POA_Quoter::AMI_StockHandler * const servant_;
    TAO_Operation_Details const * const operation_details_;
    TAO::Argument * const * const args_;
  };
}

// TAO_IDL - Generated from
// be/be_visitor_operation/operation_ss.cpp:168

void POA_Quoter::AMI_StockHandler::get_symbol_skel (
  TAO_ServerRequest & server_request,
  TAO::Portable_Server::Servant_Upcall *TAO_INTERCEPTOR (servant_upcall),
  TAO_ServantBase *servant)
{
#if TAO_HAS_INTERCEPTORS == 1
  static ::CORBA::TypeCode_ptr const * const exceptions = 0;
  static ::CORBA::ULong const nexceptions = 0;
#endif /* TAO_HAS_INTERCEPTORS */

  TAO::SArg_Traits< void>::ret_val retval;
  TAO::SArg_Traits< char *>::in_arg_val _tao_ami_return_val;

  TAO::Argument * const args[] =
    {
      &retval,
      &_tao_ami_return_val
    };
  
  static size_t const nargs = 2;

  POA_Quoter::AMI_StockHandler * const impl =
    dynamic_cast<POA_Quoter::AMI_StockHandler *> (servant);

  if (!impl)
    {
      throw ::CORBA::INTERNAL ();
    }

  get_symbol_AMI_StockHandler command (
    impl,
    server_request.operation_details (),
    args);
  
  TAO::Upcall_Wrapper upcall_wrapper;
  upcall_wrapper.upcall (server_request
                         , args
                         , nargs
                         , command
#if TAO_HAS_INTERCEPTORS == 1
                         , servant_upcall
                         , exceptions
                         , nexceptions
#endif  /* TAO_HAS_INTERCEPTORS == 1 */
                         );
}


namespace POA_Quoter
{
  

  // TAO_IDL - Generated from
  // be/be_visitor_operation/upcall_command_ss.cpp:80

  class get_symbol_excep_AMI_StockHandler
    : public TAO::Upcall_Command
  {
  public:
    inline get_symbol_excep_AMI_StockHandler (
      POA_Quoter::AMI_StockHandler * servant,
      TAO_Operation_Details const * operation_details,
      TAO::Argument * const args[])
      : servant_ (servant)
        , operation_details_ (operation_details)
        , args_ (args)
    {
    }

    virtual void execute (void)
    {
      TAO::SArg_Traits< ::Messaging::ExceptionHolder>::in_arg_type arg_1 =
        TAO::Portable_Server::get_in_arg< ::Messaging::ExceptionHolder> (
          this->operation_details_,
          this->args_,
          1);
        
      this->servant_->get_symbol_excep (
        arg_1);
    }
  
  private:
    POA_Quoter::AMI_StockHandler * const servant_;
    TAO_Operation_Details const * const operation_details_;
    TAO::Argument * const * const args_;
  };
}

// TAO_IDL - Generated from
// be/be_visitor_operation/operation_ss.cpp:168

void POA_Quoter::AMI_StockHandler::get_symbol_excep_skel (
  TAO_ServerRequest & server_request,
  TAO::Portable_Server::Servant_Upcall *TAO_INTERCEPTOR (servant_upcall),
  TAO_ServantBase *servant)
{
#if TAO_HAS_INTERCEPTORS == 1
  static ::CORBA::TypeCode_ptr const * const exceptions = 0;
  static ::CORBA::ULong const nexceptions = 0;
#endif /* TAO_HAS_INTERCEPTORS */

  TAO::SArg_Traits< void>::ret_val retval;
  TAO::SArg_Traits< ::Messaging::ExceptionHolder>::in_arg_val _tao_excep_holder;

  TAO::Argument * const args[] =
    {
      &retval,
      &_tao_excep_holder
    };
  
  static size_t const nargs = 2;

  POA_Quoter::AMI_StockHandler * const impl =
    dynamic_cast<POA_Quoter::AMI_StockHandler *> (servant);

  if (!impl)
    {
      throw ::CORBA::INTERNAL ();
    }

  get_symbol_excep_AMI_StockHandler command (
    impl,
    server_request.operation_details (),
    args);
  
  TAO::Upcall_Wrapper upcall_wrapper;
  upcall_wrapper.upcall (server_request
                         , args
                         , nargs
                         , command
#if TAO_HAS_INTERCEPTORS == 1
                         , servant_upcall
                         , exceptions
                         , nexceptions
#endif  /* TAO_HAS_INTERCEPTORS == 1 */
                         );
}


namespace POA_Quoter
{
  

  // TAO_IDL - Generated from
  // be/be_visitor_operation/upcall_command_ss.cpp:80

  class get_full_name_AMI_StockHandler
    : public TAO::Upcall_Command
  {
  public:
    inline get_full_name_AMI_StockHandler (
      POA_Quoter::AMI_StockHandler * servant,
      TAO_Operation_Details const * operation_details,
      TAO::Argument * const args[])
      : servant_ (servant)
        , operation_details_ (operation_details)
        , args_ (args)
    {
    }

    virtual void execute (void)
    {
      TAO::SArg_Traits< char *>::in_arg_type arg_1 =
        TAO::Portable_Server::get_in_arg< char *> (
          this->operation_details_,
          this->args_,
          1);
        
      this->servant_->get_full_name (
        arg_1);
    }
  
  private:
    POA_Quoter::AMI_StockHandler * const servant_;
    TAO_Operation_Details const * const operation_details_;
    TAO::Argument * const * const args_;
  };
}

// TAO_IDL - Generated from
// be/be_visitor_operation/operation_ss.cpp:168

void POA_Quoter::AMI_StockHandler::get_full_name_skel (
  TAO_ServerRequest & server_request,
  TAO::Portable_Server::Servant_Upcall *TAO_INTERCEPTOR (servant_upcall),
  TAO_ServantBase *servant)
{
#if TAO_HAS_INTERCEPTORS == 1
  static ::CORBA::TypeCode_ptr const * const exceptions = 0;
  static ::CORBA::ULong const nexceptions = 0;
#endif /* TAO_HAS_INTERCEPTORS */

  TAO::SArg_Traits< void>::ret_val retval;
  TAO::SArg_Traits< char *>::in_arg_val _tao_ami_return_val;

  TAO::Argument * const args[] =
    {
      &retval,
      &_tao_ami_return_val
    };
  
  static size_t const nargs = 2;

  POA_Quoter::AMI_StockHandler * const impl =
    dynamic_cast<POA_Quoter::AMI_StockHandler *> (servant);

  if (!impl)
    {
      throw ::CORBA::INTERNAL ();
    }

  get_full_name_AMI_StockHandler command (
    impl,
    server_request.operation_details (),
    args);
  
  TAO::Upcall_Wrapper upcall_wrapper;
  upcall_wrapper.upcall (server_request
                         , args
                         , nargs
                         , command
#if TAO_HAS_INTERCEPTORS == 1
                         , servant_upcall
                         , exceptions
                         , nexceptions
#endif  /* TAO_HAS_INTERCEPTORS == 1 */
                         );
}


namespace POA_Quoter
{
  

  // TAO_IDL - Generated from
  // be/be_visitor_operation/upcall_command_ss.cpp:80

  class get_full_name_excep_AMI_StockHandler
    : public TAO::Upcall_Command
  {
  public:
    inline get_full_name_excep_AMI_StockHandler (
      POA_Quoter::AMI_StockHandler * servant,
      TAO_Operation_Details const * operation_details,
      TAO::Argument * const args[])
      : servant_ (servant)
        , operation_details_ (operation_details)
        , args_ (args)
    {
    }

    virtual void execute (void)
    {
      TAO::SArg_Traits< ::Messaging::ExceptionHolder>::in_arg_type arg_1 =
        TAO::Portable_Server::get_in_arg< ::Messaging::ExceptionHolder> (
          this->operation_details_,
          this->args_,
          1);
        
      this->servant_->get_full_name_excep (
        arg_1);
    }
  
  private:
    POA_Quoter::AMI_StockHandler * const servant_;
    TAO_Operation_Details const * const operation_details_;
    TAO::Argument * const * const args_;
  };
}

// TAO_IDL - Generated from
// be/be_visitor_operation/operation_ss.cpp:168

void POA_Quoter::AMI_StockHandler::get_full_name_excep_skel (
  TAO_ServerRequest & server_request,
  TAO::Portable_Server::Servant_Upcall *TAO_INTERCEPTOR (servant_upcall),
  TAO_ServantBase *servant)
{
#if TAO_HAS_INTERCEPTORS == 1
  static ::CORBA::TypeCode_ptr const * const exceptions = 0;
  static ::CORBA::ULong const nexceptions = 0;
#endif /* TAO_HAS_INTERCEPTORS */

  TAO::SArg_Traits< void>::ret_val retval;
  TAO::SArg_Traits< ::Messaging::ExceptionHolder>::in_arg_val _tao_excep_holder;

  TAO::Argument * const args[] =
    {
      &retval,
      &_tao_excep_holder
    };
  
  static size_t const nargs = 2;

  POA_Quoter::AMI_StockHandler * const impl =
    dynamic_cast<POA_Quoter::AMI_StockHandler *> (servant);

  if (!impl)
    {
      throw ::CORBA::INTERNAL ();
    }

  get_full_name_excep_AMI_StockHandler command (
    impl,
    server_request.operation_details (),
    args);
  
  TAO::Upcall_Wrapper upcall_wrapper;
  upcall_wrapper.upcall (server_request
                         , args
                         , nargs
                         , command
#if TAO_HAS_INTERCEPTORS == 1
                         , servant_upcall
                         , exceptions
                         , nexceptions
#endif  /* TAO_HAS_INTERCEPTORS == 1 */
                         );
}


namespace POA_Quoter
{
  

  // TAO_IDL - Generated from
  // be/be_visitor_operation/upcall_command_ss.cpp:80

  class price_AMI_StockHandler
    : public TAO::Upcall_Command
  {
  public:
    inline price_AMI_StockHandler (
      POA_Quoter::AMI_StockHandler * servant,
      TAO_Operation_Details const * operation_details,
      TAO::Argument * const args[])
      : servant_ (servant)
        , operation_details_ (operation_details)
        , args_ (args)
    {
    }

    virtual void execute (void)
    {
      TAO::SArg_Traits< ::CORBA::Double>::in_arg_type arg_1 =
        TAO::Portable_Server::get_in_arg< ::CORBA::Double> (
          this->operation_details_,
          this->args_,
          1);
        
      this->servant_->price (
        arg_1);
    }
  
  private:
    POA_Quoter::AMI_StockHandler * const servant_;
    TAO_Operation_Details const * const operation_details_;
    TAO::Argument * const * const args_;
  };
}

// TAO_IDL - Generated from
// be/be_visitor_operation/operation_ss.cpp:168

void POA_Quoter::AMI_StockHandler::price_skel (
  TAO_ServerRequest & server_request,
  TAO::Portable_Server::Servant_Upcall *TAO_INTERCEPTOR (servant_upcall),
  TAO_ServantBase *servant)
{
#if TAO_HAS_INTERCEPTORS == 1
  static ::CORBA::TypeCode_ptr const * const exceptions = 0;
  static ::CORBA::ULong const nexceptions = 0;
#endif /* TAO_HAS_INTERCEPTORS */

  TAO::SArg_Traits< void>::ret_val retval;
  TAO::SArg_Traits< ::CORBA::Double>::in_arg_val _tao_ami_return_val;

  TAO::Argument * const args[] =
    {
      &retval,
      &_tao_ami_return_val
    };
  
  static size_t const nargs = 2;

  POA_Quoter::AMI_StockHandler * const impl =
    dynamic_cast<POA_Quoter::AMI_StockHandler *> (servant);

  if (!impl)
    {
      throw ::CORBA::INTERNAL ();
    }

  price_AMI_StockHandler command (
    impl,
    server_request.operation_details (),
    args);
  
  TAO::Upcall_Wrapper upcall_wrapper;
  upcall_wrapper.upcall (server_request
                         , args
                         , nargs
                         , command
#if TAO_HAS_INTERCEPTORS == 1
                         , servant_upcall
                         , exceptions
                         , nexceptions
#endif  /* TAO_HAS_INTERCEPTORS == 1 */
                         );
}


namespace POA_Quoter
{
  

  // TAO_IDL - Generated from
  // be/be_visitor_operation/upcall_command_ss.cpp:80

  class price_excep_AMI_StockHandler
    : public TAO::Upcall_Command
  {
  public:
    inline price_excep_AMI_StockHandler (
      POA_Quoter::AMI_StockHandler * servant,
      TAO_Operation_Details const * operation_details,
      TAO::Argument * const args[])
      : servant_ (servant)
        , operation_details_ (operation_details)
        , args_ (args)
    {
    }

    virtual void execute (void)
    {
      TAO::SArg_Traits< ::Messaging::ExceptionHolder>::in_arg_type arg_1 =
        TAO::Portable_Server::get_in_arg< ::Messaging::ExceptionHolder> (
          this->operation_details_,
          this->args_,
          1);
        
      this->servant_->price_excep (
        arg_1);
    }
  
  private:
    POA_Quoter::AMI_StockHandler * const servant_;
    TAO_Operation_Details const * const operation_details_;
    TAO::Argument * const * const args_;
  };
}

// TAO_IDL - Generated from
// be/be_visitor_operation/operation_ss.cpp:168

void POA_Quoter::AMI_StockHandler::price_excep_skel (
  TAO_ServerRequest & server_request,
  TAO::Portable_Server::Servant_Upcall *TAO_INTERCEPTOR (servant_upcall),
  TAO_ServantBase *servant)
{
#if TAO_HAS_INTERCEPTORS == 1
  static ::CORBA::TypeCode_ptr const * const exceptions = 0;
  static ::CORBA::ULong const nexceptions = 0;
#endif /* TAO_HAS_INTERCEPTORS */

  TAO::SArg_Traits< void>::ret_val retval;
  TAO::SArg_Traits< ::Messaging::ExceptionHolder>::in_arg_val _tao_excep_holder;

  TAO::Argument * const args[] =
    {
      &retval,
      &_tao_excep_holder
    };
  
  static size_t const nargs = 2;

  POA_Quoter::AMI_StockHandler * const impl =
    dynamic_cast<POA_Quoter::AMI_StockHandler *> (servant);

  if (!impl)
    {
      throw ::CORBA::INTERNAL ();
    }

  price_excep_AMI_StockHandler command (
    impl,
    server_request.operation_details (),
    args);
  
  TAO::Upcall_Wrapper upcall_wrapper;
  upcall_wrapper.upcall (server_request
                         , args
                         , nargs
                         , command
#if TAO_HAS_INTERCEPTORS == 1
                         , servant_upcall
                         , exceptions
                         , nexceptions
#endif  /* TAO_HAS_INTERCEPTORS == 1 */
                         );
}



// TAO_IDL - Generated from
// be/be_visitor_interface/interface_ss.cpp:163



::CORBA::Boolean POA_Quoter::AMI_StockHandler::_is_a (const char* value)
{
  return
    (
      ACE_OS::strcmp (
          value,
          "IDL:omg.org/Messaging/ReplyHandler:1.0"
        ) == 0 ||
      ACE_OS::strcmp (
          value,
          "IDL:Quoter/AMI_StockHandler:1.0"
        ) == 0 ||
      !ACE_OS::strcmp (
          value,
          "IDL:omg.org/CORBA/Object:1.0"
        )
    );
}

const char* POA_Quoter::AMI_StockHandler::_interface_repository_id (void) const
{
  return "IDL:Quoter/AMI_StockHandler:1.0";
}

// TAO_IDL - Generated from
// be/be_visitor_interface/interface_ss.cpp:423

void POA_Quoter::AMI_StockHandler::_dispatch (
  TAO_ServerRequest & req,
  TAO::Portable_Server::Servant_Upcall* servant_upcall)
{
  this->synchronous_upcall_dispatch (req, servant_upcall, this);
}

// TAO_IDL - Generated from
// be/be_visitor_interface/interface_ss.cpp:370

Quoter::AMI_StockHandler *
POA_Quoter::AMI_StockHandler::_this (void)
{
  TAO_Stub *stub = this->_create_stub ();

  TAO_Stub_Auto_Ptr safe_stub (stub);
  ::CORBA::Object_ptr tmp = CORBA::Object_ptr ();

  ::CORBA::Boolean const _tao_opt_colloc =
    stub->servant_orb_var ()->orb_core ()->optimize_collocation_objects ();
  
  ACE_NEW_RETURN (
      tmp,
      ::CORBA::Object (stub, _tao_opt_colloc, this),
      0);
  
  ::CORBA::Object_var obj = tmp;
  (void) safe_stub.release ();

  typedef ::Quoter::AMI_StockHandler STUB_SCOPED_NAME;
  return
    TAO::Narrow_Utils<STUB_SCOPED_NAME>::unchecked_narrow (
        obj.in ());
}

// TAO_IDL - Generated from
// be/be_interface.cpp:1865

class TAO_Quoter_Single_Query_Stock_Perfect_Hash_OpTable
  : public TAO_Perfect_Hash_OpTable
{
private:
  unsigned int hash (const char *str, unsigned int len);

public:
  const TAO_operation_db_entry * lookup (const char *str, unsigned int len);
};

/* C++ code produced by gperf version 2.8 (ACE version) */
/* Command-line: /xusr/Repository/tao/src/ACE_wrappers/bin/ace_gperf -m -M -J -c -C -D -E -T -f 0 -F 0,0 -a -o -t -p -K opname -L C++ -Z TAO_Quoter_Single_Query_Stock_Perfect_Hash_OpTable -N lookup  */
unsigned int
TAO_Quoter_Single_Query_Stock_Perfect_Hash_OpTable::hash (const char *str, unsigned int len)
{
  static const unsigned char asso_values[] =
    {
     25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
     25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
     25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
     25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
     25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
     25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
     25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
     25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
     25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
     25, 25, 25, 25, 25,  0, 25, 15, 25, 25,
     10,  0, 25,  0, 25, 25, 25, 25,  0, 25,
     25, 25,  0, 25, 25,  0,  5, 25, 25, 25,
     25, 25, 25, 25, 25, 25, 25, 25,
    };
  return len + asso_values[static_cast<int>(str[len - 1])] + asso_values[static_cast<int>(str[0])];
}

const TAO_operation_db_entry *
TAO_Quoter_Single_Query_Stock_Perfect_Hash_OpTable::lookup (const char *str, unsigned int len)
{
  enum
    {
      TOTAL_KEYWORDS = 9,
      MIN_WORD_LENGTH = 5,
      MAX_WORD_LENGTH = 19,
      MIN_HASH_VALUE = 5,
      MAX_HASH_VALUE = 24,
      HASH_VALUE_RANGE = 20,
      DUPLICATES = 0,
      WORDLIST_SIZE = 14
    };

  static const TAO_operation_db_entry wordlist[] =
    {
      {"",0,0},{"",0,0},{"",0,0},{"",0,0},{"",0,0},
      {"price", &POA_Quoter::Stock::price_skel, 0},
      {"",0,0},{"",0,0},{"",0,0},{"",0,0},
      {"_interface", &TAO_ServantBase::_interface_skel, 0},
      {"_get_symbol", &POA_Quoter::Stock::_get_symbol_skel, 0},
      {"",0,0},{"",0,0},
      {"_get_full_name", &POA_Quoter::Stock::_get_full_name_skel, 0},
      {"_component", &TAO_ServantBase::_component_thru_poa_skel, 0},
      {"",0,0},{"",0,0},
      {"_non_existent", &TAO_ServantBase::_non_existent_thru_poa_skel, 0},
      {"get_price_and_names", &POA_Quoter::Single_Query_Stock::get_price_and_names_skel, 0},
      {"_is_a", &TAO_ServantBase::_is_a_thru_poa_skel, 0},
      {"",0,0},{"",0,0},{"",0,0},
      {"_repository_id", &TAO_ServantBase::_repository_id_thru_poa_skel, 0},
    };

  if (len <= MAX_WORD_LENGTH && len >= MIN_WORD_LENGTH)
    {
      unsigned int key = hash (str, len);

      if (key <= MAX_HASH_VALUE && key >= MIN_HASH_VALUE)
        {
          const char *s = wordlist[key].opname;

          if (*str == *s && !ACE_OS::strncmp (str + 1, s + 1, len - 1))
            return &wordlist[key];
        }
    }
  return 0;
}

static TAO_Quoter_Single_Query_Stock_Perfect_Hash_OpTable tao_Quoter_Single_Query_Stock_optable;

// TAO_IDL - Generated from
// be/be_visitor_interface/interface_ss.cpp:90

POA_Quoter::Single_Query_Stock::Single_Query_Stock (void)
  : TAO_ServantBase ()
{
  this->optable_ = &tao_Quoter_Single_Query_Stock_optable;
}

POA_Quoter::Single_Query_Stock::Single_Query_Stock (const Single_Query_Stock& rhs)
  : TAO_Abstract_ServantBase (rhs),
    TAO_ServantBase (rhs),
    POA_Quoter::Stock (rhs)
{
}

POA_Quoter::Single_Query_Stock::~Single_Query_Stock (void)
{
}

namespace POA_Quoter
{
  

  // TAO_IDL - Generated from
  // be/be_visitor_operation/upcall_command_ss.cpp:80

  class get_price_and_names_Single_Query_Stock
    : public TAO::Upcall_Command
  {
  public:
    inline get_price_and_names_Single_Query_Stock (
      POA_Quoter::Single_Query_Stock * servant,
      TAO_Operation_Details const * operation_details,
      TAO::Argument * const args[])
      : servant_ (servant)
        , operation_details_ (operation_details)
        , args_ (args)
    {
    }

    virtual void execute (void)
    {
      TAO::SArg_Traits< ::CORBA::Double>::ret_arg_type retval =
        TAO::Portable_Server::get_ret_arg< ::CORBA::Double> (
          this->operation_details_,
          this->args_);
      
      TAO::SArg_Traits< char *>::out_arg_type arg_1 =
        TAO::Portable_Server::get_out_arg< char *> (
          this->operation_details_,
          this->args_,
          1);
        
      TAO::SArg_Traits< char *>::out_arg_type arg_2 =
        TAO::Portable_Server::get_out_arg< char *> (
          this->operation_details_,
          this->args_,
          2);
        
      retval =
        this->servant_->get_price_and_names (
          arg_1
          , arg_2);
    }
  
  private:
    POA_Quoter::Single_Query_Stock * const servant_;
    TAO_Operation_Details const * const operation_details_;
    TAO::Argument * const * const args_;
  };
}

// TAO_IDL - Generated from
// be/be_visitor_operation/operation_ss.cpp:168

void POA_Quoter::Single_Query_Stock::get_price_and_names_skel (
  TAO_ServerRequest & server_request,
  TAO::Portable_Server::Servant_Upcall *TAO_INTERCEPTOR (servant_upcall),
  TAO_ServantBase *servant)
{
#if TAO_HAS_INTERCEPTORS == 1
  static ::CORBA::TypeCode_ptr const * const exceptions = 0;
  static ::CORBA::ULong const nexceptions = 0;
#endif /* TAO_HAS_INTERCEPTORS */

  TAO::SArg_Traits< ::CORBA::Double>::ret_val retval;
  TAO::SArg_Traits< char *>::out_arg_val _tao_symbol;
  TAO::SArg_Traits< char *>::out_arg_val _tao_full_name;

  TAO::Argument * const args[] =
    {
      &retval,
      &_tao_symbol,
      &_tao_full_name
    };
  
  static size_t const nargs = 3;

  POA_Quoter::Single_Query_Stock * const impl =
    dynamic_cast<POA_Quoter::Single_Query_Stock *> (servant);

  if (!impl)
    {
      throw ::CORBA::INTERNAL ();
    }

  get_price_and_names_Single_Query_Stock command (
    impl,
    server_request.operation_details (),
    args);
  
  TAO::Upcall_Wrapper upcall_wrapper;
  upcall_wrapper.upcall (server_request
                         , args
                         , nargs
                         , command
#if TAO_HAS_INTERCEPTORS == 1
                         , servant_upcall
                         , exceptions
                         , nexceptions
#endif  /* TAO_HAS_INTERCEPTORS == 1 */
                         );
}



// TAO_IDL - Generated from
// be/be_visitor_interface/interface_ss.cpp:163



::CORBA::Boolean POA_Quoter::Single_Query_Stock::_is_a (const char* value)
{
  return
    (
      ACE_OS::strcmp (
          value,
          "IDL:Quoter/Stock:1.0"
        ) == 0 ||
      ACE_OS::strcmp (
          value,
          "IDL:Quoter/Single_Query_Stock:1.0"
        ) == 0 ||
      !ACE_OS::strcmp (
          value,
          "IDL:omg.org/CORBA/Object:1.0"
        )
    );
}

const char* POA_Quoter::Single_Query_Stock::_interface_repository_id (void) const
{
  return "IDL:Quoter/Single_Query_Stock:1.0";
}

// TAO_IDL - Generated from
// be/be_visitor_interface/interface_ss.cpp:423

void POA_Quoter::Single_Query_Stock::_dispatch (
  TAO_ServerRequest & req,
  TAO::Portable_Server::Servant_Upcall* servant_upcall)
{
  this->synchronous_upcall_dispatch (req, servant_upcall, this);
}

// TAO_IDL - Generated from
// be/be_visitor_interface/interface_ss.cpp:370

Quoter::Single_Query_Stock *
POA_Quoter::Single_Query_Stock::_this (void)
{
  TAO_Stub *stub = this->_create_stub ();

  TAO_Stub_Auto_Ptr safe_stub (stub);
  ::CORBA::Object_ptr tmp = CORBA::Object_ptr ();

  ::CORBA::Boolean const _tao_opt_colloc =
    stub->servant_orb_var ()->orb_core ()->optimize_collocation_objects ();
  
  ACE_NEW_RETURN (
      tmp,
      ::CORBA::Object (stub, _tao_opt_colloc, this),
      0);
  
  ::CORBA::Object_var obj = tmp;
  (void) safe_stub.release ();

  typedef ::Quoter::Single_Query_Stock STUB_SCOPED_NAME;
  return
    TAO::Narrow_Utils<STUB_SCOPED_NAME>::unchecked_narrow (
        obj.in ());
}

// TAO_IDL - Generated from
// be/be_interface.cpp:1865

class TAO_Quoter_AMI_Single_Query_StockHandler_Perfect_Hash_OpTable
  : public TAO_Perfect_Hash_OpTable
{
private:
  unsigned int hash (const char *str, unsigned int len);

public:
  const TAO_operation_db_entry * lookup (const char *str, unsigned int len);
};

/* C++ code produced by gperf version 2.8 (ACE version) */
/* Command-line: /xusr/Repository/tao/src/ACE_wrappers/bin/ace_gperf -m -M -J -c -C -D -E -T -f 0 -F 0,0 -a -o -t -p -K opname -L C++ -Z TAO_Quoter_AMI_Single_Query_StockHandler_Perfect_Hash_OpTable -N lookup  */
unsigned int
TAO_Quoter_AMI_Single_Query_StockHandler_Perfect_Hash_OpTable::hash (const char *str, unsigned int len)
{
  static const unsigned char asso_values[] =
    {
     26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
     26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
     26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
     26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
     26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
     26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
     26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
     26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
     26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
     26, 26, 26, 26, 26,  0, 26,  4, 26, 26,
      0,  0, 26,  0, 26, 26, 26, 26, 10, 26,
     26, 26,  0, 26, 26,  5,  5, 26, 26, 26,
     26, 26, 26, 26, 26, 26, 26, 26,
    };
  return len + asso_values[static_cast<int>(str[len - 1])] + asso_values[static_cast<int>(str[0])];
}

const TAO_operation_db_entry *
TAO_Quoter_AMI_Single_Query_StockHandler_Perfect_Hash_OpTable::lookup (const char *str, unsigned int len)
{
  enum
    {
      TOTAL_KEYWORDS = 13,
      MIN_WORD_LENGTH = 5,
      MAX_WORD_LENGTH = 25,
      MIN_HASH_VALUE = 5,
      MAX_HASH_VALUE = 25,
      HASH_VALUE_RANGE = 21,
      DUPLICATES = 0,
      WORDLIST_SIZE = 18
    };

  static const TAO_operation_db_entry wordlist[] =
    {
      {"",0,0},{"",0,0},{"",0,0},{"",0,0},{"",0,0},
      {"price", &POA_Quoter::AMI_StockHandler::price_skel, 0},
      {"",0,0},{"",0,0},{"",0,0},
      {"_is_a", &TAO_ServantBase::_is_a_thru_poa_skel, 0},
      {"_interface", &TAO_ServantBase::_interface_skel, 0},
      {"price_excep", &POA_Quoter::AMI_StockHandler::price_excep_skel, 0},
      {"",0,0},
      {"get_full_name", &POA_Quoter::AMI_StockHandler::get_full_name_skel, 0},
      {"_repository_id", &TAO_ServantBase::_repository_id_thru_poa_skel, 0},
      {"_component", &TAO_ServantBase::_component_thru_poa_skel, 0},
      {"get_symbol_excep", &POA_Quoter::AMI_StockHandler::get_symbol_excep_skel, 0},
      {"",0,0},
      {"_non_existent", &TAO_ServantBase::_non_existent_thru_poa_skel, 0},
      {"get_full_name_excep", &POA_Quoter::AMI_StockHandler::get_full_name_excep_skel, 0},
      {"get_symbol", &POA_Quoter::AMI_StockHandler::get_symbol_skel, 0},
      {"",0,0},{"",0,0},{"",0,0},
      {"get_price_and_names", &POA_Quoter::AMI_Single_Query_StockHandler::get_price_and_names_skel, 0},
      {"get_price_and_names_excep", &POA_Quoter::AMI_Single_Query_StockHandler::get_price_and_names_excep_skel, 0},
    };

  if (len <= MAX_WORD_LENGTH && len >= MIN_WORD_LENGTH)
    {
      unsigned int key = hash (str, len);

      if (key <= MAX_HASH_VALUE && key >= MIN_HASH_VALUE)
        {
          const char *s = wordlist[key].opname;

          if (*str == *s && !ACE_OS::strncmp (str + 1, s + 1, len - 1))
            return &wordlist[key];
        }
    }
  return 0;
}

static TAO_Quoter_AMI_Single_Query_StockHandler_Perfect_Hash_OpTable tao_Quoter_AMI_Single_Query_StockHandler_optable;

// TAO_IDL - Generated from
// be/be_visitor_interface/interface_ss.cpp:90

POA_Quoter::AMI_Single_Query_StockHandler::AMI_Single_Query_StockHandler (void)
  : TAO_ServantBase ()
{
  this->optable_ = &tao_Quoter_AMI_Single_Query_StockHandler_optable;
}

POA_Quoter::AMI_Single_Query_StockHandler::AMI_Single_Query_StockHandler (const AMI_Single_Query_StockHandler& rhs)
  : TAO_Abstract_ServantBase (rhs),
    TAO_ServantBase (rhs),
    ::POA_Messaging::ReplyHandler (rhs),
    POA_Quoter::AMI_StockHandler (rhs)
{
}

POA_Quoter::AMI_Single_Query_StockHandler::~AMI_Single_Query_StockHandler (void)
{
}

namespace POA_Quoter
{
  

  // TAO_IDL - Generated from
  // be/be_visitor_operation/upcall_command_ss.cpp:80

  class get_price_and_names_AMI_Single_Query_StockHandler
    : public TAO::Upcall_Command
  {
  public:
    inline get_price_and_names_AMI_Single_Query_StockHandler (
      POA_Quoter::AMI_Single_Query_StockHandler * servant,
      TAO_Operation_Details const * operation_details,
      TAO::Argument * const args[])
      : servant_ (servant)
        , operation_details_ (operation_details)
        , args_ (args)
    {
    }

    virtual void execute (void)
    {
      TAO::SArg_Traits< ::CORBA::Double>::in_arg_type arg_1 =
        TAO::Portable_Server::get_in_arg< ::CORBA::Double> (
          this->operation_details_,
          this->args_,
          1);
        
      TAO::SArg_Traits< char *>::in_arg_type arg_2 =
        TAO::Portable_Server::get_in_arg< char *> (
          this->operation_details_,
          this->args_,
          2);
        
      TAO::SArg_Traits< char *>::in_arg_type arg_3 =
        TAO::Portable_Server::get_in_arg< char *> (
          this->operation_details_,
          this->args_,
          3);
        
      this->servant_->get_price_and_names (
        arg_1
        , arg_2
        , arg_3);
    }
  
  private:
    POA_Quoter::AMI_Single_Query_StockHandler * const servant_;
    TAO_Operation_Details const * const operation_details_;
    TAO::Argument * const * const args_;
  };
}

// TAO_IDL - Generated from
// be/be_visitor_operation/operation_ss.cpp:168

void POA_Quoter::AMI_Single_Query_StockHandler::get_price_and_names_skel (
  TAO_ServerRequest & server_request,
  TAO::Portable_Server::Servant_Upcall *TAO_INTERCEPTOR (servant_upcall),
  TAO_ServantBase *servant)
{
#if TAO_HAS_INTERCEPTORS == 1
  static ::CORBA::TypeCode_ptr const * const exceptions = 0;
  static ::CORBA::ULong const nexceptions = 0;
#endif /* TAO_HAS_INTERCEPTORS */

  TAO::SArg_Traits< void>::ret_val retval;
  TAO::SArg_Traits< ::CORBA::Double>::in_arg_val _tao_ami_return_val;
  TAO::SArg_Traits< char *>::in_arg_val _tao_symbol;
  TAO::SArg_Traits< char *>::in_arg_val _tao_full_name;

  TAO::Argument * const args[] =
    {
      &retval,
      &_tao_ami_return_val,
      &_tao_symbol,
      &_tao_full_name
    };
  
  static size_t const nargs = 4;

  POA_Quoter::AMI_Single_Query_StockHandler * const impl =
    dynamic_cast<POA_Quoter::AMI_Single_Query_StockHandler *> (servant);

  if (!impl)
    {
      throw ::CORBA::INTERNAL ();
    }

  get_price_and_names_AMI_Single_Query_StockHandler command (
    impl,
    server_request.operation_details (),
    args);
  
  TAO::Upcall_Wrapper upcall_wrapper;
  upcall_wrapper.upcall (server_request
                         , args
                         , nargs
                         , command
#if TAO_HAS_INTERCEPTORS == 1
                         , servant_upcall
                         , exceptions
                         , nexceptions
#endif  /* TAO_HAS_INTERCEPTORS == 1 */
                         );
}


namespace POA_Quoter
{
  

  // TAO_IDL - Generated from
  // be/be_visitor_operation/upcall_command_ss.cpp:80

  class get_price_and_names_excep_AMI_Single_Query_StockHandler
    : public TAO::Upcall_Command
  {
  public:
    inline get_price_and_names_excep_AMI_Single_Query_StockHandler (
      POA_Quoter::AMI_Single_Query_StockHandler * servant,
      TAO_Operation_Details const * operation_details,
      TAO::Argument * const args[])
      : servant_ (servant)
        , operation_details_ (operation_details)
        , args_ (args)
    {
    }

    virtual void execute (void)
    {
      TAO::SArg_Traits< ::Messaging::ExceptionHolder>::in_arg_type arg_1 =
        TAO::Portable_Server::get_in_arg< ::Messaging::ExceptionHolder> (
          this->operation_details_,
          this->args_,
          1);
        
      this->servant_->get_price_and_names_excep (
        arg_1);
    }
  
  private:
    POA_Quoter::AMI_Single_Query_StockHandler * const servant_;
    TAO_Operation_Details const * const operation_details_;
    TAO::Argument * const * const args_;
  };
}

// TAO_IDL - Generated from
// be/be_visitor_operation/operation_ss.cpp:168

void POA_Quoter::AMI_Single_Query_StockHandler::get_price_and_names_excep_skel (
  TAO_ServerRequest & server_request,
  TAO::Portable_Server::Servant_Upcall *TAO_INTERCEPTOR (servant_upcall),
  TAO_ServantBase *servant)
{
#if TAO_HAS_INTERCEPTORS == 1
  static ::CORBA::TypeCode_ptr const * const exceptions = 0;
  static ::CORBA::ULong const nexceptions = 0;
#endif /* TAO_HAS_INTERCEPTORS */

  TAO::SArg_Traits< void>::ret_val retval;
  TAO::SArg_Traits< ::Messaging::ExceptionHolder>::in_arg_val _tao_excep_holder;

  TAO::Argument * const args[] =
    {
      &retval,
      &_tao_excep_holder
    };
  
  static size_t const nargs = 2;

  POA_Quoter::AMI_Single_Query_StockHandler * const impl =
    dynamic_cast<POA_Quoter::AMI_Single_Query_StockHandler *> (servant);

  if (!impl)
    {
      throw ::CORBA::INTERNAL ();
    }

  get_price_and_names_excep_AMI_Single_Query_StockHandler command (
    impl,
    server_request.operation_details (),
    args);
  
  TAO::Upcall_Wrapper upcall_wrapper;
  upcall_wrapper.upcall (server_request
                         , args
                         , nargs
                         , command
#if TAO_HAS_INTERCEPTORS == 1
                         , servant_upcall
                         , exceptions
                         , nexceptions
#endif  /* TAO_HAS_INTERCEPTORS == 1 */
                         );
}



// TAO_IDL - Generated from
// be/be_visitor_interface/interface_ss.cpp:163



::CORBA::Boolean POA_Quoter::AMI_Single_Query_StockHandler::_is_a (const char* value)
{
  return
    (
      ACE_OS::strcmp (
          value,
          "IDL:omg.org/Messaging/ReplyHandler:1.0"
        ) == 0 ||
      ACE_OS::strcmp (
          value,
          "IDL:Quoter/AMI_StockHandler:1.0"
        ) == 0 ||
      ACE_OS::strcmp (
          value,
          "IDL:Quoter/AMI_Single_Query_StockHandler:1.0"
        ) == 0 ||
      !ACE_OS::strcmp (
          value,
          "IDL:omg.org/CORBA/Object:1.0"
        )
    );
}

const char* POA_Quoter::AMI_Single_Query_StockHandler::_interface_repository_id (void) const
{
  return "IDL:Quoter/AMI_Single_Query_StockHandler:1.0";
}

// TAO_IDL - Generated from
// be/be_visitor_interface/interface_ss.cpp:423

void POA_Quoter::AMI_Single_Query_StockHandler::_dispatch (
  TAO_ServerRequest & req,
  TAO::Portable_Server::Servant_Upcall* servant_upcall)
{
  this->synchronous_upcall_dispatch (req, servant_upcall, this);
}

// TAO_IDL - Generated from
// be/be_visitor_interface/interface_ss.cpp:370

Quoter::AMI_Single_Query_StockHandler *
POA_Quoter::AMI_Single_Query_StockHandler::_this (void)
{
  TAO_Stub *stub = this->_create_stub ();

  TAO_Stub_Auto_Ptr safe_stub (stub);
  ::CORBA::Object_ptr tmp = CORBA::Object_ptr ();

  ::CORBA::Boolean const _tao_opt_colloc =
    stub->servant_orb_var ()->orb_core ()->optimize_collocation_objects ();
  
  ACE_NEW_RETURN (
      tmp,
      ::CORBA::Object (stub, _tao_opt_colloc, this),
      0);
  
  ::CORBA::Object_var obj = tmp;
  (void) safe_stub.release ();

  typedef ::Quoter::AMI_Single_Query_StockHandler STUB_SCOPED_NAME;
  return
    TAO::Narrow_Utils<STUB_SCOPED_NAME>::unchecked_narrow (
        obj.in ());
}

#endif /* ifndef */

