/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.util;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.app.action.impl.view.TGOpenViewAction;
import org.herac.tuxguitar.app.helper.TGFileHistory;
import org.herac.tuxguitar.app.view.dialog.file.TGFileChooserDialog;
import org.herac.tuxguitar.app.view.dialog.file.TGFileChooserDialogController;
import org.herac.tuxguitar.app.view.dialog.file.TGFileChooserHandler;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.io.base.TGFileFormat;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.singleton.TGSingletonFactory;
import org.herac.tuxguitar.util.singleton.TGSingletonUtil;

public class TGFileChooser {
    public static final String DEFAULT_OPEN_FILENAME = null;
    public static final String DEFAULT_SAVE_FILENAME = "Untitled.tg";
    public static TGFileFormat ALL_FORMATS = new TGFileFormat("All Files", "*/*", new String[]{"*"});
    private TGContext context;

    private TGFileChooser(TGContext context) {
        this.context = context;
    }

    public void openChooser(TGFileChooserHandler handler, List<TGFileFormat> formats, Integer style, String fileName, String chooserPath, String defaultExtension) {
        TGActionProcessor tgActionProcessor = new TGActionProcessor(this.context, "action.gui.open-view");
        tgActionProcessor.setAttribute(TGOpenViewAction.ATTRIBUTE_CONTROLLER, (Object)new TGFileChooserDialogController());
        tgActionProcessor.setAttribute(TGFileChooserDialog.ATTRIBUTE_HANDLER, (Object)handler);
        tgActionProcessor.setAttribute("style", (Object)style);
        tgActionProcessor.setAttribute("chooserPath", (Object)chooserPath);
        tgActionProcessor.setAttribute("fileFormats", formats);
        tgActionProcessor.setAttribute("fileName", (Object)fileName);
        tgActionProcessor.setAttribute("defaultExtension", (Object)defaultExtension);
        tgActionProcessor.process();
    }

    public void openChooser(TGFileChooserHandler handler, TGFileFormat format, Integer style, String fileName, String chooserPath, String defaultExtension) {
        this.openChooser(handler, this.toFileFormatList(format), style, fileName, chooserPath, defaultExtension);
    }

    public void openChooser(TGFileChooserHandler handler, List<TGFileFormat> formats, Integer style, String fileName, String chooserPath) {
        this.openChooser(handler, formats, style, fileName, chooserPath, null);
    }

    public void openChooser(TGFileChooserHandler handler, TGFileFormat format, Integer style, String fileName, String chooserPath) {
        this.openChooser(handler, this.toFileFormatList(format), style, fileName, chooserPath);
    }

    public void openChooser(TGFileChooserHandler handler, List<TGFileFormat> formats, Integer style, String fileName) {
        this.openChooser(handler, formats, style, fileName, this.getDefaultChooserPath());
    }

    public void openChooser(TGFileChooserHandler handler, TGFileFormat format, Integer style, String fileName) {
        this.openChooser(handler, format, style, fileName, this.getDefaultChooserPath());
    }

    public void openChooser(TGFileChooserHandler handler, List<TGFileFormat> formats, Integer style) {
        this.openChooser(handler, formats, style, null);
    }

    public void openChooser(TGFileChooserHandler handler, TGFileFormat format, Integer style) {
        this.openChooser(handler, format, style, null);
    }

    public List<TGFileFormat> toFileFormatList(TGFileFormat format) {
        ArrayList<TGFileFormat> formats = new ArrayList<TGFileFormat>();
        formats.add(format);
        return formats;
    }

    public String getDefaultChooserPath() {
        return TGFileHistory.getInstance(this.context).getChooserPath();
    }

    public static TGFileChooser getInstance(TGContext context) {
        return (TGFileChooser)TGSingletonUtil.getInstance((TGContext)context, (String)TGFileChooser.class.getName(), (TGSingletonFactory)new TGSingletonFactory<TGFileChooser>(){

            public TGFileChooser createInstance(TGContext context) {
                return new TGFileChooser(context);
            }
        });
    }
}

