/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.toolbar.main;

import org.herac.tuxguitar.app.view.toolbar.main.TGMainToolBar;
import org.herac.tuxguitar.app.view.toolbar.main.TGMainToolBarSection;
import org.herac.tuxguitar.editor.undo.TGUndoableManager;
import org.herac.tuxguitar.player.base.MidiPlayer;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.toolbar.UIToolActionItem;
import org.herac.tuxguitar.util.TGContext;

public class TGMainToolBarSectionEdit
extends TGMainToolBarSection {
    private UIToolActionItem undo;
    private UIToolActionItem redo;

    public TGMainToolBarSectionEdit(TGMainToolBar toolBar) {
        super(toolBar);
    }

    @Override
    public void createSection() {
        this.undo = this.getToolBar().getControl().createActionItem();
        this.undo.addSelectionListener((UISelectionListener)this.createActionProcessor("action.edit.undo"));
        this.redo = this.getToolBar().getControl().createActionItem();
        this.redo.addSelectionListener((UISelectionListener)this.createActionProcessor("action.edit.redo"));
        this.loadIcons();
        this.loadProperties();
    }

    @Override
    public void updateItems() {
        boolean running = MidiPlayer.getInstance((TGContext)this.getToolBar().getContext()).isRunning();
        TGUndoableManager undoableManager = TGUndoableManager.getInstance((TGContext)this.getToolBar().getContext());
        this.undo.setEnabled(!running && undoableManager.canUndo());
        this.redo.setEnabled(!running && undoableManager.canRedo());
    }

    @Override
    public void loadProperties() {
        this.undo.setToolTipText(this.getText("edit.undo"));
        this.redo.setToolTipText(this.getText("edit.redo"));
    }

    @Override
    public void loadIcons() {
        this.undo.setImage(this.getIconManager().getEditUndo());
        this.redo.setImage(this.getIconManager().getEditRedo());
    }
}

