/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.impl.jsa.assistant;

import java.io.File;
import java.net.URL;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.system.icons.TGIconManager;
import org.herac.tuxguitar.app.ui.TGApplication;
import org.herac.tuxguitar.app.util.TGFileUtils;
import org.herac.tuxguitar.app.view.main.TGWindow;
import org.herac.tuxguitar.app.view.util.TGDialogUtil;
import org.herac.tuxguitar.player.impl.jsa.assistant.SBInstaller;
import org.herac.tuxguitar.player.impl.jsa.assistant.SBInstallerlistener;
import org.herac.tuxguitar.player.impl.jsa.midiport.MidiPortSynthesizer;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.event.UIDisposeEvent;
import org.herac.tuxguitar.ui.event.UIDisposeListener;
import org.herac.tuxguitar.ui.event.UISelectionEvent;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.layout.UILayout;
import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.resource.UIFont;
import org.herac.tuxguitar.ui.widget.UIButton;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UIImageView;
import org.herac.tuxguitar.ui.widget.UIIndeterminateProgressBar;
import org.herac.tuxguitar.ui.widget.UILabel;
import org.herac.tuxguitar.ui.widget.UIPanel;
import org.herac.tuxguitar.ui.widget.UIWindow;
import org.herac.tuxguitar.ui.widget.UIWrapLabel;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.TGException;
import org.herac.tuxguitar.util.TGSynchronizer;
import org.herac.tuxguitar.util.error.TGErrorManager;

public class SBInstallerGui
implements SBInstallerlistener {
    private static final String SB_PATH = TGFileUtils.PATH_USER_PLUGINS_CONFIG + File.separator + "tuxguitar-jsa";
    private TGContext context;
    private UIWindow dialog;
    private UILabel progressLabel;
    private SBInstaller installer;

    public SBInstallerGui(TGContext context, URL url, MidiPortSynthesizer synthesizer) {
        this.context = context;
        this.initInstaller(url, synthesizer);
    }

    public void initInstaller(URL url, MidiPortSynthesizer synthesizer) {
        File tmpPath = new File(SB_PATH);
        File dstPath = new File(SB_PATH);
        if (!tmpPath.exists()) {
            tmpPath.mkdirs();
        }
        if (!dstPath.exists()) {
            dstPath.mkdirs();
        }
        this.installer = new SBInstaller(this.context, url, tmpPath, dstPath, synthesizer, this);
    }

    public void open() {
        UIFactory uiFactory = TGApplication.getInstance((TGContext)this.context).getFactory();
        UIWindow uiParent = TGWindow.getInstance((TGContext)this.context).getWindow();
        UITableLayout dialogLayout = new UITableLayout();
        this.dialog = uiFactory.createWindow(uiParent, true, false);
        this.dialog.setLayout((UILayout)dialogLayout);
        UITableLayout headerLayout = new UITableLayout();
        UIPanel header = uiFactory.createPanel((UIContainer)this.dialog, false);
        header.setLayout((UILayout)headerLayout);
        dialogLayout.set((UIControl)header, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_TOP, Boolean.valueOf(true), Boolean.valueOf(false));
        UIImageView headerImage = uiFactory.createImageView((UIContainer)header);
        headerImage.setImage(TGIconManager.getInstance((TGContext)this.context).getStatusInfo());
        headerLayout.set((UIControl)headerImage, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_LEFT, UITableLayout.ALIGN_TOP, Boolean.valueOf(false), Boolean.valueOf(false));
        UIWrapLabel headerTip = uiFactory.createWrapLabel((UIContainer)header);
        headerTip.setText(TuxGuitar.getProperty((String)"jsa.soundbank-assistant.process.tip"));
        headerLayout.set((UIControl)headerTip, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false));
        UIFont defaultFont = headerTip.getFont();
        if (defaultFont != null) {
            final UIFont font = uiFactory.createFont(defaultFont.getName(), defaultFont.getHeight(), true, false);
            headerTip.setFont(font);
            headerTip.addDisposeListener(new UIDisposeListener(){

                public void onDispose(UIDisposeEvent event) {
                    font.dispose();
                }
            });
        }
        UITableLayout compositeLayout = new UITableLayout();
        UIPanel composite = uiFactory.createPanel((UIContainer)this.dialog, false);
        composite.setLayout((UILayout)compositeLayout);
        dialogLayout.set((UIControl)composite, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UIIndeterminateProgressBar progressBar = uiFactory.createIndeterminateProgressBar((UIContainer)composite);
        compositeLayout.set((UIControl)progressBar, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false));
        this.progressLabel = uiFactory.createLabel((UIContainer)composite);
        compositeLayout.set((UIControl)this.progressLabel, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false));
        UITableLayout buttonsLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel buttons = uiFactory.createPanel((UIContainer)this.dialog, false);
        buttons.setLayout((UILayout)buttonsLayout);
        dialogLayout.set((UIControl)buttons, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(false));
        UIButton buttonCancel = uiFactory.createButton((UIContainer)buttons);
        buttonCancel.setText(TuxGuitar.getProperty((String)"cancel"));
        buttonCancel.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                SBInstallerGui.this.getInstaller().setCancelled(true);
                SBInstallerGui.this.getDialog().dispose();
            }
        });
        buttonsLayout.set((UIControl)buttonCancel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        buttonsLayout.set((UIControl)buttonCancel, "margin_right", (Object)Float.valueOf(0.0f));
        this.process();
        TGDialogUtil.openDialog((UIWindow)this.dialog, (int)5);
    }

    private void process() {
        new Thread(new Runnable(){

            @Override
            public void run() throws TGException {
                if (!SBInstallerGui.this.isDisposed()) {
                    SBInstallerGui.this.getInstaller().process();
                }
            }
        }).start();
    }

    @Override
    public void notifyProcess(final String process) {
        if (!this.isDisposed()) {
            TGSynchronizer.getInstance((TGContext)this.context).executeLater(new Runnable(){

                @Override
                public void run() {
                    if (!SBInstallerGui.this.isDisposed()) {
                        SBInstallerGui.this.getProgressLabel().setText(process);
                    }
                }
            });
        }
    }

    @Override
    public void notifyFinish() {
        if (!this.isDisposed()) {
            TGSynchronizer.getInstance((TGContext)this.context).executeLater(new Runnable(){

                @Override
                public void run() {
                    if (!SBInstallerGui.this.isDisposed()) {
                        SBInstallerGui.this.getDialog().dispose();
                    }
                }
            });
        }
    }

    @Override
    public void notifyFailed(final Throwable throwable) {
        if (!this.isDisposed()) {
            TGSynchronizer.getInstance((TGContext)this.context).executeLater(new Runnable(){

                @Override
                public void run() {
                    if (!SBInstallerGui.this.isDisposed()) {
                        SBInstallerGui.this.getDialog().dispose();
                        TGErrorManager.getInstance((TGContext)SBInstallerGui.this.context).handleError(throwable);
                    }
                }
            });
        }
    }

    public boolean isDisposed() {
        return TuxGuitar.getInstance().isDisposed() || this.getDialog().isDisposed();
    }

    public UIWindow getDialog() {
        return this.dialog;
    }

    public UILabel getProgressLabel() {
        return this.progressLabel;
    }

    public SBInstaller getInstaller() {
        return this.installer;
    }
}

