/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.midi.synth;

import java.util.List;
import org.herac.tuxguitar.midi.synth.TGSynthExtension;
import org.herac.tuxguitar.midi.synth.TGSynthManager;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.plugin.TGPlugin;
import org.herac.tuxguitar.util.plugin.TGPluginException;

public abstract class TGSynthExtensionPlugin
implements TGPlugin {
    private List<TGSynthExtension<?>> extensions;

    public abstract List<TGSynthExtension<?>> createExtensions(TGContext var1) throws TGPluginException;

    public void connect(TGContext context) throws TGPluginException {
        try {
            if (this.extensions == null) {
                this.extensions = this.createExtensions(context);
                TGSynthManager synthManager = TGSynthManager.getInstance(context);
                for (TGSynthExtension<?> extension : this.extensions) {
                    synthManager.addExtension(extension.getExtensionClass(), extension.getExtension());
                }
            }
        }
        catch (Throwable throwable) {
            throw new TGPluginException(throwable.getMessage(), throwable);
        }
    }

    public void disconnect(TGContext context) throws TGPluginException {
        try {
            if (this.extensions != null) {
                TGSynthManager synthManager = TGSynthManager.getInstance(context);
                for (TGSynthExtension<?> extension : this.extensions) {
                    synthManager.removeExtension(extension.getExtensionClass(), extension.getExtension());
                }
                this.extensions = null;
            }
        }
        catch (Throwable throwable) {
            throw new TGPluginException(throwable.getMessage(), throwable);
        }
    }
}

